package Lire::SQLExt::LrFirst;

use strict;

sub new {
    my ( $class, $return_type ) = @_;

    # Copy
    if ( ref $class ) {
        return bless { %$class }, ref $class;
    } else {
        return bless {
                      '_value' => undef,
                      '_sort_str' => [],
                      '_sort_values' => [],
                      '_return' => $return_type || 'value',
                     }, shift;
    }
}

sub is_number {
    my $str = $_[0];

    no warnings 'numeric';

    return ($str + 0 eq $str);
}

sub _init_keys {
    my ( $self, $value, @keys ) = @_;

    my @types = ();
    for ( my $i=0; $i < @keys; $i++ ) {
        return unless defined $keys[$i];
        $types[$i] = is_number( $keys[$i] ) ? 0 : 1;
    }

    $self->{'_value'} = $value;
    $self->{'_sort_str'} =  \@types;
    $self->{'_sort_values'} = \@keys;

    return;
}

sub step {
    my ( $self, $value, @keys ) = @_;

    return unless defined $value;

    unless ( @keys ) {
        $self->{'_value'} = $value
          unless defined $self->{'_value'};
        return;
    }

    unless ( defined $self->{'_sort_str'}[0] ) {
        $self->_init_keys( $value, @keys );
        return;
    }

    for ( my $i = 0; $i < @keys; $i++) {
        my $val = $keys[$i];

        return undef unless defined $val;

        my $cmp_result;
        if ( ! $self->{'_sort_str'}[$i] && is_number( $val ) ) {
            $cmp_result = $val <=> $self->{'_sort_values'}[$i]
        } else {
            $self->{'_sort_str'}[$i] = 1;
            $cmp_result = $val cmp $self->{'_sort_values'}[$i]
        }

        return if $cmp_result == 1;
        last if $cmp_result == -1;
    }

    $self->{'_value'} = $value;
    $self->{'_sort_values'} = \@keys;

    return;
}

sub finalize {
    my $self = $_[0];

    if ( $self->{'_return'} eq 'key' ) {
        return join( " ", @{$self->{'_sort_values'}} );
    } else {
        return $self->{'_value'};
    }
}

1;

__END__

=pod

=head1 NAME

Lire::SQLExt::LrFirst - FILL ME IN

=head1 SYNOPSIS

  FILL ME IN

=head1 DESCRIPTION

  FILL ME IN

=head1 SEE ALSO

Lire::DlfConverter(3pm)

=head1 VERSION

$Id: LrFirst.pm,v 1.4 2006/07/23 13:16:31 vanbaal Exp $

=head1 AUTHOR

Francis J. Lacoste <flacoste@logreport.org>

=head1 COPYRIGHT

Copyright (C) 2002 Stichting LogReport Foundation LogReport@LogReport.org

This file is part of Lire.

Lire is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program (see COPYING); if not, check with
http://www.gnu.org/copyleft/gpl.html.

=cut

