/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.tagging.presets.items;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openstreetmap.josm.data.osm.Tag;
import org.openstreetmap.josm.data.osm.search.SearchCompiler;
import org.openstreetmap.josm.data.osm.search.SearchParseError;
import org.openstreetmap.josm.data.osm.search.SearchSetting;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPresetItem;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPresetItemGuiSupport;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPresetType;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.xml.sax.SAXException;

public class Roles
extends TaggingPresetItem {
    public final List<Role> roles = new ArrayList<Role>(2);

    @Override
    public boolean addToPanel(JPanel p, TaggingPresetItemGuiSupport support) {
        p.add((Component)new JLabel(" "), GBC.eol());
        if (!this.roles.isEmpty()) {
            JPanel proles = new JPanel(new GridBagLayout());
            proles.add((Component)new JLabel(I18n.tr("Available roles", new Object[0])), GBC.std().insets(0, 0, 10, 0));
            proles.add((Component)new JLabel(I18n.tr("role", new Object[0])), GBC.std().insets(0, 0, 10, 0));
            proles.add((Component)new JLabel(I18n.tr("count", new Object[0])), GBC.std().insets(0, 0, 10, 0));
            proles.add((Component)new JLabel(I18n.tr("elements", new Object[0])), GBC.eol());
            for (Role i : this.roles) {
                i.addToPanel(proles);
            }
            proles.applyComponentOrientation(support.getDefaultComponentOrientation());
            p.add((Component)proles, GBC.eol());
        }
        return false;
    }

    @Override
    public void addCommands(List<Tag> changedTags) {
    }

    public String toString() {
        return "Roles [roles=" + this.roles + "]";
    }

    public static class Role {
        public Set<TaggingPresetType> types;
        public String key;
        public boolean regexp;
        public String text;
        public String text_context;
        public String locale_text;
        public SearchCompiler.Match memberExpression;
        public boolean required;
        private short count;

        public void setType(String types) throws SAXException {
            this.types = Roles.getType(types);
        }

        public void setRequisite(String str) throws SAXException {
            if ("required".equals(str)) {
                this.required = true;
            } else if (!"optional".equals(str)) {
                throw new SAXException(I18n.tr("Unknown requisite: {0}", str));
            }
        }

        public void setRegexp(String str) throws SAXException {
            if ("true".equals(str)) {
                this.regexp = true;
            } else if (!"false".equals(str)) {
                throw new SAXException(I18n.tr("Unknown regexp value: {0}", str));
            }
        }

        public void setMember_expression(String memberExpression) throws SAXException {
            try {
                SearchSetting searchSetting = new SearchSetting();
                searchSetting.text = memberExpression;
                searchSetting.caseSensitive = true;
                searchSetting.regexSearch = true;
                this.memberExpression = SearchCompiler.compile(searchSetting);
            }
            catch (SearchParseError ex) {
                throw new SAXException(I18n.tr("Illegal member expression: {0}", ex.getMessage()), ex);
            }
        }

        public void setCount(String count) {
            this.count = Short.parseShort(count);
        }

        public long getValidCount(long c) {
            if (this.count > 0 && !this.required) {
                return c != 0L ? (long)this.count : 0L;
            }
            if (this.count > 0) {
                return this.count;
            }
            if (!this.required) {
                return c != 0L ? c : 0L;
            }
            return c != 0L ? c : 1L;
        }

        public boolean isRole(String role) {
            if (this.regexp && role != null) {
                return role.matches(this.key);
            }
            return this.key.equals(role);
        }

        public boolean addToPanel(JPanel p) {
            Object cstring = this.count > 0 && !this.required ? "0," + this.count : (this.count > 0 ? String.valueOf(this.count) : (!this.required ? "0-..." : "1-..."));
            if (this.locale_text == null) {
                this.locale_text = Roles.getLocaleText(this.text, this.text_context, null);
            }
            p.add((Component)new JLabel(this.locale_text + ":"), GBC.std().insets(0, 0, 10, 0));
            p.add((Component)new JLabel(this.key), GBC.std().insets(0, 0, 10, 0));
            p.add((Component)new JLabel((String)cstring), this.types == null ? GBC.eol() : GBC.std().insets(0, 0, 10, 0));
            if (this.types != null) {
                JPanel pp = new JPanel();
                for (TaggingPresetType t : this.types) {
                    pp.add(new JLabel(ImageProvider.get(t.getIconName())));
                }
                p.add((Component)pp, GBC.eol());
            }
            return true;
        }

        public String toString() {
            return "Role [key=" + this.key + ", text=" + this.text + "]";
        }
    }
}

