#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 hledger-web
version:              1.32.1
visibility:           public
id:                   hledger-web-1.32.1-IQJ1pseLcai7fehHhw8CKh
key:                  hledger-web-1.32.1-IQJ1pseLcai7fehHhw8CKh
license:              GPL-3.0-only
maintainer:           Simon Michael <simon@joyful.com>
author:               Simon Michael <simon@joyful.com>
stability:            stable
homepage:             http://hledger.org
synopsis:             Web user interface for the hledger accounting system
description:
    A simple web user interface for the hledger accounting system,
    providing a more modern UI than the command-line or terminal interfaces.
    It can be used as a local single-user UI, or as a multi-user UI for
    viewing\/adding\/editing on the web.

    hledger is a robust, cross-platform set of tools for tracking money,
    time, or any other commodity, using double-entry accounting and a
    simple, editable file format, with command-line, terminal and web
    interfaces. It is a Haskell rewrite of Ledger, and one of the leading
    implementations of Plain Text Accounting. Read more at:
    <https://hledger.org>

category:             Finance
abi:                  04463f10c467a1fcda5d3fd1ef795de4
exposed:              True
exposed-modules:
    Hledger.Web Hledger.Web.Application Hledger.Web.Import
    Hledger.Web.Main Hledger.Web.Test Hledger.Web.WebOptions

hidden-modules:
    Hledger.Web.Foundation Hledger.Web.Handler.AddR
    Hledger.Web.Handler.EditR Hledger.Web.Handler.JournalR
    Hledger.Web.Handler.MiscR Hledger.Web.Handler.RegisterR
    Hledger.Web.Handler.UploadR Hledger.Web.Settings
    Hledger.Web.Settings.StaticFiles Hledger.Web.Widget.AddForm
    Hledger.Web.Widget.Common Paths_hledger_web

import-dirs:          /usr/lib/ghc-9.4.8/site-local/hledger-web-1.32.1
library-dirs:         /usr/lib/ghc-9.4.8/site-local/hledger-web-1.32.1
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/hledger-web-1.32.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/hledger-web
hs-libraries:         HShledger-web-1.32.1-IQJ1pseLcai7fehHhw8CKh
depends:
    Decimal-0.5.2-EvRcqUIPT9uHP0LYQhNTSg
    aeson-2.1.2.1-H9spCVKCz3aBZuysSTfrjv base-4.17.2.1
    base64-0.4.2.4-31WPpcDxxba703UJmwu2og
    blaze-html-0.9.2.0-7T5tBdPknWXDUJ5NeSXWzj
    blaze-markup-0.8.3.0-4zGQB5UMO8P5hF725cGajZ bytestring-0.11.5.3
    case-insensitive-1.2.1.0-FZkso54i68UDZy9QWLkbnV
    clientsession-0.9.2.0-GSmhzvB6LHA65VE2XMNPs0
    cmdargs-0.10.22-KMcxPO0UszDDPT8hI73uO5
    conduit-1.3.6.1-GHyJy0fEO4I5Y3sMB26bfT
    conduit-extra-1.3.7-IZqbdwWCIVBKlmFf1WuGHS containers-0.6.7
    data-default-0.7.1.1-HuI8bY4bNR4F11jcRg6vOi directory-1.3.7.1
    extra-1.7.16-G4xNEo2ejjd3lhwl24aWT4 filepath-1.4.2.2
    hjsmin-0.2.1-BuVRcwWHvh4ERZy7VZxQnz
    hledger-1.32.1-9372qilOyWu9DSH6djKU3R
    hledger-lib-1.32.1-2Gte7CCcPiUJeVXAQoyGOn
    hspec-2.10.9-LrKv2WLw3ll63lZh5sx0BW
    http-client-0.7.18-163W4AHWMZxiWwErxEeuv
    http-conduit-2.3.9.1-G9skUe0R0eKFLtgtZaUIye
    http-types-0.12.4-HMggM4fmSOHB2iuVefoAXW
    megaparsec-9.6.1-KkOPmPbRCEmCvB2XbKT9En mtl-2.2.2
    network-3.1.4.0-6CSLlS2XYBeLlFfm0MgCfu
    safe-0.3.21-D0Qa6qmXFrgLhocJR17U7j
    shakespeare-2.1.0.1-9xRqfg6Rm8d6zsejEr0C1H
    template-haskell-2.19.0.0 text-2.0.2 time-1.12.2
    transformers-0.5.6.2 unix-compat-0.7.3-APGBQbQVvi2H82Ka3k4LXj
    unordered-containers-0.2.20-L3M6eILO3KM5ipeNJik2xY
    utf8-string-1.0.2-D0oARDqSiCF3CIA0pPBIDm
    wai-3.2.4-Di5htLW1xGuJXvFRCFw5eQ
    wai-cors-0.2.7-KjspATE2XhxC0ANFuWeYHh
    wai-extra-3.1.17-6Elr5GCdL8AIJxBrINbOXC
    wai-handler-launch-3.0.3.1-3KAioVyeMCr8AuwRxw8dCC
    warp-3.3.30-FPsB8aIAAJO7xjP2wF2tIg
    yaml-0.11.11.2-D1kIggkOAtBBnhgc0kzINw
    yesod-1.6.2.1-I9iIOips8kY3VHVqUVhyw7
    yesod-core-1.6.27.0-J8Dlyu7FCsi2VjOWjBkpHX
    yesod-form-1.7.9-Bj7Dve53KVgHt66yl4AeDT
    yesod-static-1.6.1.0-1CZiVOgQIK4BsokG3PuJj0
    yesod-test-1.6.22-IhelxifL0wJ8A1gr9bvYY4

haddock-interfaces:   /usr/share/doc/hledger-web/html/hledger-web.haddock
haddock-html:         /usr/share/doc/hledger-web/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

