#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 timezone-olson
version:              0.2.1
visibility:           public
id:                   timezone-olson-0.2.1-BTp5R7q1AJdEnV7pV8RSLq
key:                  timezone-olson-0.2.1-BTp5R7q1AJdEnV7pV8RSLq
license:              BSD-3-Clause
copyright:            Copyright (c) 2010-2021 Yitzchak Gale. All rights reserved.
maintainer:           yitz@sefer.org
author:               Yitzchak Gale
homepage:             http://projects.haskell.org/time-ng/
synopsis:
    A pure Haskell parser and renderer for binary Olson timezone files

description:
    A parser and renderer for binary Olson timezone
    files whose format is specified by the tzfile(5)
    man page on Unix-like systems. For more
    information about this format, see
    <http://www.iana.org/time-zones/repository/tz-link.html>.
    Functions are provided for converting the parsed data into
    '\''TimeZoneSeries'\'' objects from the timezone-series
    package. On many platforms, binary Olson timezone
    files suitable for use with this package are
    available in the directory /usr/share/zoneinfo
    and its subdirectories on your computer.
    For a way to read binary Olson timezone files at compile
    time, see the timezone-olson-th package
    (<http://hackage.haskell.org/package/timezone-olson-th>).

category:             Data
abi:                  0a9f82b7ce6e0b0d91a9f66d85f252d6
exposed:              True
exposed-modules:
    Data.Time.LocalTime.TimeZone.Olson
    Data.Time.LocalTime.TimeZone.Olson.Parse
    Data.Time.LocalTime.TimeZone.Olson.Render
    Data.Time.LocalTime.TimeZone.Olson.Types

import-dirs:          /usr/lib/ghc-9.4.8/site-local/timezone-olson-0.2.1
library-dirs:         /usr/lib/ghc-9.4.8/site-local/timezone-olson-0.2.1
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/timezone-olson-0.2.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-timezone-olson
hs-libraries:         HStimezone-olson-0.2.1-BTp5R7q1AJdEnV7pV8RSLq
depends:
    base-4.17.2.1 binary-0.8.9.1 bytestring-0.11.5.3
    extensible-exceptions-0.1.1.4-AGheGT2ZUDiCzp52FHEfjQ time-1.12.2
    timezone-series-0.1.13-21o0dMYZobR86i3h6j9FWj

haddock-interfaces:
    /usr/share/doc/haskell-timezone-olson/html/timezone-olson.haddock

haddock-html:         /usr/share/doc/haskell-timezone-olson/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

