#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 retrie
version:              1.2.3
visibility:           public
id:                   retrie-1.2.3-5YN4hjSPe0b4jYNHedWPNt
key:                  retrie-1.2.3-5YN4hjSPe0b4jYNHedWPNt
license:              MIT
copyright:            Copyright (c) Facebook, Inc. and its affiliates.
maintainer:           Andrew Farmer <anfarmer@fb.com>
author:               Andrew Farmer <anfarmer@fb.com>
homepage:             https://github.com/facebookincubator/retrie
synopsis:             A powerful, easy-to-use codemodding tool for Haskell.
description:
    Retrie is a tool for codemodding Haskell. Key goals include:

    * Speed: Efficiently rewrite in large (>1 million line) codebases.
    * Safety: Avoids large classes of codemod-related errors.
    * Ease-of-use: Haskell syntax instead of regular expressions. No hand-rolled AST traversals.

    This package provides a command-line tool (@retrie@) and a library
    ("Retrie") for making equational edits to Haskell code.

    Please see the [README](#readme) for examples and usage.

category:             Development
abi:                  f141b5b27ea1bdf8e6bea912e3976a1b
exposed:              True
exposed-modules:
    Retrie Retrie.AlphaEnv Retrie.CPP Retrie.Context Retrie.Debug
    Retrie.Elaborate Retrie.ExactPrint Retrie.ExactPrint.Annotated
    Retrie.Expr Retrie.Fixity Retrie.FreeVars Retrie.GHC
    Retrie.GroundTerms Retrie.Monad Retrie.Options
    Retrie.PatternMap.Bag Retrie.PatternMap.Class
    Retrie.PatternMap.Instances Retrie.Pretty Retrie.Quantifiers
    Retrie.Query Retrie.Replace Retrie.Rewrites
    Retrie.Rewrites.Function Retrie.Rewrites.Patterns
    Retrie.Rewrites.Rules Retrie.Rewrites.Types Retrie.Run Retrie.SYB
    Retrie.Subst Retrie.Substitution Retrie.Types Retrie.Universe
    Retrie.Util

import-dirs:          /usr/lib/ghc-9.4.8/site-local/retrie-1.2.3
library-dirs:         /usr/lib/ghc-9.4.8/site-local/retrie-1.2.3
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/retrie-1.2.3
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-retrie
hs-libraries:         HSretrie-1.2.3-5YN4hjSPe0b4jYNHedWPNt
depends:
    ansi-terminal-1.0.2-6TxOAUbfOQrDbPnWIRhRhS
    async-2.2.5-7zRWRGcsDHK4x7TGVl8w2c base-4.17.2.1
    bytestring-0.11.5.3 containers-0.6.7
    data-default-0.7.1.1-HuI8bY4bNR4F11jcRg6vOi directory-1.3.7.1
    filepath-1.4.2.2 ghc-9.4.8
    ghc-exactprint-1.6.1-Fc7v2otRLFp1Ppopag9mZz
    list-t-1.0.5.5-3vhe4eDT1Nd96EvWTyiTg0 mtl-2.2.2
    optparse-applicative-0.17.1.0-4tPjpOfYmOi9nj8To0UB1j
    process-1.6.18.0 random-shuffle-0.0.4-6LJlpwpfpKlG1cgEwVUq0D
    syb-0.7.2.4-HJAbU0lurQkHN7nU4EHwhb text-2.0.2 transformers-0.5.6.2
    unordered-containers-0.2.20-L3M6eILO3KM5ipeNJik2xY

haddock-interfaces:   /usr/share/doc/haskell-retrie/html/retrie.haddock
haddock-html:         /usr/share/doc/haskell-retrie/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

