#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 lsp
version:              1.4.0.0
visibility:           public
id:                   lsp-1.4.0.0-A1dB0FqWSx6Kxu6W2igN2O
key:                  lsp-1.4.0.0-A1dB0FqWSx6Kxu6W2igN2O
license:              MIT
copyright:            Alan Zimmerman, 2016-2021
maintainer:           alan.zimm@gmail.com
author:               Alan Zimmerman
homepage:             https://github.com/haskell/lsp
synopsis:             Haskell library for the Microsoft Language Server Protocol
description:
    An implementation of the types, and basic message server to
    allow language implementors to support the Language Server
    Protocol for their specific language.

    An example of this is for Haskell via the Haskell Language
    Server, at https://github.com/haskell/haskell-language-server

category:             Development
abi:                  5bfa93941eb18430ca401ff6430a2aef
exposed:              True
exposed-modules:
    Language.LSP.Diagnostics, Language.LSP.Server,
    Language.LSP.Types from lsp-types-1.4.0.1-C9hxNWKujRZDj8xOMFlfH1:Language.LSP.Types,
    Language.LSP.Types.Capabilities from lsp-types-1.4.0.1-C9hxNWKujRZDj8xOMFlfH1:Language.LSP.Types.Capabilities,
    Language.LSP.Types.Lens from lsp-types-1.4.0.1-C9hxNWKujRZDj8xOMFlfH1:Language.LSP.Types.Lens,
    Language.LSP.VFS from lsp-types-1.4.0.1-C9hxNWKujRZDj8xOMFlfH1:Language.LSP.VFS

hidden-modules:
    Language.LSP.Server.Core Language.LSP.Server.Control
    Language.LSP.Server.Processing

import-dirs:          /usr/lib/ghc-9.4.8/site-local/lsp-1.4.0.0
library-dirs:         /usr/lib/ghc-9.4.8/site-local/lsp-1.4.0.0
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/lsp-1.4.0.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-lsp1.4
hs-libraries:         HSlsp-1.4.0.0-A1dB0FqWSx6Kxu6W2igN2O
depends:
    aeson-2.1.2.1-H9spCVKCz3aBZuysSTfrjv
    async-2.2.5-7zRWRGcsDHK4x7TGVl8w2c
    attoparsec-0.14.4-L0PdW4nkr6mJUEG3ZdEFXH base-4.17.2.1
    bytestring-0.11.5.3 containers-0.6.7
    data-default-0.7.1.1-HuI8bY4bNR4F11jcRg6vOi exceptions-0.10.5
    hashable-1.4.4.0-Jc2uKL4S7Fl9QLNJZYpfiY
    hslogger-1.3.1.2-HizOYagnRFdDuoLuue81te
    lens-5.2.3-GXFWsxB7RRtIGQiKpxuie1
    lsp-types-1.4.0.1-C9hxNWKujRZDj8xOMFlfH1 mtl-2.2.2
    network-uri-2.6.4.2-APaQU0Ye6OaKm6pWDY2rCG
    random-1.2.1.2-KXwyGxW8gFCDB692Rea4Jy
    scientific-0.3.7.0-I6iMwi20J4G9Jw2tSdEPEK
    sorted-list-0.2.3.1-AU3Mx2hFMru1MY9GtucRoM stm-2.5.1.0 text-2.0.2
    time-1.12.2 transformers-0.5.6.2
    unliftio-core-0.2.1.0-1JwPsdkrVim6892Z5vBeIT
    unordered-containers-0.2.20-L3M6eILO3KM5ipeNJik2xY
    uuid-1.3.16-DTXFgrb7MThGeAanhZvVIB

haddock-interfaces:   /usr/share/doc/haskell-lsp1.4/html/lsp.haddock
haddock-html:         /usr/share/doc/haskell-lsp1.4/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

