#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 hyphenation
version:              0.8.3
visibility:           public
id:                   hyphenation-0.8.3-DWiAlk8EYBnAkzPDGBHBqh
key:                  hyphenation-0.8.3-DWiAlk8EYBnAkzPDGBHBqh
license:              BSD-2-Clause
copyright:            (C) 2012-2019 Edward A. Kmett
maintainer:           Edward A. Kmett <ekmett@gmail.com>
author:               Edward A. Kmett
stability:            provisional
homepage:             http://github.com/ekmett/hyphenation
synopsis:             Configurable Knuth-Liang hyphenation
description:
    Configurable Knuth-Liang hyphenation

    Uses the UTF8 encoded hyphenation patterns provided by
    hyph-utf8 from
    <http://www.ctan.org/tex-archive/language/hyph-utf8>

    Usage:

    >>> hyphenate english_US "supercalifragilisticexpialadocious"
    ["su","per","cal","ifrag","ilis","tic","ex","pi","al","ado","cious"]

    >>> hyphenate english_US "hyphenation"
    ["hy","phen","ation"]

    >>> hyphenate icelandic "va\240lahei\240avegavinnuverkf\230rageymslusk\250r"
    ["va\240la","hei\240a","vega","vinnu","verk","f\230ra","geymslu","sk\250r"]

category:             Text
abi:                  b57dcb410d5deb2c2ca323e32286faca
exposed:              True
exposed-modules:
    Text.Hyphenation Text.Hyphenation.Exception
    Text.Hyphenation.Hyphenator Text.Hyphenation.Language
    Text.Hyphenation.Pattern

hidden-modules:       Paths_hyphenation
import-dirs:          /usr/lib/ghc-9.4.8/site-local/hyphenation-0.8.3
library-dirs:         /usr/lib/ghc-9.4.8/site-local/hyphenation-0.8.3
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/hyphenation-0.8.3
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-hyphenation
hs-libraries:         HShyphenation-0.8.3-DWiAlk8EYBnAkzPDGBHBqh
depends:
    base-4.17.2.1 bytestring-0.11.5.3 containers-0.6.7
    file-embed-0.0.16.0-FS79AECsQN660bIXAMLGHY text-2.0.2
    unordered-containers-0.2.20-L3M6eILO3KM5ipeNJik2xY
    zlib-0.6.3.0-DQJ3sjglCnhJjpkMXQsJJY

haddock-interfaces:   /usr/share/doc/haskell-hyphenation/html/hyphenation.haddock
haddock-html:         /usr/share/doc/haskell-hyphenation/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

