/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.internal;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.time.Duration;
import java.time.Instant;
import java.util.Optional;
import org.apache.commons.io.FileUtils;
import org.gradle.cache.CacheCleanupStrategy;
import org.gradle.cache.CleanableStore;
import org.gradle.cache.internal.CacheCleanupExecutor;
import org.gradle.internal.time.Time;
import org.gradle.internal.time.Timer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultCacheCleanupExecutor
implements CacheCleanupExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultCacheCleanupExecutor.class);
    private final CleanableStore cleanableStore;
    private final File gcFile;
    private final CacheCleanupStrategy cacheCleanupStrategy;

    public DefaultCacheCleanupExecutor(CleanableStore cleanableStore, File gcFile, CacheCleanupStrategy cacheCleanupStrategy) {
        this.cleanableStore = cleanableStore;
        this.gcFile = gcFile;
        this.cacheCleanupStrategy = cacheCleanupStrategy;
    }

    @Override
    public void cleanup() {
        this.getLastCleanupTime().ifPresent(this::performCleanupIfNecessary);
    }

    private void performCleanupIfNecessary(Instant lastCleanupTime) {
        if (LOGGER.isDebugEnabled()) {
            Duration timeSinceLastCleanup = Duration.between(lastCleanupTime, Instant.now());
            LOGGER.debug("{} has last been fully cleaned up {} hours ago", (Object)this.cleanableStore.getDisplayName(), (Object)timeSinceLastCleanup.toHours());
        }
        if (!this.cacheCleanupStrategy.getCleanupFrequency().requiresCleanup(lastCleanupTime)) {
            LOGGER.debug("Skipping cleanup for {} as it is not yet due", (Object)this.cleanableStore.getDisplayName());
            return;
        }
        try {
            Timer timer = Time.startTimer();
            this.cacheCleanupStrategy.clean(this.cleanableStore, lastCleanupTime);
            FileUtils.touch((File)this.gcFile);
            LOGGER.info("{} cleaned up in {}.", (Object)this.cleanableStore.getDisplayName(), (Object)timer.getElapsed());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private Optional<Instant> getLastCleanupTime() {
        if (this.cacheCleanupStrategy == CacheCleanupStrategy.NO_CLEANUP) {
            return Optional.empty();
        }
        File dir = this.cleanableStore.getBaseDir();
        if (!dir.exists()) {
            return Optional.empty();
        }
        if (!this.gcFile.exists()) {
            try {
                FileUtils.touch((File)this.gcFile);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            return Optional.empty();
        }
        return Optional.of(Instant.ofEpochMilli(this.gcFile.lastModified()));
    }
}

