/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.project.impl;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import org.gephi.project.api.WorkspaceInformation;

public class WorkspaceInformationImpl
implements WorkspaceInformation {
    private final transient List<PropertyChangeListener> listeners = new ArrayList<PropertyChangeListener>();
    private String name;
    private Status status = Status.CLOSED;
    private String source;

    public WorkspaceInformationImpl(String name) {
        this.name = name;
    }

    public String toString() {
        return this.name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        String oldValue = this.name;
        this.name = name;
        this.fireChangeEvent("rename", oldValue, name);
    }

    public Status getStatus() {
        return this.status;
    }

    @Override
    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        String oldValue = this.source;
        this.source = source;
        this.fireChangeEvent("setSource", oldValue, source);
    }

    @Override
    public boolean hasSource() {
        return this.source != null;
    }

    public void open() {
        Status oldValue = this.status;
        this.status = Status.OPEN;
        this.fireChangeEvent("open", (Object)oldValue, (Object)this.status);
    }

    public void close() {
        Status oldValue = this.status;
        this.status = Status.CLOSED;
        this.fireChangeEvent("close", (Object)oldValue, (Object)this.status);
    }

    public void invalid() {
        this.status = Status.INVALID;
    }

    @Override
    public boolean isOpen() {
        return this.status == Status.OPEN;
    }

    @Override
    public boolean isClosed() {
        return this.status == Status.CLOSED;
    }

    @Override
    public boolean isInvalid() {
        return this.status == Status.INVALID;
    }

    @Override
    public void addChangeListener(PropertyChangeListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeChangeListener(PropertyChangeListener listener) {
        this.listeners.remove(listener);
    }

    public void fireChangeEvent(String eventName, Object oldValue, Object newValue) {
        if (oldValue == null && newValue != null || oldValue != null && newValue == null || oldValue != null && !oldValue.equals(newValue)) {
            PropertyChangeEvent event = new PropertyChangeEvent(this, eventName, oldValue, newValue);
            for (PropertyChangeListener listener : this.listeners) {
                listener.propertyChange(event);
            }
        }
    }

    public static enum Status {
        OPEN,
        CLOSED,
        INVALID;

    }
}

