/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.nativewindow;

import com.jogamp.nativewindow.CapabilitiesImmutable;
import com.jogamp.nativewindow.VisualIDHolder;
import java.util.ArrayList;
import java.util.List;

public class CapabilitiesFilter {
    protected CapabilitiesFilter() {
    }

    public static <C extends CapabilitiesImmutable> ArrayList<C> removeMatching(ArrayList<C> arrayList, List<Test<C>> list) {
        ArrayList<CapabilitiesImmutable> arrayList2 = new ArrayList<CapabilitiesImmutable>();
        int n = 0;
        while (n < arrayList.size()) {
            CapabilitiesImmutable capabilitiesImmutable = (CapabilitiesImmutable)arrayList.get(n);
            boolean bl = false;
            for (int i = 0; !bl && i < list.size(); ++i) {
                if (!list.get(i).match(capabilitiesImmutable)) continue;
                arrayList2.add((CapabilitiesImmutable)arrayList.remove(n));
                bl = true;
            }
            if (bl) continue;
            ++n;
        }
        return arrayList2;
    }

    public static <C extends CapabilitiesImmutable> ArrayList<C> removeUnmatchingNativeVisualID(ArrayList<C> arrayList, int n) {
        if (0 == n) {
            return new ArrayList();
        }
        ArrayList<Test<C>> arrayList2 = new ArrayList<Test<C>>();
        arrayList2.add(new TestUnmatchedNativeVisualID(n));
        return CapabilitiesFilter.removeMatching(arrayList, arrayList2);
    }

    public static <C extends CapabilitiesImmutable> ArrayList<C> removeMoreColorComps(ArrayList<C> arrayList, int n) {
        ArrayList<Test<C>> arrayList2 = new ArrayList<Test<C>>();
        arrayList2.add(new TestMoreColorCompBits(n));
        return CapabilitiesFilter.removeMatching(arrayList, arrayList2);
    }

    public static <C extends CapabilitiesImmutable> ArrayList<C> removeMoreColorCompsAndUnmatchingNativeVisualID(ArrayList<C> arrayList, int n, int n2) {
        ArrayList<Test<C>> arrayList2 = new ArrayList<Test<C>>();
        arrayList2.add(new TestMoreColorCompBits(n));
        if (0 != n2) {
            arrayList2.add(new TestUnmatchedNativeVisualID(n2));
        }
        return CapabilitiesFilter.removeMatching(arrayList, arrayList2);
    }

    public static class TestUnmatchedNativeVisualID<C extends CapabilitiesImmutable>
    implements Test<C> {
        final int requiredNativeVisualID;

        public TestUnmatchedNativeVisualID(int n) {
            this.requiredNativeVisualID = n;
        }

        @Override
        public final boolean match(C c) {
            return c.getVisualID(VisualIDHolder.VIDType.NATIVE) != this.requiredNativeVisualID;
        }
    }

    public static class TestMoreColorCompBits<C extends CapabilitiesImmutable>
    implements Test<C> {
        final int maxColorCompBits;

        public TestMoreColorCompBits(int n) {
            this.maxColorCompBits = n;
        }

        @Override
        public final boolean match(C c) {
            return c.getRedBits() > this.maxColorCompBits || c.getGreenBits() > this.maxColorCompBits || c.getBlueBits() > this.maxColorCompBits || c.getAlphaBits() > this.maxColorCompBits;
        }
    }

    public static class TestLessColorCompBits<C extends CapabilitiesImmutable>
    implements Test<C> {
        final int minColorCompBits;

        public TestLessColorCompBits(int n) {
            this.minColorCompBits = n;
        }

        @Override
        public final boolean match(C c) {
            return c.getRedBits() < this.minColorCompBits || c.getGreenBits() < this.minColorCompBits || c.getBlueBits() < this.minColorCompBits || c.getAlphaBits() < this.minColorCompBits;
        }
    }

    public static interface Test<C extends CapabilitiesImmutable> {
        public boolean match(C var1);
    }
}

