/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.datalab.plugin.manipulators.general;

import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import org.gephi.datalab.api.datatables.DataTablesController;
import org.gephi.datalab.plugin.manipulators.general.ui.ManageColumnEstimatorsUI;
import org.gephi.datalab.spi.ManipulatorUI;
import org.gephi.datalab.spi.general.PluginGeneralActionsManipulator;
import org.gephi.graph.api.Column;
import org.gephi.graph.api.Estimator;
import org.gephi.graph.api.GraphController;
import org.gephi.graph.api.GraphModel;
import org.gephi.graph.api.Table;
import org.gephi.graph.api.types.TimeMap;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class ManageColumnEstimators
implements PluginGeneralActionsManipulator {
    private Column[] columns;
    private Estimator[] estimators;

    public void execute() {
        for (int i = 0; i < this.columns.length; ++i) {
            Column column = this.columns[i];
            Estimator estimator = this.estimators[i];
            column.setEstimator(estimator);
        }
    }

    public String getName() {
        return NbBundle.getMessage(ManageColumnEstimators.class, (String)"ManageColumnEstimators.name");
    }

    public String getDescription() {
        return NbBundle.getMessage(ManageColumnEstimators.class, (String)"ManageColumnEstimators.description");
    }

    public List<Column> getColumns() {
        GraphModel graphModel = ((GraphController)Lookup.getDefault().lookup(GraphController.class)).getGraphModel();
        Table table = ((DataTablesController)Lookup.getDefault().lookup(DataTablesController.class)).isNodeTableMode() ? graphModel.getNodeTable() : graphModel.getEdgeTable();
        ArrayList<Column> availableColumns = new ArrayList<Column>();
        for (Column column : table) {
            if (!TimeMap.class.isAssignableFrom(column.getTypeClass())) continue;
            availableColumns.add(column);
        }
        return availableColumns;
    }

    public boolean canExecute() {
        return !this.getColumns().isEmpty();
    }

    public ManipulatorUI getUI() {
        this.columns = null;
        this.estimators = null;
        return new ManageColumnEstimatorsUI();
    }

    public int getType() {
        return 200;
    }

    public int getPosition() {
        return 0;
    }

    public Icon getIcon() {
        return ImageUtilities.loadImageIcon((String)"DataLaboratoryPlugin/gear.png", (boolean)false);
    }

    public void setup(Column[] columns, Estimator[] estimators) {
        this.columns = columns;
        this.estimators = estimators;
    }
}

