/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.ui.mindmapmode;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetContext;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.util.LogUtils;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.icon.IconController;
import org.freeplane.features.icon.Tag;
import org.freeplane.features.icon.TagCategories;
import org.freeplane.features.icon.mindmapmode.TagSelection;
import org.freeplane.features.link.LinkController;
import org.freeplane.features.link.mindmapmode.MLinkController;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.map.clipboard.MapClipboardController;
import org.freeplane.features.map.clipboard.MindMapNodesSelection;
import org.freeplane.features.map.mindmapmode.InsertionRelation;
import org.freeplane.features.map.mindmapmode.MMapController;
import org.freeplane.features.map.mindmapmode.clipboard.MMapClipboardController;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;
import org.freeplane.view.swing.map.MainView;
import org.freeplane.view.swing.map.MapView;
import org.freeplane.view.swing.map.MapViewIconListComponent;
import org.freeplane.view.swing.map.NodeView;
import org.freeplane.view.swing.map.NodeViewFolder;
import org.freeplane.view.swing.ui.MouseEventActor;

public class MNodeDropListener
implements DropTargetListener {
    private static final String PROPERTY_UNFOLD_ON_PASTE = "unfold_on_paste";
    private static final EnumMap<MainView.DragOverRelation, NodeModel.Side> sides = new EnumMap(MainView.DragOverRelation.class);
    private static final EnumMap<MainView.DragOverRelation, InsertionRelation> insertionRelations;
    private final NodeViewFolder nodeFolder;

    MNodeDropListener(NodeViewFolder nodeFolder) {
        this.nodeFolder = nodeFolder;
    }

    public void addDropListener(MainView component) {
        this.addDropListener((Component)component);
    }

    public void addDropListener(MapViewIconListComponent component) {
        this.addDropListener((Component)component);
    }

    private void addDropListener(Component component) {
        DropTarget dropTarget = new DropTarget(component, this);
        dropTarget.setActive(true);
    }

    @Override
    public void dragEnter(DropTargetDragEvent dtde) {
        if (this.isDragAcceptable(dtde)) {
            dtde.acceptDrag(2);
        } else {
            dtde.rejectDrag();
        }
    }

    @Override
    public void dragExit(DropTargetEvent e) {
        MainView mainView = this.getMainView(e);
        mainView.stopDragOver();
        mainView.repaint();
        if (this.isInFoldingRegion(mainView)) {
            NodeView nodeView = mainView.getNodeView();
            this.nodeFolder.adjustFolding(Collections.singleton(nodeView));
        }
    }

    private boolean isInFoldingRegion(MainView node) {
        MainView.DragOverDirection dragOverDirection;
        AWTEvent currentEvent = EventQueue.getCurrentEvent();
        if (!(currentEvent instanceof MouseEvent)) {
            return false;
        }
        MouseEvent mouseEvent = (MouseEvent)currentEvent;
        if (mouseEvent.getComponent() != node) {
            return false;
        }
        Point p = mouseEvent.getPoint();
        if (p.x < 0 && p.y >= 0 && p.y < node.getHeight()) {
            dragOverDirection = MainView.DragOverDirection.DROP_LEFT;
        } else if (p.x >= node.getWidth() && p.y >= 0 && p.y < node.getHeight()) {
            dragOverDirection = MainView.DragOverDirection.DROP_RIGHT;
        } else if (p.y < 0 && p.x >= 0 && p.x < node.getWidth()) {
            dragOverDirection = MainView.DragOverDirection.DROP_UP;
        } else if (p.y >= node.getHeight() && p.x >= 0 && p.x < node.getWidth()) {
            dragOverDirection = MainView.DragOverDirection.DROP_DOWN;
        } else {
            return false;
        }
        NodeView nodeView = node.getNodeView();
        MainView.DragOverRelation relation = dragOverDirection.relation(nodeView.layoutOrientation(), nodeView.side());
        return relation.isChild() && nodeView.childrenSides().matches(relation == MainView.DragOverRelation.CHILD_BEFORE);
    }

    private MainView getMainView(DropTargetEvent e) {
        DropTargetContext dropTargetContext = e.getDropTargetContext();
        return this.getMainView(dropTargetContext);
    }

    private MainView getMainView(DropTargetContext dropTargetContext) {
        Component component = dropTargetContext.getComponent();
        if (component instanceof MainView) {
            return (MainView)component;
        }
        NodeView nodeView = (NodeView)SwingUtilities.getAncestorOfClass(NodeView.class, component);
        return nodeView.getMainView();
    }

    @Override
    public void dragOver(DropTargetDragEvent dtde) {
        if (this.isDragAcceptable(dtde)) {
            MainView dropTarget = this.getMainView(dtde.getDropTargetContext());
            dropTarget.setDragOverDirection(dtde);
        }
    }

    private boolean isDragAcceptable(DropTargetDragEvent event) {
        boolean containsTags = event.isDataFlavorSupported(TagSelection.tagFlavor);
        if (containsTags) {
            try {
                NodeView nodeView = this.getMainView(event.getDropTargetContext()).getNodeView();
                List nodeTags = ((IconController)nodeView.getMap().getModeController().getExtension(IconController.class)).getTags(nodeView.getNode());
                String tagData = (String)event.getTransferable().getTransferData(TagSelection.tagFlavor);
                Tag tag = TagCategories.readTag((String)tagData);
                if (nodeTags.contains(tag)) {
                    return false;
                }
            }
            catch (UnsupportedFlavorException | IOException e) {
                return false;
            }
        }
        if (event.getDropTargetContext().getComponent() instanceof MainView) {
            return event.isDataFlavorSupported(DataFlavor.stringFlavor) || event.isDataFlavorSupported(MindMapNodesSelection.fileListFlavor) || event.isDataFlavorSupported(DataFlavor.imageFlavor);
        }
        return containsTags;
    }

    private boolean isDropAcceptable(DropTargetDropEvent event, int dropAction) {
        List<NodeModel> droppedNodes;
        boolean containsTags = event.isDataFlavorSupported(TagSelection.tagFlavor);
        if (event.getDropTargetContext().getComponent() instanceof MapViewIconListComponent && !containsTags) {
            return false;
        }
        if (!event.isLocalTransfer()) {
            return true;
        }
        if (containsTags) {
            try {
                NodeView nodeView = this.getMainView(event.getDropTargetContext()).getNodeView();
                List nodeTags = ((IconController)nodeView.getMap().getModeController().getExtension(IconController.class)).getTags(nodeView.getNode());
                String tagData = (String)event.getTransferable().getTransferData(TagSelection.tagFlavor);
                Tag tag = TagCategories.readTag((String)tagData);
                if (nodeTags.contains(tag)) {
                    return false;
                }
            }
            catch (UnsupportedFlavorException | IOException e) {
                return false;
            }
        }
        if (!event.isDataFlavorSupported(MindMapNodesSelection.mindMapNodeObjectsFlavor)) {
            return dropAction != 0x40000000;
        }
        try {
            Transferable t = event.getTransferable();
            droppedNodes = this.getNodeObjects(t);
        }
        catch (Exception e) {
            return dropAction != 0x40000000;
        }
        NodeModel node = this.getMainView(event.getDropTargetContext()).getNodeView().getNode();
        if (dropAction == 0x40000000) {
            return this.areFromSameMap(node, droppedNodes);
        }
        if (dropAction == 2) {
            return !this.isFromDescencantNode(node, droppedNodes);
        }
        return !this.droppedNodesContainTargetNode(node, droppedNodes);
    }

    private boolean droppedNodesContainTargetNode(NodeModel targetNode, List<NodeModel> droppedNodes) {
        for (NodeModel selected : droppedNodes) {
            if (targetNode != selected) continue;
            return true;
        }
        return false;
    }

    private boolean areFromSameMap(NodeModel targetNode, Collection<NodeModel> droppedNodes) {
        for (NodeModel selected : droppedNodes) {
            if (selected.getMap() == targetNode.getMap()) continue;
            return false;
        }
        return true;
    }

    private boolean isFromDescencantNode(NodeModel targetNode, List<NodeModel> droppedNodes) {
        for (NodeModel selected : droppedNodes) {
            if (targetNode != selected && !targetNode.isDescendantOf(selected)) continue;
            return true;
        }
        return false;
    }

    private List<NodeModel> getNodeObjects(Transferable t) throws UnsupportedFlavorException, IOException {
        return (List)t.getTransferData(MindMapNodesSelection.mindMapNodeObjectsFlavor);
    }

    @Override
    public void drop(DropTargetDropEvent dtde) {
        try {
            boolean isTopOrLeft;
            MainView mainView = this.getMainView(dtde.getDropTargetContext());
            NodeView targetNodeView = mainView.getNodeView();
            MapView mapView = targetNodeView.getMap();
            mapView.select();
            NodeModel targetNode = targetNodeView.getNode();
            Controller controller = Controller.getCurrentController();
            int dropAction = this.getDropAction(dtde);
            Transferable t = dtde.getTransferable();
            mainView.stopDragOver();
            mainView.repaint();
            if (!this.isDropAcceptable(dtde, dropAction)) {
                dtde.rejectDrop();
                return;
            }
            MainView.DragOverRelation dragOverRelation = mainView.dragOverRelation(dtde);
            if (dragOverRelation == MainView.DragOverRelation.NOT_AVAILABLE) {
                dtde.rejectDrop();
                return;
            }
            boolean dropAsSibling = dragOverRelation.isSibling();
            ModeController modeController = controller.getModeController();
            MMapController mapController = (MMapController)modeController.getMapController();
            if (dropAction == 2 || dropAction == 1) {
                NodeModel parent;
                NodeModel nodeModel = parent = dropAsSibling ? targetNode.getParentNode() : targetNode;
                if (!mapController.isWriteable(parent)) {
                    dtde.rejectDrop();
                    String message = TextUtils.getText((String)"node_is_write_protected");
                    UITools.errorMessage((Object)message);
                    return;
                }
            }
            boolean bl = isTopOrLeft = dragOverRelation == MainView.DragOverRelation.CHILD_BEFORE;
            if (!dtde.isLocalTransfer()) {
                this.adjustFoldingOnDrop(targetNodeView, dragOverRelation);
                dtde.acceptDrop(1);
                NodeModel.Side side = dropAsSibling ? sides.get(dragOverRelation) : (isTopOrLeft ? NodeModel.Side.TOP_OR_LEFT : NodeModel.Side.BOTTOM_OR_RIGHT);
                ((MMapClipboardController)MapClipboardController.getController()).paste(t, targetNode, dropAsSibling ? sides.get(dragOverRelation) : side, dropAction);
                dtde.dropComplete(true);
                return;
            }
            dtde.acceptDrop(dropAction);
            if (dropAction == 0x40000000) {
                int yesorno = 0;
                if (controller.getSelection().size() >= 5) {
                    yesorno = JOptionPane.showConfirmDialog(controller.getViewController().getCurrentRootComponent(), TextUtils.getText((String)"lots_of_links_warning"), Integer.toString(controller.getSelection().size()) + " links to the same node", 0);
                }
                if (yesorno == 0) {
                    for (NodeModel sourceNodeModel : this.getNodeObjects(t)) {
                        ((MLinkController)LinkController.getController((ModeController)modeController)).addConnector(sourceNodeModel, targetNode);
                    }
                }
            } else if (2 == dropAction && t.isDataFlavorSupported(MindMapNodesSelection.mindMapNodeObjectsFlavor) && this.areFromSameMap(targetNode, this.getNodeObjects(t))) {
                List selecteds = mapController.getSelectedNodes();
                NodeModel[] array = selecteds.toArray(new NodeModel[selecteds.size()]);
                this.moveNodes(mapController, targetNode, t, insertionRelations.getOrDefault(dragOverRelation, InsertionRelation.AS_CHILD), isTopOrLeft);
                if (dropAsSibling || !targetNodeView.isFolded()) {
                    MouseEventActor.INSTANCE.withMouseEvent(() -> controller.getSelection().replaceSelection(array));
                } else {
                    MouseEventActor.INSTANCE.withMouseEvent(() -> mapView.selectAsTheOnlyOneSelected(targetNodeView));
                }
            } else if (1 == dropAction || 2 == dropAction) {
                NodeModel.Side side = dropAsSibling ? sides.get(dragOverRelation) : (isTopOrLeft ? NodeModel.Side.TOP_OR_LEFT : NodeModel.Side.BOTTOM_OR_RIGHT);
                ((MMapClipboardController)MapClipboardController.getController()).paste(t, targetNode, dropAsSibling ? sides.get(dragOverRelation) : side);
                MouseEventActor.INSTANCE.withMouseEvent(() -> controller.getSelection().selectAsTheOnlyOneSelected(targetNode));
            }
            this.adjustFoldingOnDrop(targetNodeView, dragOverRelation);
        }
        catch (Exception e) {
            LogUtils.severe((String)"Drop exception:", (Throwable)e);
            dtde.dropComplete(false);
            return;
        }
        dtde.dropComplete(true);
    }

    private void adjustFoldingOnDrop(NodeView targetNodeView, MainView.DragOverRelation dragOverRelation) {
        Set<Object> nodesKeptUnfold;
        boolean unfoldsTarget = ResourceController.getResourceController().getBooleanProperty(PROPERTY_UNFOLD_ON_PASTE);
        if (unfoldsTarget) {
            if (dragOverRelation.isChild()) {
                nodesKeptUnfold = Collections.singleton(targetNodeView);
            } else {
                NodeView parentNodeView = targetNodeView.getAncestorWithVisibleContent();
                nodesKeptUnfold = Collections.singleton(parentNodeView);
            }
        } else {
            nodesKeptUnfold = Collections.emptySet();
        }
        this.nodeFolder.adjustFolding(nodesKeptUnfold);
        this.nodeFolder.reset();
    }

    private int getDropAction(DropTargetDropEvent dtde) {
        int dropAction = dtde.getDropAction();
        Transferable t = dtde.getTransferable();
        if (t.isDataFlavorSupported(MindMapNodesSelection.dropCopyActionFlavor)) {
            dropAction = 1;
        } else if (t.isDataFlavorSupported(MindMapNodesSelection.dropLinkActionFlavor)) {
            dropAction = 0x40000000;
        }
        return dropAction;
    }

    private void moveNodes(MMapController mapController, NodeModel targetNode, Transferable t, InsertionRelation insertionRelation, boolean isTopOrLeft) throws UnsupportedFlavorException, IOException {
        List<NodeModel> movedNodes = this.getNodeObjects(t);
        MouseEventActor.INSTANCE.withMouseEvent(() -> {
            if (insertionRelation != InsertionRelation.AS_CHILD) {
                mapController.moveNodes(movedNodes, targetNode, insertionRelation);
                mapController.setSide(movedNodes, targetNode.getSide());
            } else {
                List nodesChangingParent = movedNodes.stream().filter(node -> targetNode != node.getParentNode()).collect(Collectors.toList());
                mapController.moveNodes(movedNodes, targetNode, insertionRelation);
                NodeModel.Side side = isTopOrLeft ? NodeModel.Side.TOP_OR_LEFT : NodeModel.Side.BOTTOM_OR_RIGHT;
                mapController.setSide(side == NodeModel.Side.DEFAULT ? nodesChangingParent : movedNodes, side);
            }
        });
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent e) {
    }

    static {
        sides.put(MainView.DragOverRelation.SIBLING_AFTER, NodeModel.Side.AS_SIBLING_AFTER);
        sides.put(MainView.DragOverRelation.SIBLING_BEFORE, NodeModel.Side.AS_SIBLING_BEFORE);
        insertionRelations = new EnumMap(MainView.DragOverRelation.class);
        insertionRelations.put(MainView.DragOverRelation.SIBLING_AFTER, InsertionRelation.AS_SIBLING_AFTER);
        insertionRelations.put(MainView.DragOverRelation.SIBLING_BEFORE, InsertionRelation.AS_SIBLING_BEFORE);
    }
}

