/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.script.proxy;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.freeplane.api.Dependencies;
import org.freeplane.api.DependencyLookup;
import org.freeplane.api.NodeRO;
import org.freeplane.features.attribute.Attribute;
import org.freeplane.features.attribute.NodeAttributeTableModel;
import org.freeplane.features.map.NodeModel;
import org.freeplane.plugin.script.ScriptContext;
import org.freeplane.plugin.script.dependencies.DependenciesBuilder;
import org.freeplane.plugin.script.dependencies.DependencySearchStrategy;
import org.freeplane.plugin.script.dependencies.RelatedElements;
import org.freeplane.plugin.script.proxy.AbstractProxy;
import org.freeplane.plugin.script.proxy.NodeProxy;

public class DependencyLookupProxy
extends AbstractProxy<NodeModel>
implements DependencyLookup {
    private final DependencySearchStrategy searchStrategy;

    public DependencyLookupProxy(NodeModel delegate, ScriptContext scriptContext, DependencySearchStrategy searchStrategy) {
        super(delegate, scriptContext);
        this.searchStrategy = searchStrategy;
    }

    public Map<? extends NodeRO, Dependencies> ofNode() {
        RelatedElements elements = this.searchStrategy.find((NodeModel)this.getDelegate());
        return this.toMap(elements);
    }

    public Map<? extends NodeRO, Dependencies> ofAttribute(int attributeIndex) {
        NodeAttributeTableModel attributes = (NodeAttributeTableModel)((NodeModel)this.getDelegate()).getExtension(NodeAttributeTableModel.class);
        if (attributes != null && attributeIndex >= 0 && attributeIndex < attributes.getRowCount()) {
            Attribute attribute = attributes.getAttribute(attributeIndex);
            RelatedElements elements = this.searchStrategy.find((NodeModel)this.getDelegate(), attribute);
            return this.toMap(elements);
        }
        return Collections.emptyMap();
    }

    public Map<? extends NodeRO, Dependencies> ofAttribute(String attributeName) {
        NodeAttributeTableModel attributes = (NodeAttributeTableModel)((NodeModel)this.getDelegate()).getExtension(NodeAttributeTableModel.class);
        if (attributes != null) {
            return this.ofAttribute(attributes.getAttributeIndex(attributeName));
        }
        return Collections.emptyMap();
    }

    private Map<? extends NodeRO, Dependencies> toMap(RelatedElements elements) {
        if (elements.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<NodeModel, DependenciesBuilder> builders = new HashMap<NodeModel, DependenciesBuilder>();
        for (Map.Entry<Object, NodeModel> pair : elements.entrySet()) {
            Object object = pair.getKey();
            NodeModel node = pair.getValue();
            DependenciesBuilder builder = builders.computeIfAbsent(node, n -> new DependenciesBuilder((NodeAttributeTableModel)n.getExtension(NodeAttributeTableModel.class)));
            if (object == node) {
                builder.setNodeContained();
                continue;
            }
            if (!(object instanceof Attribute)) continue;
            builder.addAttribute((Attribute)object);
        }
        HashMap dependencies = new HashMap();
        builders.forEach((n, b) -> dependencies.put(new NodeProxy((NodeModel)n, this.getScriptContext()), b.build()));
        return dependencies;
    }
}

