/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.map;

import java.awt.Component;
import java.awt.Dimension;
import java.util.Arrays;
import java.util.function.ToIntFunction;
import java.util.stream.IntStream;
import org.freeplane.api.ChildNodesAlignment;
import org.freeplane.api.ChildrenSides;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.util.LogUtils;
import org.freeplane.features.filter.Filter;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.map.SummaryLevels;
import org.freeplane.features.nodelocation.LocationModel;
import org.freeplane.view.swing.map.CloudHeightCalculator;
import org.freeplane.view.swing.map.CombineOperation;
import org.freeplane.view.swing.map.ContentSizeCalculator;
import org.freeplane.view.swing.map.MapView;
import org.freeplane.view.swing.map.NodeView;
import org.freeplane.view.swing.map.NodeViewLayoutHelper;
import org.freeplane.view.swing.map.StepFunction;

class VerticalNodeViewLayoutStrategy {
    private static boolean wrongChildComponentsReported = false;
    private int childViewCount;
    private final int spaceAround;
    private final NodeViewLayoutHelper view;
    private final int[] xCoordinates;
    private final int[] yCoordinates;
    private final int[] yBottomCoordinates;
    private final boolean[] isChildFreeNode;
    private StepFunction bottomBoundary;
    private int yBottom;
    private int bottomContentY;
    private StepFunction leftBottomBoundary;
    private StepFunction rightBottomBoundary;
    private SummaryLevels viewLevels;
    private int totalShiftY;
    private int totalSideShiftY;
    private boolean rightSideCoordinatesAreSet;
    private boolean leftSideCoordinaresAreSet;
    private final boolean allowsCompactLayout;
    private final boolean isAutoCompactLayoutEnabled;
    private final int defaultVGap;
    private static final int SUMMARY_DEFAULT_HGAP_PX = LocationModel.DEFAULT_HGAP_PX * 7 / 12;
    private final Dimension contentSize;
    private int minimalGapBetweenChildren;
    private ChildNodesAlignment childNodesAlignment;
    private int level;
    private int y;
    private int vGap;
    private int visibleLaidOutChildCounter;
    private int[] groupStartIndex;
    private StepFunction[] groupStartBoundaries;
    private int[] groupUpperYCoordinate;
    private int[] groupLowerYCoordinate;
    private boolean currentSideLeft;
    private final int baseRelativeDistanceToChildren;
    private boolean areChildrenSeparatedByY;
    private int[] summaryBaseX;
    private final int extraGapForChildren;
    private final int foldingMarkReservedSpace;
    private int lastMinimumDistanceConsideringHandles;
    private int childCloudHeight;

    public VerticalNodeViewLayoutStrategy(NodeView view) {
        NodeViewLayoutHelper layoutHelper;
        this.view = layoutHelper = view.getLayoutHelper();
        this.contentSize = ContentSizeCalculator.INSTANCE.calculateContentSize(layoutHelper);
        this.childViewCount = view.getComponentCount() - 1;
        this.layoutChildViews(view);
        this.totalShiftY = 0;
        this.rightSideCoordinatesAreSet = false;
        this.leftSideCoordinaresAreSet = false;
        this.xCoordinates = new int[this.childViewCount];
        this.yCoordinates = new int[this.childViewCount];
        this.yBottomCoordinates = new int[this.childViewCount];
        this.isChildFreeNode = new boolean[this.childViewCount];
        this.spaceAround = view.getSpaceAround();
        this.allowsCompactLayout = view.allowsCompactLayout();
        this.childNodesAlignment = view.getChildNodesAlignment();
        this.isAutoCompactLayoutEnabled = view.isAutoCompactLayoutEnabled() && !this.childNodesAlignment.isStacked();
        this.defaultVGap = view.getMap().getZoomed(LocationModel.DEFAULT_VGAP.toBaseUnits());
        this.minimalGapBetweenChildren = view.getMinimalDistanceBetweenChildren();
        this.extraGapForChildren = this.calculateExtraGapForChildren(this.minimalGapBetweenChildren);
        this.baseRelativeDistanceToChildren = view.getBaseDistanceToChildren(-LocationModel.DEFAULT_HGAP_PX);
        this.foldingMarkReservedSpace = Math.max(1, view.getBaseDistanceToChildren(0) - 3);
    }

    private void layoutChildViews(NodeView view) {
        for (int i = 0; i < this.childViewCount; ++i) {
            Component component = view.getComponent(i);
            if (component instanceof NodeView) {
                ((NodeView)component).validateTree();
                continue;
            }
            this.childViewCount = i;
            if (wrongChildComponentsReported) continue;
            wrongChildComponentsReported = true;
            String wrongChildComponents = Arrays.toString(view.getComponents());
            LogUtils.severe("Unexpected child components:" + wrongChildComponents, new Exception());
        }
    }

    private void setFreeChildNodes(boolean laysOutLeftSide) {
        for (int i = 0; i < this.childViewCount; ++i) {
            NodeViewLayoutHelper child = this.view.getComponent(i);
            if (child.isLeft() != laysOutLeftSide) continue;
            this.isChildFreeNode[i] = child.isFree();
        }
    }

    public void calculateLayoutData() {
        NodeModel node = this.view.getNode();
        MapView map = this.view.getMap();
        Filter filter = map.getFilter();
        NodeModel selectionRoot = map.getRoot().getNode();
        this.viewLevels = this.childViewCount == 0 ? SummaryLevels.ignoringChildNodes(selectionRoot, node, filter) : SummaryLevels.of(selectionRoot, node, filter);
        for (boolean isLeft : this.viewLevels.sides) {
            this.calculateLayoutData(isLeft);
        }
        this.applyLayoutToChildComponents();
    }

    private void calculateLayoutData(boolean isLeft) {
        this.setFreeChildNodes(isLeft);
        this.calculateLayoutX(isLeft);
        this.calculateLayoutY(isLeft);
    }

    private void calculateLayoutX(boolean laysOutLeftSide) {
        this.currentSideLeft = laysOutLeftSide;
        this.areChildrenSeparatedByY = this.childNodesAlignment.isStacked();
        this.level = this.viewLevels.highestSummaryLevel + 1;
        this.summaryBaseX = new int[this.level];
        for (int i = 0; i < this.childViewCount; ++i) {
            NodeViewLayoutHelper child = this.view.getComponent(i);
            if (child.isLeft() != this.currentSideLeft) continue;
            int oldLevel = this.level;
            this.level = this.viewLevels.summaryLevels[i];
            boolean isFreeNode = child.isFree();
            boolean isItem = this.level == 0;
            int childHGap = this.calculateChildHorizontalGap(child, isItem, isFreeNode, this.baseRelativeDistanceToChildren);
            if (isItem) {
                this.assignRegularChildHorizontalPosition(i, child, oldLevel, childHGap);
                continue;
            }
            this.assignSummaryChildHorizontalPosition(i, child, childHGap);
        }
    }

    private int calculateChildHorizontalGap(NodeViewLayoutHelper child, boolean isItem, boolean isFreeNode, int baseDistanceToChildren) {
        int hGap = child.isContentVisible() ? this.calculateDistance(child, NodeViewLayoutHelper::getHGap) : (child.isSummary() ? child.getZoomed(SUMMARY_DEFAULT_HGAP_PX) : 0);
        if (this.view.getNode().isHiddenSummary() && !child.getNode().isHiddenSummary()) {
            hGap -= child.getZoomed(SUMMARY_DEFAULT_HGAP_PX);
        }
        if (isItem && !isFreeNode && child.isSubtreeVisible()) {
            hGap += baseDistanceToChildren;
        }
        return hGap;
    }

    private void assignRegularChildHorizontalPosition(int index, NodeViewLayoutHelper child, int oldLevel, int childHGap) {
        if (!child.isFree() && (oldLevel > 0 || child.isFirstGroupNode())) {
            this.summaryBaseX[0] = 0;
        }
        this.placeChildXCoordinate(index, child, childHGap);
    }

    private void assignSummaryChildHorizontalPosition(int index, NodeViewLayoutHelper child, int childHGap) {
        if (child.isFirstGroupNode()) {
            this.summaryBaseX[this.level] = 0;
        }
        this.placeChildXCoordinate(index, child, childHGap);
    }

    private void placeChildXCoordinate(int index, NodeViewLayoutHelper child, int childHGap) {
        int x;
        int baseX = this.level > 0 ? this.summaryBaseX[this.level - 1] : (this.level == 0 && this.areChildrenSeparatedByY && this.view.childrenSides() == ChildrenSides.BOTH_SIDES ? this.contentSize.width / 2 : (child.isLeft() != (this.level == 0 && (child.isFree() || this.areChildrenSeparatedByY)) ? 0 : this.contentSize.width));
        if (child.isLeft()) {
            x = baseX - childHGap - child.getContentX() - child.getContentWidth();
            this.summaryBaseX[this.level] = Math.min(this.summaryBaseX[this.level], x + this.spaceAround);
        } else {
            x = baseX + childHGap - child.getContentX();
            this.summaryBaseX[this.level] = Math.max(this.summaryBaseX[this.level], x + child.getWidth() - this.spaceAround);
        }
        this.xCoordinates[index] = x;
    }

    private void calculateLayoutY(boolean laysOutLeftSide) {
        this.currentSideLeft = laysOutLeftSide;
        this.totalSideShiftY = 0;
        this.level = this.viewLevels.highestSummaryLevel + 1;
        this.y = 0;
        this.yBottom = 0;
        this.bottomContentY = 0;
        this.bottomBoundary = null;
        this.vGap = 0;
        this.lastMinimumDistanceConsideringHandles = 0;
        this.childCloudHeight = 0;
        this.visibleLaidOutChildCounter = 0;
        this.groupStartIndex = new int[this.level];
        this.groupStartBoundaries = new StepFunction[this.level];
        this.groupUpperYCoordinate = new int[this.level];
        this.groupLowerYCoordinate = new int[this.level];
        NodeViewLayoutHelper lastRegularChild = null;
        for (int index = 0; index < this.childViewCount; ++index) {
            NodeViewLayoutHelper child = this.view.getComponent(index);
            if (child.isLeft() != this.currentSideLeft) continue;
            int oldLevel = this.level;
            int childRegularHeight = child.getHeight() - child.getTopOverlap() - child.getBottomOverlap() - 2 * this.spaceAround;
            this.level = this.viewLevels.summaryLevels[index];
            if (index >= this.viewLevels.summaryLevels.length) {
                String errorMessage = "Bad node view child components: missing node for component " + index;
                UITools.errorMessage(errorMessage);
                System.err.println(errorMessage);
                for (int i = 0; i < this.view.getComponentCount(); ++i) {
                    String component = this.view.describeComponent(i);
                    System.err.println(component);
                }
            }
            boolean isFreeNode = child.isFree();
            boolean isItem = this.level == 0;
            int childShiftY = this.calculateDistance(child, NodeViewLayoutHelper::getShift);
            if (this.level == 0) {
                if (isFreeNode) {
                    this.assignFreeChildVerticalPosition(index, childShiftY, child);
                } else {
                    this.handleFirstVisibleChildAlignment();
                    if (childRegularHeight != 0) {
                        this.assignRegularChildVerticalPosition(index, child, childRegularHeight, childShiftY);
                        ++this.visibleLaidOutChildCounter;
                        lastRegularChild = child;
                    } else {
                        this.yCoordinates[index] = this.calculateInitialYPosition(childShiftY);
                    }
                    this.initializeSummaryGroupStart(index, oldLevel, child.isFirstGroupNode());
                }
            } else {
                this.assignSummaryChildVerticalPosition(index, child, childRegularHeight, childShiftY);
            }
            if (isItem && isFreeNode) continue;
            this.updateSummaryGroupBounds(index, child, this.level, isItem, childRegularHeight);
        }
        if (this.childNodesAlignment.placement() != ChildNodesAlignment.Placement.TOP) {
            this.totalSideShiftY += this.contentSize.height;
            if (lastRegularChild != null && this.childNodesAlignment != ChildNodesAlignment.FLOW && this.childNodesAlignment != ChildNodesAlignment.AUTO) {
                this.totalSideShiftY += lastRegularChild.getHeight() - this.spaceAround - lastRegularChild.getBottomOverlap() - lastRegularChild.getContentY() - lastRegularChild.getContentHeight();
            }
        }
        if (this.childNodesAlignment.placement() == ChildNodesAlignment.Placement.CENTER) {
            this.totalSideShiftY /= 2;
        } else if (this.childNodesAlignment == ChildNodesAlignment.BEFORE_PARENT && this.contentSize.height > 0 && !this.isFirstVisibleLaidOutChild()) {
            this.totalSideShiftY -= this.calculateAddedDistanceFromParentToChildren(this.minimalGapBetweenChildren, this.contentSize);
        }
        this.calculateRelativeCoordinatesForContentAndBothSides(laysOutLeftSide);
    }

    private void initializeSummaryGroupStart(int childIndex, int oldLevel, boolean isFirstGroupNode) {
        if (oldLevel > 0) {
            for (int j = 0; j < oldLevel; ++j) {
                this.groupStartBoundaries[j] = this.bottomBoundary;
                this.groupStartIndex[j] = childIndex;
                this.groupUpperYCoordinate[j] = Integer.MAX_VALUE;
                this.groupLowerYCoordinate[j] = Integer.MIN_VALUE;
            }
        } else if (isFirstGroupNode) {
            this.groupStartIndex[0] = childIndex;
            this.groupStartBoundaries[0] = this.bottomBoundary;
        }
    }

    private void calculateRelativeCoordinatesForContentAndBothSides(boolean isLeft) {
        if (!this.leftSideCoordinaresAreSet && !this.rightSideCoordinatesAreSet) {
            this.totalShiftY = this.totalSideShiftY;
        } else {
            int delta = this.totalSideShiftY - this.totalShiftY;
            if (delta != 0) {
                boolean changeLeft;
                if (delta < 0) {
                    this.totalShiftY = this.totalSideShiftY;
                    changeLeft = !isLeft;
                    delta = -delta;
                } else {
                    changeLeft = isLeft;
                }
                for (int i = 0; i < this.childViewCount; ++i) {
                    NodeViewLayoutHelper child = this.view.getComponent(i);
                    if (child.isLeft() != changeLeft || this.viewLevels.summaryLevels[i] <= 0 && this.isChildFreeNode[i]) continue;
                    int n = i;
                    this.yCoordinates[n] = this.yCoordinates[n] + delta;
                }
                if (this.bottomBoundary != null) {
                    this.bottomBoundary = this.bottomBoundary.translate(0, delta);
                }
            }
        }
        if (isLeft) {
            this.leftSideCoordinaresAreSet = true;
            this.leftBottomBoundary = this.bottomBoundary;
        } else {
            this.rightSideCoordinatesAreSet = true;
            this.rightBottomBoundary = this.bottomBoundary;
        }
    }

    private int calculateAddedDistanceFromParentToChildren(int minimalDistance, Dimension contentSize) {
        boolean usesHorizontalLayout = this.view.usesHorizontalLayout();
        int distance = Math.max(this.view.getMap().getZoomed(usesHorizontalLayout ? LocationModel.DEFAULT_VGAP_PX * 2 : LocationModel.DEFAULT_VGAP_PX), minimalDistance);
        return contentSize.height + distance;
    }

    private int calculateExtraGapForChildren(int minimalDistanceBetweenChildren) {
        if (3 * this.defaultVGap > minimalDistanceBetweenChildren) {
            return minimalDistanceBetweenChildren + 2 * this.defaultVGap;
        }
        return (minimalDistanceBetweenChildren + 22 * this.defaultVGap) / 6;
    }

    private int calculateDistance(NodeViewLayoutHelper child, ToIntFunction<NodeViewLayoutHelper> nodeDistance) {
        if (!child.isContentVisible()) {
            return 0;
        }
        int shift = nodeDistance.applyAsInt(child);
        for (NodeViewLayoutHelper ancestor = child.getParentView(); ancestor != null && !ancestor.isContentVisible(); ancestor = ancestor.getParentView()) {
            if (!ancestor.isFree()) continue;
            shift += nodeDistance.applyAsInt(ancestor);
        }
        return shift;
    }

    private boolean isNextNodeSummaryNode(int childViewIndex) {
        return childViewIndex + 1 < this.viewLevels.summaryLevels.length && this.viewLevels.summaryLevels[childViewIndex + 1] > 0;
    }

    private int calculateExtraVerticalGap(int extraHeight) {
        if (extraHeight <= 0) {
            return 0;
        }
        return Math.min(extraHeight, this.extraGapForChildren);
    }

    private void assignFreeChildVerticalPosition(int childIndex, int shiftY, NodeViewLayoutHelper child) {
        this.yCoordinates[childIndex] = shiftY - child.getContentY();
    }

    private void assignRegularChildVerticalPosition(int index, NodeViewLayoutHelper child, int childRegularHeight, int childShiftY) {
        int yBegin;
        int childCloudHeight;
        int y0 = this.y;
        int contentTop = this.getContentTop(child);
        int topContentY = contentTop + y0;
        int spaceBetweenContent = topContentY - this.bottomContentY;
        int lastChildCloudHeight = this.childCloudHeight;
        this.childCloudHeight = childCloudHeight = CloudHeightCalculator.INSTANCE.getAdditionalCloudHeight(child);
        int availableSpace = 0;
        int upperGap = 0;
        if (!this.isFirstVisibleLaidOutChild()) {
            int spaceForClouds = (childCloudHeight + lastChildCloudHeight) / 2 + (lastChildCloudHeight & 1);
            int spaceBetweenContentAndClouds = spaceBetweenContent - spaceForClouds;
            if (this.isAutoCompactLayoutEnabled) {
                availableSpace = this.calculateAvailableSpaceForCompactLayout(child, index, y0, spaceForClouds);
                if (spaceBetweenContentAndClouds > availableSpace) {
                    upperGap = Math.min(spaceBetweenContentAndClouds - availableSpace, this.extraGapForChildren);
                }
                this.y -= availableSpace;
            } else if (contentTop > childCloudHeight / 2) {
                upperGap = this.calculateExtraVerticalGap(spaceBetweenContentAndClouds);
            }
            int missingWidth = this.lastMinimumDistanceConsideringHandles - this.vGap - upperGap;
            if (missingWidth > upperGap) {
                upperGap = missingWidth;
            }
            this.y += this.vGap + upperGap;
        }
        this.yCoordinates[index] = yBegin = this.calculateInitialYPosition(childShiftY);
        this.adjustTotalShiftForAlignment(child, childShiftY, yBegin, childRegularHeight, availableSpace, y0);
        this.updateGapsAndBoundaries(index, child, childRegularHeight);
    }

    private int calculateAvailableSpaceForCompactLayout(NodeViewLayoutHelper child, int index, int y, int spaceForClouds) {
        StepFunction childTopBoundary;
        if (this.bottomBoundary != null && (childTopBoundary = this.view.usesHorizontalLayout() != child.usesHorizontalLayout() || child.getChildNodesAlignment().isStacked() ? StepFunction.segment(this.spaceAround, child.getWidth() - this.spaceAround, this.spaceAround + child.getTopOverlap()) : child.getTopBoundary()) != null) {
            int contentDistance;
            childTopBoundary = childTopBoundary.translate(this.xCoordinates[index], y - child.getTopOverlap());
            int topContentY = this.getContentTop(child) + y;
            int distance = childTopBoundary.distance(this.bottomBoundary);
            if (distance >= (contentDistance = topContentY - this.bottomContentY - spaceForClouds)) {
                return contentDistance;
            }
            return distance;
        }
        return 0;
    }

    private int calculateInitialYPosition(int childShiftY) {
        int yBegin;
        if (childShiftY < 0 && (!this.allowsCompactLayout || this.isFirstVisibleLaidOutChild())) {
            yBegin = this.y;
            this.y -= childShiftY;
        } else {
            if (!this.isFirstVisibleLaidOutChild() || this.allowsCompactLayout) {
                this.y += childShiftY;
            }
            yBegin = this.y;
        }
        return yBegin;
    }

    private void adjustTotalShiftForAlignment(NodeViewLayoutHelper child, int childShiftY, int yBegin, int childRegularHeight, int availableSpace, int y0) {
        ChildNodesAlignment.Placement placement = this.childNodesAlignment.placement();
        if (this.isFirstVisibleLaidOutChild() && !this.allowsCompactLayout && childShiftY != 0) {
            this.totalSideShiftY += placement == ChildNodesAlignment.Placement.CENTER ? childShiftY * 2 : childShiftY;
        }
        int contentTop = this.getContentTop(child);
        if (this.childNodesAlignment == ChildNodesAlignment.FLOW || this.childNodesAlignment == ChildNodesAlignment.AUTO) {
            int yContentBegin = contentTop + yBegin;
            int deltaShift = yContentBegin - (Math.max(this.yBottom, y0 - Math.max(availableSpace, 0)) + this.vGap) - (childShiftY > 0 || !this.isFirstVisibleLaidOutChild() ? childShiftY : 0);
            if (deltaShift > 0) {
                this.totalSideShiftY -= 2 * deltaShift;
            }
            this.totalSideShiftY -= child.getContentHeight() + this.vGap;
        } else {
            int yRef;
            int yEnd;
            if (this.isFirstVisibleLaidOutChild() && (placement == ChildNodesAlignment.Placement.TOP || placement == ChildNodesAlignment.Placement.CENTER)) {
                this.totalSideShiftY -= contentTop;
            }
            if (placement != ChildNodesAlignment.Placement.TOP && (yEnd = yBegin + childRegularHeight) > (yRef = this.isFirstVisibleLaidOutChild() ? 0 : this.yBottom + childShiftY)) {
                this.totalSideShiftY -= yEnd - yRef;
            }
        }
    }

    private int getContentTop(NodeViewLayoutHelper child) {
        return child.getContentY() - child.getTopOverlap() - this.spaceAround;
    }

    private void updateGapsAndBoundaries(int index, NodeViewLayoutHelper child, int childRegularHeight) {
        this.vGap = this.calculateNextVGap(index);
        this.bottomContentY = this.getContentTop(child) + this.y + child.getContentHeight();
        this.yBottom = Math.max(this.yBottom, this.y + childRegularHeight);
        this.yBottomCoordinates[index] = this.y;
        this.updateBottomBoundary(child, index, this.y, CombineOperation.FALLBACK);
        this.y += childRegularHeight;
        if (this.view.usesHorizontalLayout()) {
            this.lastMinimumDistanceConsideringHandles = child.getMinimumDistanceConsideringHandles();
        }
    }

    private int calculateNextVGap(int index) {
        int summaryNodeIndex = this.viewLevels.findSummaryNodeIndex(index);
        if (summaryNodeIndex == -1 || summaryNodeIndex - 1 == index) {
            return this.minimalGapBetweenChildren;
        }
        if (this.defaultVGap >= this.minimalGapBetweenChildren) {
            return this.minimalGapBetweenChildren;
        }
        return this.defaultVGap + (this.minimalGapBetweenChildren - this.defaultVGap) / 6;
    }

    private void handleFirstVisibleChildAlignment() {
        if (this.isFirstVisibleLaidOutChild() && this.childNodesAlignment == ChildNodesAlignment.AFTER_PARENT && this.contentSize.height > 0) {
            this.y += this.calculateAddedDistanceFromParentToChildren(this.minimalGapBetweenChildren, this.contentSize);
        }
    }

    private void assignSummaryChildVerticalPosition(int index, NodeViewLayoutHelper child, int childRegularHeight, int childShiftY) {
        int itemLevel = this.level - 1;
        if (child.isFirstGroupNode()) {
            this.initializeGroupStartIndex(itemLevel);
        }
        this.initializeGroupCoordinates(itemLevel);
        int summaryY = this.calculateSummaryChildVerticalPosition(this.groupUpperYCoordinate[itemLevel], this.groupLowerYCoordinate[itemLevel], child, childShiftY);
        if (!child.isFree()) {
            this.yCoordinates[index] = summaryY;
            int deltaY = summaryY - this.groupUpperYCoordinate[itemLevel];
            if (this.isAutoCompactLayoutEnabled && this.groupStartBoundaries[itemLevel] != null) {
                deltaY += this.adjustForAutoCompactLayout(index, child, itemLevel);
            }
            if (deltaY < 0) {
                this.handleNegativeDeltaY(index, itemLevel, deltaY);
                summaryY -= deltaY;
            }
            if (childRegularHeight != 0) {
                this.updateBottomBoundary(child, index, summaryY + this.minimalGapBetweenChildren, CombineOperation.MAX);
                summaryY += childRegularHeight + this.minimalGapBetweenChildren;
            }
            this.y = Math.max(this.y, summaryY);
            this.yBottom = Math.max(this.yBottom, summaryY);
            this.bottomContentY = Math.max(this.bottomContentY, summaryY);
        }
    }

    private void initializeGroupStartIndex(int itemLevel) {
        this.groupStartIndex[this.level] = this.groupStartIndex[itemLevel];
    }

    private void initializeGroupCoordinates(int itemLevel) {
        if (this.groupUpperYCoordinate[itemLevel] == Integer.MAX_VALUE) {
            this.groupUpperYCoordinate[itemLevel] = this.y;
            this.groupLowerYCoordinate[itemLevel] = this.y;
        }
    }

    private int adjustForAutoCompactLayout(int index, NodeViewLayoutHelper child, int itemLevel) {
        int distance;
        StepFunction childTopBoundary = child.getTopBoundary();
        if (childTopBoundary != null && (distance = (childTopBoundary = childTopBoundary.translate(this.xCoordinates[index], this.y)).distance(this.groupStartBoundaries[itemLevel]) - this.minimalGapBetweenChildren) < 0) {
            return distance;
        }
        return 0;
    }

    private void handleNegativeDeltaY(int index, int itemLevel, int deltaY) {
        if (this.childNodesAlignment == ChildNodesAlignment.FLOW) {
            this.totalSideShiftY += 2 * deltaY;
        }
        this.y -= deltaY;
        this.bottomBoundary = this.groupStartBoundaries[itemLevel];
        for (int j = this.groupStartIndex[itemLevel]; j <= index; ++j) {
            NodeViewLayoutHelper child;
            int childRegularHeight;
            NodeViewLayoutHelper childItem = this.view.getComponent(j);
            NodeViewLayoutHelper groupItem = childItem;
            if (groupItem.isLeft() != this.currentSideLeft || this.viewLevels.summaryLevels[j] <= 0 && this.isChildFreeNode[j]) continue;
            int n = j;
            this.yCoordinates[n] = this.yCoordinates[n] - deltaY;
            if (j == index || (childRegularHeight = (child = this.view.getComponent(j)).getHeight() - child.getTopOverlap() - child.getBottomOverlap() - 2 * this.spaceAround) == 0) continue;
            int n2 = j;
            this.yBottomCoordinates[n2] = this.yBottomCoordinates[n2] - deltaY;
            this.updateBottomBoundary(child, j, this.yBottomCoordinates[j], CombineOperation.FALLBACK);
        }
    }

    private void updateBottomBoundary(NodeViewLayoutHelper child, int index, int y, CombineOperation combineOperation) {
        if (this.isAutoCompactLayoutEnabled) {
            StepFunction childBottomBoundary = this.view.usesHorizontalLayout() != child.usesHorizontalLayout() || child.getChildNodesAlignment().isStacked() ? StepFunction.segment(this.spaceAround, child.getWidth() - this.spaceAround, child.getHeight() - this.spaceAround + child.getTopOverlap()) : child.getBottomBoundary();
            StepFunction stepFunction = childBottomBoundary = childBottomBoundary == null ? null : childBottomBoundary.translate(this.xCoordinates[index], y - child.getTopOverlap());
            this.bottomBoundary = this.bottomBoundary == null ? childBottomBoundary : (childBottomBoundary == null ? this.bottomBoundary : childBottomBoundary.combine(this.bottomBoundary, combineOperation));
        }
    }

    private int calculateSummaryChildVerticalPosition(int groupUpper, int groupLower, NodeViewLayoutHelper child, int childShiftY) {
        int childCloudHeight = CloudHeightCalculator.INSTANCE.getAdditionalCloudHeight(child);
        int childContentHeight = child.getContentHeight() + childCloudHeight;
        return (groupUpper + groupLower) / 2 - childContentHeight / 2 + childShiftY - (child.getContentY() - childCloudHeight / 2 - this.spaceAround);
    }

    private void updateSummaryGroupBounds(int childIndex, NodeViewLayoutHelper child, int level, boolean isItem, int childRegularHeight) {
        int childUpper = this.yCoordinates[childIndex];
        int childBottom = this.yCoordinates[childIndex] + childRegularHeight;
        if (child.isFirstGroupNode()) {
            if (isItem) {
                this.groupUpperYCoordinate[level] = Integer.MAX_VALUE;
                this.groupLowerYCoordinate[level] = Integer.MIN_VALUE;
            } else {
                this.groupUpperYCoordinate[level] = childUpper;
                this.groupLowerYCoordinate[level] = childBottom;
            }
        } else if (childRegularHeight != 0 || this.isNextNodeSummaryNode(childIndex)) {
            this.groupUpperYCoordinate[level] = Math.min(this.groupUpperYCoordinate[level], childUpper);
            this.groupLowerYCoordinate[level] = Math.max(childBottom, this.groupLowerYCoordinate[level]);
        }
    }

    private void applyLayoutToChildComponents() {
        int spaceAround = this.view.getSpaceAround();
        int cloudHeight = CloudHeightCalculator.INSTANCE.getAdditionalCloudHeight(this.view);
        int leftMostX = IntStream.of(this.xCoordinates).min().orElse(0);
        int contentX = Math.max(spaceAround, -leftMostX);
        int contentY = spaceAround + cloudHeight / 2 - Math.min(0, this.totalShiftY);
        this.view.setContentVisible(this.view.isContentVisible());
        int baseY = contentY - spaceAround + this.totalShiftY;
        int minYFree = this.calculateMinYFree(contentY, cloudHeight);
        int minYRegular = this.calculateMinYRegular(baseY);
        int shift = Math.min(minYRegular, minYFree);
        if (shift < 0) {
            contentY -= shift;
            baseY -= shift;
        }
        int topOverlap = Math.max(0, minYRegular - minYFree);
        this.arrangeChildComponents(contentX, contentY, baseY, cloudHeight, spaceAround, topOverlap);
    }

    private int calculateMinYFree(int contentY, int cloudHeight) {
        int minYFree = 0;
        for (int i = 0; i < this.childViewCount; ++i) {
            int topOverlap = this.view.getComponent(i).getTopOverlap();
            if (this.viewLevels.summaryLevels[i] != 0 || !this.isChildFreeNode[i]) continue;
            minYFree = Math.min(minYFree, contentY + this.yCoordinates[i] - cloudHeight / 2 - topOverlap);
        }
        return minYFree;
    }

    private int calculateMinYRegular(int baseY) {
        int minYRegular = 0;
        for (int i = 0; i < this.childViewCount; ++i) {
            int topOverlap = this.view.getComponent(i).getTopOverlap();
            if (this.viewLevels.summaryLevels[i] == 0 && this.isChildFreeNode[i]) continue;
            minYRegular = Math.min(minYRegular, baseY + this.yCoordinates[i] - topOverlap);
        }
        return minYRegular;
    }

    private void arrangeChildComponents(int contentX, int contentY, int baseY, int cloudHeight, int spaceAround, int topOverlap) {
        int height;
        this.view.setContentBounds(contentX, contentY, this.contentSize.width, this.contentSize.height);
        int cloudTop = cloudHeight / 2;
        int width = contentX + this.contentSize.width + spaceAround;
        int cloudBottom = cloudHeight - cloudTop;
        int heightWithoutOverlap = height = contentY + this.contentSize.height + cloudBottom + spaceAround;
        for (int i = 0; i < this.childViewCount; ++i) {
            NodeViewLayoutHelper child = this.view.getComponent(i);
            int childTopOverlap = child.getTopOverlap();
            boolean free = this.isChildFreeNode[i];
            int x = contentX + this.xCoordinates[i];
            int y = this.viewLevels.summaryLevels[i] == 0 && free ? contentY + this.yCoordinates[i] : baseY + this.yCoordinates[i] - childTopOverlap;
            child.setLocation(x, y);
            if (!free) {
                heightWithoutOverlap = Math.max(heightWithoutOverlap, y + child.getHeight() + cloudBottom - child.getBottomOverlap());
            }
            width = Math.max(width, x + child.getWidth());
            height = Math.max(height, y + child.getHeight() + cloudBottom);
        }
        this.view.setSize(width, height);
        this.view.setTopOverlap(topOverlap);
        this.view.setBottomOverlap(height - heightWithoutOverlap);
        if (!this.view.isFree() && this.view.isAutoCompactLayoutEnabled() && width > 2 * spaceAround) {
            if (cloudHeight == 0 && !this.childNodesAlignment.isStacked()) {
                this.calculateAndSetBoundaries(contentX, contentY, baseY, spaceAround, width, height);
            } else {
                StepFunction topBoundary = StepFunction.segment(spaceAround, width - spaceAround, spaceAround + topOverlap);
                this.view.setTopBoundary(topBoundary);
                this.view.setBottomBoundary(topBoundary.translate(0, heightWithoutOverlap - 2 * spaceAround));
            }
        } else {
            this.view.setTopBoundary(null);
            this.view.setBottomBoundary(null);
        }
    }

    private void calculateAndSetBoundaries(int contentX, int contentY, int baseY, int spaceAround, int width, int height) {
        NodeViewLayoutHelper parentView = this.view.getParentView();
        if (parentView == null || width <= spaceAround || height <= spaceAround) {
            return;
        }
        int segmentStart = this.view.isLeft() ? contentX - this.foldingMarkReservedSpace : contentX;
        int segmentEnd = this.view.isRight() ? contentX + this.contentSize.width + this.foldingMarkReservedSpace : contentX + this.contentSize.width;
        StepFunction viewBottomBoundary = this.calculateBottomBoundary(contentX, contentY, baseY, segmentStart, segmentEnd);
        StepFunction viewTopBoundary = this.calculateTopBoundary(contentY, segmentStart, segmentEnd);
        this.view.setTopBoundary(viewTopBoundary);
        this.view.setBottomBoundary(viewBottomBoundary);
    }

    private StepFunction calculateBottomBoundary(int contentX, int contentY, int baseY, int segmentStart, int segmentEnd) {
        StepFunction viewBottomBoundary;
        StepFunction stepFunction = viewBottomBoundary = this.contentSize.width <= 0 ? null : StepFunction.segment(segmentStart, segmentEnd, contentY + this.contentSize.height);
        if (this.leftBottomBoundary != null) {
            StepFunction stepFunction2 = viewBottomBoundary = viewBottomBoundary == null ? this.leftBottomBoundary.translate(contentX, baseY) : viewBottomBoundary.combine(this.leftBottomBoundary.translate(contentX, baseY), CombineOperation.MAX);
        }
        if (this.rightBottomBoundary != null) {
            viewBottomBoundary = viewBottomBoundary == null ? this.rightBottomBoundary.translate(contentX, baseY) : viewBottomBoundary.combine(this.rightBottomBoundary.translate(contentX, baseY), CombineOperation.MAX);
        }
        return viewBottomBoundary;
    }

    private StepFunction calculateTopBoundary(int contentY, int segmentStart, int segmentEnd) {
        StepFunction viewTopBoundary = this.contentSize.width <= 0 ? null : StepFunction.segment(segmentStart, segmentEnd, contentY);
        for (int i = this.childViewCount - 1; i >= 0; --i) {
            NodeViewLayoutHelper child = this.view.getComponent(i);
            StepFunction childTopBoundary = child.getTopBoundary();
            if (childTopBoundary == null) continue;
            childTopBoundary = childTopBoundary.translate(child.getX(), child.getY());
            viewTopBoundary = viewTopBoundary == null ? childTopBoundary : viewTopBoundary.combine(childTopBoundary, CombineOperation.MIN);
        }
        return viewTopBoundary;
    }

    private boolean isFirstVisibleLaidOutChild() {
        return this.visibleLaidOutChildCounter == 0;
    }
}

