/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.map;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.Rectangle;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import javax.swing.JComponent;
import javax.swing.JToolTip;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.features.mode.Controller;
import org.freeplane.view.swing.features.filepreview.IViewerFactory;
import org.freeplane.view.swing.features.filepreview.ImageRendererFactory;
import org.freeplane.view.swing.features.filepreview.ViewerController;
import org.freeplane.view.swing.map.TextualTooltipRendererFactory;

public class FreeplaneTooltip
extends JToolTip {
    public static final String TEXT_HTML = "text/html";
    private final GraphicsConfiguration graphicsConfiguration;
    private final String contentType;
    private URL baseUrl;
    private final boolean honorDisplayProperties;

    public FreeplaneTooltip(GraphicsConfiguration graphicsConfiguration, String contentType, boolean honorDisplayProperties) {
        this.graphicsConfiguration = graphicsConfiguration;
        this.contentType = contentType;
        this.honorDisplayProperties = honorDisplayProperties;
    }

    @Override
    public void setTipText(String tipText) {
        Dimension tooltipSize = this.tooltipSize(this.graphicsConfiguration);
        try {
            IViewerFactory viewerFactory;
            URI uri = new URI(tipText);
            ViewerController viewerController = Controller.getCurrentModeController().getExtension(ViewerController.class);
            if (viewerController != null && (viewerFactory = viewerController.getViewerFactory()).accept(uri)) {
                URI absoluteUri;
                URI uRI = absoluteUri = uri.isAbsolute() ? uri : this.baseUrl.toURI().resolve(uri);
                if (!absoluteUri.getScheme().equals("file") || new File(absoluteUri).canRead()) {
                    JComponent imageViewer = new ImageRendererFactory().createRenderer(viewerFactory, absoluteUri, tooltipSize);
                    this.add(imageViewer);
                    return;
                }
            }
        }
        catch (URISyntaxException uri) {
            // empty catch block
        }
        TextualTooltipRendererFactory tooltipScrollPaneFactory = new TextualTooltipRendererFactory(this.contentType, this.baseUrl, tipText, this.getComponent(), tooltipSize, this.honorDisplayProperties);
        this.add(tooltipScrollPaneFactory.getTooltipRenderer());
    }

    private Dimension tooltipSize(GraphicsConfiguration graphicsConfiguration) {
        Rectangle screenBounds = graphicsConfiguration.getBounds();
        int screenHeight = screenBounds.height - 80;
        int screenWidth = screenBounds.width - 80;
        int maximumHeight = Math.min(screenHeight, this.getIntProperty("toolTipManager.max_tooltip_height"));
        int maximumWidth = Math.min(screenWidth, this.getIntProperty("toolTipManager.max_tooltip_width"));
        Dimension maximumSize = new Dimension(maximumWidth, maximumHeight);
        return maximumSize;
    }

    private int getIntProperty(String propertyName) {
        return ResourceController.getResourceController().getIntProperty(propertyName, Integer.MAX_VALUE);
    }

    @Override
    public Dimension getPreferredSize() {
        Component renderer = this.getComponent(0);
        return renderer.getPreferredSize();
    }

    @Override
    public void doLayout() {
        Component renderer = this.getComponent(0);
        renderer.setSize(this.getSize());
        super.doLayout();
    }

    public void setBase(URL url) {
        this.baseUrl = url;
    }
}

