/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.util;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.antlr.v4.runtime.misc.Interval;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.text.AbstractInformationControl;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IInformationControlExtension2;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextHoverExtension;
import org.eclipse.jface.text.ITextHoverExtension2;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.IAnnotationHoverExtension;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ILineRange;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.LineRange;
import org.eclipse.jface.util.Geometry;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.texteditor.MarkerAnnotation;
import org.eclipse.ui.texteditor.spelling.SpellingAnnotation;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.stm.STMUtils;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditorBase;
import org.jkiss.dbeaver.ui.editors.sql.semantics.SQLSemanticErrorAnnotation;
import org.jkiss.dbeaver.ui.editors.sql.syntax.SQLProblemAnnotation;
import org.jkiss.dbeaver.ui.editors.sql.util.AbstractSQLEditorTextHover;
import org.jkiss.utils.CommonUtils;

public class SQLAnnotationHover
extends AbstractSQLEditorTextHover
implements ITextHover,
IAnnotationHover,
ITextHoverExtension,
ITextHoverExtension2,
IAnnotationHoverExtension {
    private static final Log log = Log.getLog(SQLAnnotationHover.class);
    private SQLEditorBase editor;

    public SQLAnnotationHover(SQLEditorBase editor) {
        this.setEditor((IEditorPart)editor);
    }

    public String getHoverInfo(ISourceViewer sourceViewer, int lineNumber) {
        try {
            int linePosition = sourceViewer.getDocument().getLineOffset(lineNumber);
            int lineLength = sourceViewer.getDocument().getLineLength(lineNumber);
            StringBuilder sb = new StringBuilder();
            Iterator ai = sourceViewer.getAnnotationModel().getAnnotationIterator();
            while (ai.hasNext()) {
                Position annoPosition;
                Annotation anno = (Annotation)ai.next();
                if (!this.isSupportedAnnotation(anno) || (annoPosition = sourceViewer.getAnnotationModel().getPosition(anno)) == null || !annoPosition.overlapsWith(linePosition, lineLength)) continue;
                sb.append(anno.getText()).append("; ");
            }
            return sb.isEmpty() ? null : sb.toString();
        }
        catch (BadLocationException e) {
            log.debug((Object)e);
            return null;
        }
    }

    public String getHoverInfo(ITextViewer textViewer, IRegion hoverRegion) {
        Object hoverInfo2 = this.getHoverInfo2(textViewer, hoverRegion);
        return hoverInfo2 == null ? null : hoverInfo2.toString();
    }

    public Object getHoverInfo2(ITextViewer textViewer, IRegion hoverRegion) {
        return this.getHoverInfoImpl(textViewer, hoverRegion, null);
    }

    private Object getHoverInfoImpl(ITextViewer textViewer, IRegion hoverRegion, Integer anchorLine) {
        if (!(textViewer instanceof ISourceViewer)) {
            return null;
        }
        HashMap<String, AnnotationsGroupInfo> linkGroupsByMessage = new HashMap<String, AnnotationsGroupInfo>();
        IAnnotationModel annotationModel = ((ISourceViewer)textViewer).getAnnotationModel();
        Iterator ai = annotationModel.getAnnotationIterator();
        while (ai.hasNext()) {
            Position annoPosition;
            Annotation anno = (Annotation)ai.next();
            if (!this.isSupportedAnnotation(anno) || (annoPosition = annotationModel.getPosition(anno)) == null || !annoPosition.overlapsWith(hoverRegion.getOffset(), hoverRegion.getLength())) continue;
            linkGroupsByMessage.computeIfAbsent(anno.getText(), string -> new AnnotationsGroupInfo((String)string)).add(anno, annoPosition);
        }
        if (linkGroupsByMessage.isEmpty()) {
            return null;
        }
        List<AnnotationsGroupInfo> annotationsGroups = linkGroupsByMessage.values().stream().sorted(Comparator.comparing(g -> g.getFirstPosition().getOffset())).toList();
        if (anchorLine == null) {
            Position lastAnnotationPos = annotationsGroups.stream().max(Comparator.comparing(g -> g.getLastPosition().getOffset() + g.getLastPosition().getLength())).get().getLastPosition();
            int lastAnnotationOffset = lastAnnotationPos.getOffset() + lastAnnotationPos.getLength();
            try {
                anchorLine = this.editor.getDocument().getLineOfOffset(lastAnnotationOffset);
            }
            catch (BadLocationException e) {
                log.debug((Object)("Error obtaining anchor line of annotation offset " + String.valueOf(lastAnnotationPos)), (Throwable)e);
                try {
                    anchorLine = this.editor.getDocument().getLineOfOffset(hoverRegion.getOffset());
                }
                catch (BadLocationException badLocationException) {
                    log.debug((Object)("Error obtaining anchor line of hover region offset " + hoverRegion.getOffset()), (Throwable)e);
                    anchorLine = -1;
                }
            }
        }
        return new AnnotationsHoverInfo(annotationsGroups, anchorLine);
    }

    @Override
    public IRegion getHoverRegion(ITextViewer textViewer, int offset) {
        if (!(textViewer instanceof ISourceViewer)) {
            return null;
        }
        Interval hoverInterval = new Interval(offset, offset);
        Interval resultInterval = null;
        IAnnotationModel annotationModel = ((ISourceViewer)textViewer).getAnnotationModel();
        if (annotationModel != null) {
            Iterator ai = annotationModel.getAnnotationIterator();
            while (ai.hasNext()) {
                Interval annoInterval;
                Position annoPosition;
                Annotation anno = (Annotation)ai.next();
                if (!this.isSupportedAnnotation(anno) || (annoPosition = annotationModel.getPosition(anno)) == null || !(annoInterval = new Interval(annoPosition.getOffset(), annoPosition.getOffset() + annoPosition.getLength())).properlyContains(hoverInterval)) continue;
                Interval interval = resultInterval = resultInterval == null ? annoInterval : resultInterval.union(annoInterval);
            }
        }
        return resultInterval == null ? null : new Region(resultInterval.a, resultInterval.length());
    }

    public Object getHoverInfo(ISourceViewer sourceViewer, ILineRange lineRange, int visibleNumberOfLines) {
        try {
            Integer anchorLine = lineRange.getNumberOfLines() == 1 ? Integer.valueOf(lineRange.getStartLine()) : null;
            IRegion lineRegion = sourceViewer.getDocument().getLineInformation(lineRange.getStartLine());
            return this.getHoverInfoImpl((ITextViewer)sourceViewer, lineRegion, anchorLine);
        }
        catch (BadLocationException e) {
            log.debug((Object)e);
            return null;
        }
    }

    public ILineRange getHoverLineRange(ISourceViewer viewer, int lineNumber) {
        return new LineRange(lineNumber, 1);
    }

    public boolean canHandleMouseCursor() {
        return true;
    }

    @Override
    public void setEditor(IEditorPart editor) {
        this.editor = (SQLEditorBase)editor;
    }

    @Override
    public IInformationControlCreator getHoverControlCreator() {
        return shell -> new LinkListInformationControl(shell);
    }

    private boolean isSupportedAnnotation(Annotation anno) {
        return anno instanceof SpellingAnnotation || anno instanceof SQLProblemAnnotation || anno instanceof SQLSemanticErrorAnnotation;
    }

    private class AnnotationHyperlinkInfo {
        @NotNull
        private final Annotation annotation;
        @NotNull
        private final Position position;

        private AnnotationHyperlinkInfo(@NotNull Annotation annotation, Position position) {
            this.annotation = annotation;
            this.position = position;
        }

        @NotNull
        public Annotation getAnnotation() {
            return this.annotation;
        }

        @NotNull
        public Position getPosition() {
            return this.position;
        }

        public void open() {
            TextViewer textViewer = SQLAnnotationHover.this.editor.getTextViewer();
            if (textViewer != null && !this.position.isDeleted) {
                textViewer.setSelectedRange(this.position.getOffset(), this.position.getLength());
                textViewer.revealRange(this.position.getOffset(), this.position.getLength());
            }
        }
    }

    private class AnnotationsGroupInfo {
        private static final Position MIN_POSITION = new Position(0, 0);
        private static final Position MAX_POSITION = new Position(Integer.MAX_VALUE, 0);
        private static final int UNKNOWN_SEVERITY = -1;
        @NotNull
        private final List<AnnotationHyperlinkInfo> annotations = new ArrayList<AnnotationHyperlinkInfo>();
        @NotNull
        private final String message;
        @NotNull
        private Position firstPosition = MAX_POSITION;
        @NotNull
        private Position lastPosition = MIN_POSITION;
        private int severity = -1;

        private AnnotationsGroupInfo(String message) {
            this.message = message;
        }

        public void add(@NotNull Annotation anno, @NotNull Position annoPosition) {
            Position firstPos = this.firstPosition;
            if (firstPos.offset > annoPosition.offset) {
                this.firstPosition = annoPosition;
            }
            Position lastPos = this.lastPosition;
            if (lastPos.offset + lastPos.length < annoPosition.offset + annoPosition.length) {
                this.lastPosition = annoPosition;
            }
            AnnotationHyperlinkInfo entry = new AnnotationHyperlinkInfo(anno, annoPosition);
            STMUtils.orderedInsert(this.annotations, e -> e.getPosition().getOffset(), (Object)entry, Integer::compare);
            this.severity = Math.max(this.severity, this.getAnnotationSeverity(anno));
        }

        @NotNull
        public List<AnnotationHyperlinkInfo> getAnnotations() {
            return this.annotations;
        }

        @NotNull
        public String getMessage() {
            return this.message;
        }

        @NotNull
        public Position getFirstPosition() {
            return this.firstPosition;
        }

        @NotNull
        public Position getLastPosition() {
            return this.lastPosition;
        }

        @Nullable
        public DBIcon getIcon() {
            return switch (this.severity) {
                case 2 -> DBIcon.SMALL_ERROR;
                case 1 -> DBIcon.SMALL_WARNING;
                case 0 -> DBIcon.SMALL_INFO;
                default -> null;
            };
        }

        private int getAnnotationSeverity(@NotNull Annotation anno) {
            if (anno instanceof MarkerAnnotation) {
                MarkerAnnotation ma = (MarkerAnnotation)anno;
                try {
                    int n;
                    Object object = ma.getMarker().getAttribute("severity");
                    if (object instanceof Integer) {
                        Integer n2 = (Integer)object;
                        n = n2;
                    } else {
                        n = 0;
                    }
                    return n;
                }
                catch (CoreException e) {
                    log.error((Object)"Failed to obtain annotation severity icon", (Throwable)e);
                    return -1;
                }
            }
            return 0;
        }
    }

    private record AnnotationsHoverInfo(@NotNull List<AnnotationsGroupInfo> annotationsGroups, int tooltipAnchorLine) {
    }

    private class LinkListInformationControl
    extends AbstractInformationControl
    implements IInformationControlExtension2 {
        private IHyperlinkListener hyperlinkListener;
        private Composite linksContainer;
        private int tooltipAnchorLine;

        public LinkListInformationControl(Shell parentShell) {
            super(parentShell, false);
            this.hyperlinkListener = new IHyperlinkListener(){
                private Point oldSelection = null;

                public void linkEntered(HyperlinkEvent e) {
                    Object object = e.getHref();
                    if (object instanceof AnnotationHyperlinkInfo) {
                        AnnotationHyperlinkInfo hyperlink = (AnnotationHyperlinkInfo)object;
                        this.oldSelection = ((LinkListInformationControl)LinkListInformationControl.this).SQLAnnotationHover.this.editor.getTextViewer() != null ? ((LinkListInformationControl)LinkListInformationControl.this).SQLAnnotationHover.this.editor.getTextViewer().getSelectedRange() : null;
                        Position hyperlinkRegion = hyperlink.getPosition();
                        if (!hyperlinkRegion.isDeleted) {
                            ((LinkListInformationControl)LinkListInformationControl.this).SQLAnnotationHover.this.editor.getTextViewer().setSelectedRange(hyperlinkRegion.getOffset(), hyperlinkRegion.getLength());
                        }
                    }
                }

                public void linkExited(HyperlinkEvent e) {
                    if (this.oldSelection != null && ((LinkListInformationControl)LinkListInformationControl.this).SQLAnnotationHover.this.editor.getTextViewer() != null) {
                        ((LinkListInformationControl)LinkListInformationControl.this).SQLAnnotationHover.this.editor.getTextViewer().setSelectedRange(this.oldSelection.x, this.oldSelection.y);
                        this.oldSelection = null;
                    }
                }

                public void linkActivated(HyperlinkEvent e) {
                    Object object = e.getHref();
                    if (object instanceof AnnotationHyperlinkInfo) {
                        AnnotationHyperlinkInfo hyperlink = (AnnotationHyperlinkInfo)object;
                        hyperlink.open();
                    }
                }
            };
            this.tooltipAnchorLine = -1;
            this.setBackgroundColor(new Color(255, 128, 128));
            this.create();
        }

        public void setInformation(String information) {
        }

        public void setInput(Object input) {
            AnnotationsHoverInfo hoverInfo = (AnnotationsHoverInfo)input;
            this.tooltipAnchorLine = hoverInfo.tooltipAnchorLine;
            for (AnnotationsGroupInfo annotationGroup : hoverInfo.annotationsGroups()) {
                Composite linksGroupContainer;
                if (hoverInfo.annotationsGroups().size() > 1) {
                    linksGroupContainer = UIUtils.createComposite((Composite)this.linksContainer, (int)2);
                    DBIcon icon = annotationGroup.getIcon();
                    if (icon != null) {
                        UIUtils.createLabel((Composite)linksGroupContainer, (DBPImage)icon);
                    } else {
                        UIUtils.createPlaceholder((Composite)linksGroupContainer, (int)1);
                    }
                } else {
                    linksGroupContainer = this.linksContainer;
                }
                List<AnnotationHyperlinkInfo> hyperlinks = annotationGroup.getAnnotations();
                assert (hyperlinks.size() > 0);
                int alsoLinksToShow = Math.min(5, hyperlinks.size() - 1) + 1;
                Composite groupLinksContainer = UIUtils.createPlaceholder((Composite)linksGroupContainer, (int)(hyperlinks.size() == 1 ? 1 : alsoLinksToShow * 2 + 1), (int)0);
                this.createHyperlinkControl(groupLinksContainer, hyperlinks.get(0), annotationGroup.getMessage());
                if (hyperlinks.size() <= 2) continue;
                UIUtils.createLabel((Composite)groupLinksContainer, (String)" (also at position ");
                int i = 1;
                while (i < alsoLinksToShow) {
                    AnnotationHyperlinkInfo hyperlink = hyperlinks.get(i);
                    if (i > 1) {
                        UIUtils.createLabel((Composite)groupLinksContainer, (String)", ");
                    }
                    this.createHyperlinkControl(groupLinksContainer, hyperlink, Integer.toString(hyperlink.getPosition().getOffset()));
                    ++i;
                }
                UIUtils.createLabel((Composite)groupLinksContainer, (String)(hyperlinks.size() <= 5 ? ")" : ", ... " + hyperlinks.size() + " such problems in line)"));
            }
            super.getShell().pack(true);
        }

        private void createHyperlinkControl(Composite groupLinksContainer, AnnotationHyperlinkInfo hyperlink, String text) {
            SQLSemanticErrorAnnotation s;
            String underlyingError;
            Hyperlink link = new Hyperlink(groupLinksContainer, 0);
            link.setHref((Object)hyperlink);
            link.setText(text);
            link.setUnderlined(true);
            link.addHyperlinkListener(this.hyperlinkListener);
            Annotation annotation = hyperlink.getAnnotation();
            if (annotation instanceof SQLSemanticErrorAnnotation && CommonUtils.isNotEmpty((String)(underlyingError = (s = (SQLSemanticErrorAnnotation)annotation).getUnderlyingErrorMessage()))) {
                link.setToolTipText(underlyingError);
            }
        }

        protected void createContent(Composite parent) {
            this.linksContainer = UIUtils.createComposite((Composite)parent, (int)1);
            this.linksContainer.setLayout((Layout)GridLayoutFactory.swtDefaults().create());
        }

        public boolean hasContents() {
            return true;
        }

        public Point computeSizeHint() {
            Rectangle bounds = this.getBounds();
            return new Point(bounds.width, bounds.height);
        }

        public void setVisible(boolean visible) {
            if (visible && this.tooltipAnchorLine >= 0 && SQLAnnotationHover.this.editor.getDocument() != null && SQLAnnotationHover.this.editor.getTextViewer() != null) {
                try {
                    IRegion modelLineRange = SQLAnnotationHover.this.editor.getDocument().getLineInformation(this.tooltipAnchorLine);
                    IRegion visualLineRange = SQLAnnotationHover.this.editor.getTextViewer().modelRange2WidgetRange(modelLineRange);
                    StyledText widget = SQLAnnotationHover.this.editor.getTextViewer().getTextWidget();
                    int offset = visualLineRange.getOffset();
                    Rectangle localLineBounds = widget.getTextBounds(offset, offset + visualLineRange.getLength() - 1);
                    Rectangle globalLineBounds = Geometry.toDisplay((Control)widget, (Rectangle)localLineBounds);
                    Rectangle globalWidgetBounds = Geometry.toDisplay((Control)widget, (Rectangle)widget.getBounds());
                    int y = Math.min(globalLineBounds.y + globalLineBounds.height, globalWidgetBounds.y + globalWidgetBounds.height - widget.getHorizontalBar().getSize().y);
                    boolean hasTooltipRanAway = !globalWidgetBounds.intersects(this.getBounds());
                    Rectangle adjustedBounds = new Rectangle(globalLineBounds.x, y, globalLineBounds.width, globalLineBounds.height);
                    if (this.getBounds().intersects(adjustedBounds) || hasTooltipRanAway) {
                        int x = hasTooltipRanAway ? Math.min(widget.getDisplay().getCursorLocation().x, globalLineBounds.x) : this.getBounds().x;
                        this.setLocation(new Point(x, y));
                    }
                    super.getShell().pack(true);
                }
                catch (BadLocationException badLocationException) {}
            }
            super.setVisible(visible);
        }
    }
}

