/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.semantics.model.select;

import java.util.List;
import org.antlr.v4.runtime.misc.Interval;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.sql.semantics.SQLQueryLexicalScope;
import org.jkiss.dbeaver.model.sql.semantics.SQLQueryRecognitionContext;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbol;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbolClass;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbolEntry;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbolOrigin;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryDataContext;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryResultColumn;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryRowsDataContext;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryRowsSourceContext;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQueryNodeModelVisitor;
import org.jkiss.dbeaver.model.sql.semantics.model.expressions.SQLQueryValueExpression;
import org.jkiss.dbeaver.model.sql.semantics.model.select.SQLQueryRowsSetOperationModel;
import org.jkiss.dbeaver.model.sql.semantics.model.select.SQLQueryRowsSourceModel;
import org.jkiss.dbeaver.model.stm.STMTreeNode;

public class SQLQueryRowsNaturalJoinModel
extends SQLQueryRowsSetOperationModel {
    @Nullable
    private final SQLQueryValueExpression condition;
    @Nullable
    private final List<SQLQuerySymbolEntry> columnsToJoin;
    @NotNull
    private final SQLQueryLexicalScope conditionScope;
    private final boolean isLateral;

    public SQLQueryRowsNaturalJoinModel(@NotNull Interval range, @NotNull STMTreeNode syntaxNode, @NotNull SQLQueryRowsSourceModel left, @NotNull SQLQueryRowsSourceModel right, boolean isLateral, @NotNull SQLQueryValueExpression condition, @NotNull SQLQueryLexicalScope conditionScope) {
        super(range, syntaxNode, left, right);
        super.registerSubnode(condition);
        this.isLateral = isLateral;
        this.condition = condition;
        this.conditionScope = conditionScope;
        this.columnsToJoin = null;
        this.registerLexicalScope(conditionScope);
    }

    public SQLQueryRowsNaturalJoinModel(@NotNull Interval range, @NotNull STMTreeNode syntaxNode, @NotNull SQLQueryRowsSourceModel left, @NotNull SQLQueryRowsSourceModel right, boolean isLateral, @Nullable List<SQLQuerySymbolEntry> columnsToJoin, @NotNull SQLQueryLexicalScope conditionScope) {
        super(range, syntaxNode, left, right);
        this.isLateral = isLateral;
        this.condition = null;
        this.conditionScope = conditionScope;
        this.columnsToJoin = columnsToJoin;
        this.registerLexicalScope(conditionScope);
    }

    @Nullable
    public SQLQueryValueExpression getCondition() {
        return this.condition;
    }

    @Nullable
    public List<SQLQuerySymbolEntry> getColumnsToJoin() {
        return this.columnsToJoin;
    }

    @Override
    @NotNull
    protected SQLQueryDataContext propagateContextImpl(@NotNull SQLQueryDataContext context, @NotNull SQLQueryRecognitionContext statistics) {
        SQLQueryDataContext left = this.left.propagateContext(context, statistics);
        SQLQueryDataContext right = this.right.propagateContext(this.isLateral ? left : context, statistics);
        SQLQueryDataContext combinedContext = left.combineForJoin(right);
        if (this.columnsToJoin != null) {
            SQLQuerySymbolOrigin.ColumnNameFromContext columnNameOrigin = new SQLQuerySymbolOrigin.ColumnNameFromContext(combinedContext);
            for (SQLQuerySymbolEntry column : this.columnsToJoin) {
                if (!column.isNotClassified()) continue;
                SQLQuerySymbol symbol = column.getSymbol();
                SQLQueryResultColumn leftColumnDef = left.resolveColumn(statistics.getMonitor(), column.getName());
                SQLQueryResultColumn rightColumnDef = right.resolveColumn(statistics.getMonitor(), column.getName());
                if (leftColumnDef != null && rightColumnDef != null) {
                    symbol.setDefinition(column);
                    symbol.setSymbolClass(SQLQuerySymbolClass.COLUMN);
                } else {
                    if (leftColumnDef == null) {
                        statistics.appendError(column, "Column " + column.getName() + " not found on the left of join");
                    } else {
                        statistics.appendError(column, "Column " + column.getName() + " not found on the right of join");
                    }
                    symbol.setSymbolClass(SQLQuerySymbolClass.ERROR);
                }
                column.setOrigin(columnNameOrigin);
            }
            this.conditionScope.setSymbolsOrigin(columnNameOrigin);
        } else {
            SQLQuerySymbolOrigin.ValueRefFromContext conditionOrigin = new SQLQuerySymbolOrigin.ValueRefFromContext(combinedContext);
            this.setTailOrigin(conditionOrigin);
            if (this.condition != null) {
                this.condition.propagateContext(combinedContext, statistics);
                this.conditionScope.setSymbolsOrigin(conditionOrigin);
            }
        }
        return combinedContext;
    }

    @Override
    @NotNull
    protected SQLQueryRowsSourceContext resolveRowSourcesImpl(@NotNull SQLQueryRowsSourceContext context, @NotNull SQLQueryRecognitionContext statistics) {
        context = this.left.resolveRowSources(context, statistics).combine(this.right.resolveRowSources(context, statistics));
        if (this.condition != null) {
            this.condition.resolveRowSources(context, statistics);
        }
        return context;
    }

    @Override
    @NotNull
    protected SQLQueryRowsDataContext resolveRowDataImpl(@NotNull SQLQueryRowsDataContext context, @NotNull SQLQueryRecognitionContext statistics) {
        SQLQueryRowsDataContext x = this.left.getRowsDataContext().combine(this.right.getRowsDataContext());
        SQLQueryRowsDataContext combinedContext = this.getRowsSources().makeTuple(this, x.getColumnsList(), x.getPseudoColumnsList());
        if (this.columnsToJoin != null) {
            SQLQuerySymbolOrigin.ColumnNameFromRowsData columnNameOrigin = new SQLQuerySymbolOrigin.ColumnNameFromRowsData(combinedContext);
            for (SQLQuerySymbolEntry column : this.columnsToJoin) {
                if (!column.isNotClassified()) continue;
                SQLQuerySymbol symbol = column.getSymbol();
                SQLQueryResultColumn leftColumnDef = this.left.getRowsDataContext().resolveColumn(statistics.getMonitor(), column.getName());
                SQLQueryResultColumn rightColumnDef = this.right.getRowsDataContext().resolveColumn(statistics.getMonitor(), column.getName());
                if (leftColumnDef != null && rightColumnDef != null) {
                    symbol.setDefinition(column);
                    symbol.setSymbolClass(SQLQuerySymbolClass.COLUMN);
                } else {
                    if (leftColumnDef == null) {
                        statistics.appendError(column, "Column " + column.getName() + " not found on the left of join");
                    } else {
                        statistics.appendError(column, "Column " + column.getName() + " not found on the right of join");
                    }
                    symbol.setSymbolClass(SQLQuerySymbolClass.ERROR);
                }
                column.setOrigin(columnNameOrigin);
            }
            this.conditionScope.setSymbolsOrigin(columnNameOrigin);
        } else {
            SQLQuerySymbolOrigin.RowsDataRef conditionOrigin = new SQLQuerySymbolOrigin.RowsDataRef(combinedContext);
            this.setTailOrigin(conditionOrigin);
            if (this.condition != null) {
                this.condition.resolveValueRelations(combinedContext, statistics);
                this.conditionScope.setSymbolsOrigin(conditionOrigin);
            }
        }
        return combinedContext;
    }

    @Override
    protected <R, T> R applyImpl(@NotNull SQLQueryNodeModelVisitor<T, R> visitor, @NotNull T arg) {
        return visitor.visitRowsNaturalJoin(this, arg);
    }
}

