/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.semantics.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.TreeMap;
import java.util.function.BiConsumer;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.antlr.v4.runtime.misc.Interval;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.sql.semantics.SQLQueryLexicalScope;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbolOrigin;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryDataContext;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQueryNodeModelVisitor;
import org.jkiss.dbeaver.model.stm.STMTreeNode;
import org.jkiss.dbeaver.model.stm.STMUtils;
import org.jkiss.dbeaver.utils.ListNode;
import org.jkiss.utils.Pair;

public abstract class SQLQueryNodeModel {
    @NotNull
    private final Interval region;
    @NotNull
    private final STMTreeNode syntaxNode;
    @Nullable
    private List<SQLQueryNodeModel> subnodes;
    @Nullable
    private List<SQLQueryLexicalScope> lexicalScopes = null;
    @Nullable
    private SQLQuerySymbolOrigin tailOrigin = null;

    protected SQLQueryNodeModel(@NotNull Interval region, @NotNull STMTreeNode syntaxNode, SQLQueryNodeModel ... subnodes) {
        this.region = region;
        this.syntaxNode = syntaxNode;
        if (subnodes == null || subnodes.length == 0) {
            this.subnodes = null;
        } else {
            this.subnodes = Stream.of(subnodes).filter(Objects::nonNull).collect(Collectors.toCollection(() -> new ArrayList(subnodes.length)));
            this.subnodes.sort(Comparator.comparingInt(n -> n.region.a));
        }
    }

    protected void setTailOrigin(SQLQuerySymbolOrigin tailOrigin) {
        this.tailOrigin = tailOrigin;
    }

    @Nullable
    public SQLQuerySymbolOrigin getTailOrigin() {
        return this.tailOrigin;
    }

    public void registerLexicalScope(@NotNull SQLQueryLexicalScope lexicalScope) {
        List<SQLQueryLexicalScope> scopes = this.lexicalScopes;
        if (scopes == null) {
            this.lexicalScopes = scopes = new ArrayList<SQLQueryLexicalScope>();
        }
        scopes.add(lexicalScope);
    }

    public SQLQueryLexicalScope findLexicalScope(int position) {
        List<SQLQueryLexicalScope> scopes = this.lexicalScopes;
        if (scopes != null) {
            for (SQLQueryLexicalScope s : scopes) {
                Interval region = s.getInterval();
                if (region.a > position || region.b < position) continue;
                return s;
            }
        }
        return null;
    }

    protected void registerSubnode(@NotNull SQLQueryNodeModel subnode) {
        this.subnodes = STMUtils.orderedInsert(this.subnodes, n -> n.region.a, (Object)subnode, Comparator.comparingInt(x -> x));
    }

    @NotNull
    public final Interval getInterval() {
        return this.region;
    }

    @NotNull
    public final STMTreeNode getSyntaxNode() {
        return this.syntaxNode;
    }

    public final <T, R> R apply(@NotNull SQLQueryNodeModelVisitor<T, R> visitor, @NotNull T arg) {
        return this.applyImpl(visitor, arg);
    }

    protected abstract <R, T> R applyImpl(@NotNull SQLQueryNodeModelVisitor<T, R> var1, T var2);

    protected SQLQueryNodeModel findChildNodeContaining(int position) {
        if (this.subnodes != null) {
            if (this.subnodes.size() == 1) {
                SQLQueryNodeModel node = this.subnodes.get(0);
                return node.region.a <= position && node.region.b >= position - 1 ? node : null;
            }
            int index = STMUtils.binarySearchByKey(this.subnodes, n -> n.region.a, (Object)position, Comparator.comparingInt(x -> x));
            if (index >= 0) {
                SQLQueryNodeModel node = this.subnodes.get(index);
                int i = index + 1;
                while (i < this.subnodes.size()) {
                    SQLQueryNodeModel next = this.subnodes.get(i++);
                    if (next.region.a > position - 1) break;
                    node = next;
                    ++i;
                }
                return node;
            }
            int i = ~index - 1;
            while (i >= 0) {
                SQLQueryNodeModel node = this.subnodes.get(i);
                if (node.region.a <= position && node.region.b >= position - 1) {
                    return node;
                }
                if (node.region.b < position) break;
                --i;
            }
        }
        return null;
    }

    @Nullable
    public abstract SQLQueryDataContext getGivenDataContext();

    @Nullable
    public abstract SQLQueryDataContext getResultDataContext();

    public String collectScopesHierarchyDebugView() {
        var local = new Object(){

            public Range collectModel(SQLQueryNodeModel node) {
                class Range
                implements 1ITextBlock {
                    public final String label;
                    public final Interval interval;
                    public final List<List<Range>> subranges = new ArrayList<List<Range>>();

                    public Range(String label, Interval interval) {
                        this.label = label;
                        this.interval = interval;
                    }

                    @Override
                    public Interval getInterval() {
                        return this.interval;
                    }

                    @Override
                    public String prepareText(int widthToFill) {
                        String a = Integer.toString(this.interval.a);
                        String b = Integer.toString(this.interval.b);
                        int minWidth = a.length() + 1 + this.label.length() + 1 + b.length();
                        int space = Math.max(0, widthToFill - minWidth);
                        int space1 = space / 2;
                        int space2 = space - space1;
                        return a + " ".repeat(1 + space1) + this.label + " ".repeat(1 + space2) + b;
                    }

                    public List<Range> createSubrangesLayer() {
                        ArrayList<Range> ranges = new ArrayList<Range>();
                        this.subranges.add(ranges);
                        return ranges;
                    }

                    public int collectText(TextBlocks text) {
                        class TextBlocks {
                            private final List<TextBlocksLine> lines = new ArrayList<TextBlocksLine>();

                            TextBlocks() {
                                class TextBlocksLine {
                                    private final List<1TextBlockInfo> blocks = new ArrayList<1TextBlockInfo>();

                                    TextBlocksLine() {
                                        class TextBlockInfo {
                                            public final 1ITextBlock block;
                                            public final int contentWidth;
                                            public NavigableMap<Integer, 1ColumnInfo> columns = null;

                                            public TextBlockInfo(1ITextBlock block, int contentWidth) {
                                                class ColumnInfo {
                                                    public final int position;
                                                    public int width = 0;

                                                    public ColumnInfo(int position) {
                                                        this.position = position;
                                                    }
                                                }
                                                static interface ITextBlock {
                                                    public Interval getInterval();

                                                    public String prepareText(int var1);
                                                }
                                                this.block = block;
                                                this.contentWidth = contentWidth;
                                            }
                                        }
                                    }

                                    public void add(1ITextBlock block, int width) {
                                        static interface ITextBlock {
                                            public Interval getInterval();

                                            public String prepareText(int var1);
                                        }
                                        this.blocks.add(new TextBlockInfo(block, width));
                                    }

                                    public void collectColumns(1TextBlocksColumnsMap columns) {
                                        for (TextBlockInfo b : this.blocks) {
                                            static interface ITextBlock {
                                                public Interval getInterval();

                                                public String prepareText(int var1);
                                            }
                                            Interval r = b.block.getInterval();
                                            class TextBlocksColumnsMap {
                                                private final TreeMap<Integer, ColumnInfo> columns = new TreeMap();

                                                public TextBlocksColumnsMap() {
                                                    this.columns.put(0, new ColumnInfo(0));
                                                }

                                                public void register(int position) {
                                                    this.columns.put(position, new ColumnInfo(position));
                                                }
                                            }
                                            columns.register(r.a);
                                            columns.register((r.b + r.a) / 2);
                                            columns.register(r.b + 1);
                                            b.columns = columns.columns.subMap(r.a, true, (r.b == Integer.MAX_VALUE ? r.a : r.b) + 1, false);
                                            System.out.println(String.valueOf(r) + " : " + b.columns.size());
                                        }
                                    }

                                    public void adjustComlumns() {
                                        for (TextBlockInfo b : this.blocks) {
                                            int currWidth = b.columns.values().stream().mapToInt(c -> c.width).sum();
                                            int delta = b.contentWidth - currWidth;
                                            if (delta <= 0) continue;
                                            System.out.println("adjusting " + currWidth + " to " + b.contentWidth);
                                            int eqstep = delta / b.columns.size();
                                            int rest = b.contentWidth;
                                            for (ColumnInfo c2 : b.columns.values()) {
                                                if (c2.width < eqstep) {
                                                    c2.width = eqstep;
                                                    System.out.println("  column " + c2.position + " for " + c2.width);
                                                }
                                                rest -= c2.width;
                                            }
                                            if (rest <= 0) continue;
                                            b.columns.lastEntry().getValue().width += rest;
                                            System.out.println("  +rest " + rest);
                                        }
                                    }

                                    public void collectContents(StringBuilder sb, 1TextBlocksColumnsMap columns) {
                                        sb.append("|");
                                        ColumnInfo currColumn = columns.columns.firstEntry().getValue();
                                        for (TextBlockInfo b : this.blocks) {
                                            int headColumnPos = b.columns.firstEntry().getValue().position;
                                            if (currColumn.position < headColumnPos) {
                                                int indent = columns.columns.subMap(0, true, headColumnPos, false).values().stream().mapToInt(c -> c.width).sum();
                                                sb.append(" ".repeat(indent));
                                                sb.append("|");
                                            }
                                            int width = b.columns.values().stream().mapToInt(c -> c.width).sum();
                                            static interface ITextBlock {
                                                public Interval getInterval();

                                                public String prepareText(int var1);
                                            }
                                            sb.append(b.block.prepareText(width));
                                            sb.append("|");
                                            currColumn = b.columns.lastEntry().getValue();
                                        }
                                    }
                                }
                            }

                            public String getContents() {
                                TextBlocksColumnsMap columnsMap = new TextBlocksColumnsMap();
                                for (TextBlocksLine l : this.lines) {
                                    l.collectColumns(columnsMap);
                                }
                                for (TextBlocksLine l : this.lines) {
                                    l.adjustComlumns();
                                }
                                StringBuilder sb = new StringBuilder();
                                for (TextBlocksLine l : this.lines) {
                                    l.collectContents(sb, columnsMap);
                                    sb.append(System.lineSeparator());
                                }
                                return sb.toString();
                            }

                            public TextBlocksLine appendLine() {
                                TextBlocksLine line = new TextBlocksLine();
                                this.lines.add(line);
                                return line;
                            }
                        }
                        return this.collectTextInternal(text, text.appendLine());
                    }

                    private int collectTextInternal(TextBlocks text, 1TextBlocksLine line) {
                        int width = this.prepareText(0).length();
                        for (List<Range> rr : this.subranges) {
                            TextBlocksLine l = text.appendLine();
                            int lineWidth = rr.size() - 1;
                            for (Range r : rr) {
                                lineWidth += r.collectTextInternal(text, l);
                            }
                            width = Math.max(lineWidth, width);
                        }
                        static interface ITextBlock {
                            public Interval getInterval();

                            public String prepareText(int var1);
                        }
                        line.add(this, width);
                        return width;
                    }
                }
                if (node.getGivenDataContext() != null) {
                    List<Range> layer;
                    Range range = new Range(node.getClass().getSimpleName() + ": " + node.getGivenDataContext().getClass().getSimpleName(), node.getInterval());
                    if (node.lexicalScopes != null && node.lexicalScopes.size() > 0) {
                        layer = range.createSubrangesLayer();
                        for (SQLQueryLexicalScope s : node.lexicalScopes) {
                            Object object;
                            SQLQuerySymbolOrigin origin = s.getSymbolsOrigin();
                            if (origin == null) continue;
                            String originName = origin.getClass().getSimpleName();
                            if (origin instanceof SQLQuerySymbolOrigin.DataContextSymbolOrigin) {
                                SQLQuerySymbolOrigin.DataContextSymbolOrigin o = (SQLQuerySymbolOrigin.DataContextSymbolOrigin)origin;
                                object = "(" + o.getDataContext().getClass().getSimpleName() + ")";
                            } else {
                                object = "";
                            }
                            String contextName = object;
                            layer.add(new Range("lexical: " + originName + contextName, s.getInterval()));
                        }
                    }
                    if (node.subnodes != null && node.subnodes.size() > 0) {
                        layer = range.createSubrangesLayer();
                        for (SQLQueryNodeModel n : node.subnodes) {
                            layer.add(this.collectModel(n));
                        }
                    }
                    return range;
                }
                return null;
            }
        };
        Range root = local.collectModel(this);
        TextBlocks text = new TextBlocks();
        if (root != null) {
            root.collectText(text);
        }
        return text.getContents();
    }

    protected static <N extends SQLQueryNodeModel, C> void traverseSubtreeSmart(@NotNull N subroot, @NotNull Class<N> childrenType, @Nullable C context, @NotNull BiConsumer<N, C> action, @NotNull BooleanSupplier cancellationChecker) {
        HashSet<SQLQueryNodeModel> queued = new HashSet<SQLQueryNodeModel>();
        queued.add(subroot);
        ListNode queue = ListNode.of((Object)Pair.of(null, subroot));
        while (queue != null && !cancellationChecker.getAsBoolean()) {
            ListNode stack = ListNode.of((Object)((Pair)queue.data));
            queue = queue.next;
            while (stack != null) {
                if (stack.data != null) {
                    SQLQueryNodeModel node = (SQLQueryNodeModel)((Pair)stack.data).getSecond();
                    List<SQLQueryNodeModel> subnodes = node.subnodes;
                    if (subnodes != null) {
                        List<SQLQueryNodeModel> children;
                        boolean delayChildren;
                        stack = ListNode.push((ListNode)stack, null);
                        if (node instanceof NodeSubtreeTraverseControl) {
                            NodeSubtreeTraverseControl c = (NodeSubtreeTraverseControl)((Object)node);
                            delayChildren = c.delayRestChildren();
                            children = c.getChildren();
                            if (children == null) {
                                children = subnodes;
                            }
                        } else {
                            delayChildren = false;
                            children = subnodes;
                        }
                        if (!delayChildren) {
                            children = new ArrayList<SQLQueryNodeModel>(children);
                            Collections.reverse(children);
                        }
                        int index = 0;
                        for (SQLQueryNodeModel childNode : children) {
                            if (childrenType.isInstance(childNode)) {
                                SQLQueryNodeModel child = childNode;
                                if (delayChildren) {
                                    if (index == 0) {
                                        stack = ListNode.push((ListNode)stack, (Object)Pair.of((Object)node, (Object)child));
                                    } else if (queued.add(child)) {
                                        queue = ListNode.push((ListNode)queue, (Object)Pair.of((Object)node, (Object)child));
                                    }
                                } else {
                                    stack = ListNode.push((ListNode)stack, (Object)Pair.of((Object)node, (Object)child));
                                }
                            }
                            ++index;
                        }
                        continue;
                    }
                    SQLQueryNodeModel.applyActionForNode((SQLQueryNodeModel)((Pair)stack.data).getFirst(), (SQLQueryNodeModel)((Pair)stack.data).getSecond(), context, action);
                    stack = stack.next;
                    continue;
                }
                stack = stack.next;
                SQLQueryNodeModel.applyActionForNode((SQLQueryNodeModel)((Pair)stack.data).getFirst(), (SQLQueryNodeModel)((Pair)stack.data).getSecond(), context, action);
                stack = stack.next;
            }
        }
    }

    private static <N extends SQLQueryNodeModel, C> void applyActionForNode(@Nullable N parent, @NotNull N node, @Nullable C context, @NotNull BiConsumer<N, C> action) {
        C c;
        if (parent instanceof NodeSubtreeTraverseControl) {
            NodeSubtreeTraverseControl tc = (NodeSubtreeTraverseControl)((Object)parent);
            c = ((NodeSubtreeTraverseControl)((Object)parent)).getContextForChild(node, context);
        } else {
            c = context;
        }
        C currContext = c;
        action.accept(node, currContext);
    }

    protected static <N extends SQLQueryNodeModel, C> void traverseSubtreeSimple(@NotNull N subroot, @NotNull Class<N> childrenType, @NotNull Consumer<N> action, @NotNull BooleanSupplier cancellationChecker) {
        ListNode stack = ListNode.of(subroot);
        while (stack != null && !cancellationChecker.getAsBoolean()) {
            if (stack.data != null) {
                SQLQueryNodeModel node = (SQLQueryNodeModel)stack.data;
                if (node.subnodes != null) {
                    stack = ListNode.push((ListNode)stack, null);
                    for (SQLQueryNodeModel child : node.subnodes) {
                        if (!childrenType.isInstance(child)) continue;
                        stack = ListNode.push((ListNode)stack, (Object)child);
                    }
                    continue;
                }
                action.accept((SQLQueryNodeModel)stack.data);
                stack = stack.next;
                continue;
            }
            stack = stack.next;
            action.accept((SQLQueryNodeModel)stack.data);
            stack = stack.next;
        }
    }

    public static interface NodeSubtreeTraverseControl<N extends SQLQueryNodeModel, C> {
        default public boolean delayRestChildren() {
            return false;
        }

        @Nullable
        default public List<SQLQueryNodeModel> getChildren() {
            return null;
        }

        @Nullable
        default public C getContextForChild(@NotNull N child, @Nullable C defaultContext) {
            return defaultContext;
        }
    }
}

