/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.semantics.context;

import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryDataContext;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryResultColumn;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryResultPseudoColumn;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQuerySyntaxContext;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;

public class SQLQueryResultTupleContext
extends SQLQuerySyntaxContext {
    private static final Log log = Log.getLog(SQLQueryResultTupleContext.class);
    @NotNull
    private final List<SQLQueryResultColumn> columns;
    @NotNull
    private final Set<DBSEntity> realSources;
    @NotNull
    private final List<SQLQueryResultPseudoColumn> pseudoColumns;

    public SQLQueryResultTupleContext(@NotNull SQLQueryDataContext parent, @NotNull List<SQLQueryResultColumn> columns, @NotNull List<SQLQueryResultPseudoColumn> pseudoColumns) {
        super(parent);
        this.columns = columns;
        this.realSources = columns.stream().map(c -> c.realSource).filter(Objects::nonNull).collect(Collectors.toSet());
        this.pseudoColumns = pseudoColumns;
    }

    @Override
    @NotNull
    public List<SQLQueryResultColumn> getColumnsList() {
        return this.columns;
    }

    @Override
    @NotNull
    public List<SQLQueryResultPseudoColumn> getPseudoColumnsList() {
        return this.pseudoColumns;
    }

    @Override
    @Nullable
    public SQLQueryResultColumn resolveColumn(@NotNull DBRProgressMonitor monitor, @NotNull String columnName) {
        SQLQueryResultColumn result = this.columns.stream().filter(c -> c.symbol.getName().equals(columnName)).findFirst().orElse(null);
        if (result != null) {
            return result;
        }
        String unquoted = this.getDialect().getUnquotedIdentifier(columnName);
        for (DBSEntity source : this.realSources) {
            try {
                DBSEntityAttribute attr = source.getAttribute(monitor, unquoted);
                if (attr != null) {
                    result = this.columns.stream().filter(c -> c.realAttr == attr).findFirst().orElse(null);
                }
            }
            catch (DBException e) {
                log.debug((Object)"Failed to resolve column", (Throwable)e);
                result = null;
            }
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Override
    @Nullable
    public SQLQueryResultPseudoColumn resolvePseudoColumn(@NotNull DBRProgressMonitor monitor, @NotNull String name) {
        SQLQueryResultPseudoColumn result = this.pseudoColumns.stream().filter(c -> c.symbol.getName().equals(name)).findFirst().orElse(null);
        return result;
    }
}

