/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.semantics.completion;

import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBPObjectWithDescription;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbolClass;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbolDefinition;
import org.jkiss.dbeaver.model.sql.semantics.completion.SQLQueryCompletionExtraTextProvider;
import org.jkiss.dbeaver.model.sql.semantics.completion.SQLQueryCompletionItem;
import org.jkiss.dbeaver.model.sql.semantics.completion.SQLQueryCompletionItemVisitor;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryResultPseudoColumn;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.rdb.DBSProcedure;
import org.jkiss.utils.CommonUtils;

public class SQLQueryCompletionDescriptionProvider
implements SQLQueryCompletionItemVisitor<String> {
    public static final SQLQueryCompletionDescriptionProvider INSTANCE = new SQLQueryCompletionDescriptionProvider();

    private SQLQueryCompletionDescriptionProvider() {
    }

    @Override
    @NotNull
    public String visitSubqueryAlias(@NotNull SQLQueryCompletionItem.SQLRowsSourceAliasCompletionItem rowsSourceAlias) {
        String prefix = rowsSourceAlias.sourceInfo.tableOrNull != null ? "Table alias for \n" : "Subquery alias for \n";
        return prefix + rowsSourceAlias.sourceInfo.source.getSyntaxNode().getTextContent();
    }

    @Override
    @NotNull
    public String visitCompositeField(@NotNull SQLQueryCompletionItem.SQLCompositeFieldCompletionItem compositeField) {
        String ownerTypeName = SQLQueryCompletionExtraTextProvider.prepareTypeNameString(compositeField.memberInfo.declaratorType());
        return "Attribute " + compositeField.memberInfo.name() + " of the " + ownerTypeName + " composite type ";
    }

    @Override
    @Nullable
    public String visitColumnName(@NotNull SQLQueryCompletionItem.SQLColumnNameCompletionItem columnName) {
        String originalColumnName;
        String string = originalColumnName = columnName.columnInfo.realAttr == null ? null : DBUtils.getObjectFullName((DBPNamedObject)columnName.columnInfo.realAttr, (DBPEvaluationContext)DBPEvaluationContext.DML);
        if (columnName.columnInfo.symbol.getSymbolClass() == SQLQuerySymbolClass.COLUMN_DERIVED) {
            return "Derived column #" + columnName.columnInfo.index + " " + (String)(originalColumnName != null ? "for real column " + originalColumnName : "") + " from the subquery \n" + columnName.columnInfo.source.getSyntaxNode().getTextContent();
        }
        if (columnName.columnInfo.realAttr != null) {
            String attrDescription = columnName.columnInfo.realAttr.getDescription();
            return CommonUtils.isNotEmpty((String)attrDescription) ? attrDescription : "Column " + columnName.columnInfo.realAttr.getName() + " of " + DBUtils.getObjectFullName((DBPNamedObject)columnName.columnInfo.realAttr.getParentObject(), (DBPEvaluationContext)DBPEvaluationContext.DML);
        }
        if (columnName.columnInfo.realSource != null) {
            return "Column " + columnName.columnInfo.symbol.getName() + " of " + DBUtils.getObjectFullName((DBPNamedObject)columnName.columnInfo.realSource, (DBPEvaluationContext)DBPEvaluationContext.DML);
        }
        SQLQuerySymbolDefinition sQLQuerySymbolDefinition = columnName.columnInfo.symbol.getDefinition();
        if (sQLQuerySymbolDefinition instanceof SQLQueryResultPseudoColumn) {
            SQLQueryResultPseudoColumn pseudoColumn = (SQLQueryResultPseudoColumn)sQLQuerySymbolDefinition;
            return pseudoColumn.description;
        }
        return "Computed column #" + columnName.columnInfo.index + " from the subquery \n" + columnName.columnInfo.source.getSyntaxNode().getTextContent();
    }

    @Override
    @Nullable
    public String visitTableName(@NotNull SQLQueryCompletionItem.SQLTableNameCompletionItem tableName) {
        return ((DBSEntity)tableName.object).getDescription();
    }

    @Override
    @Nullable
    public String visitReservedWord(@Nullable SQLQueryCompletionItem.SQLReservedWordCompletionItem reservedWord) {
        return "Reserved word of the query language";
    }

    @Override
    @Nullable
    public String visitNamedObject(@NotNull SQLQueryCompletionItem.SQLDbNamedObjectCompletionItem namedObject) {
        String string;
        if (namedObject instanceof DBPObjectWithDescription) {
            DBPObjectWithDescription owd = (DBPObjectWithDescription)namedObject;
            string = owd.getDescription();
        } else {
            string = DBUtils.getObjectFullName((DBPNamedObject)namedObject.object, (DBPEvaluationContext)DBPEvaluationContext.DML);
        }
        return string;
    }

    @Override
    @Nullable
    public String visitJoinCondition(@NotNull SQLQueryCompletionItem.SQLJoinConditionCompletionItem joinCondition) {
        return "Join condition on the foreign key known from the database schema: " + joinCondition.left.apply(this) + " vs " + joinCondition.right.apply(this);
    }

    @Override
    @Nullable
    public String visitProcedure(@NotNull SQLQueryCompletionItem.SQLProcedureCompletionItem procedure) {
        return ((DBSProcedure)procedure.getObject()).getDescription();
    }

    @Override
    @Nullable
    public String visitBuiltinFunction(@NotNull SQLQueryCompletionItem.SQLBuiltinFunctionCompletionItem function) {
        return "Builtin function of the database.";
    }

    @Override
    @Nullable
    public String visitSpecialText(@NotNull SQLQueryCompletionItem.SQLSpecialTextCompletionItem specialText) {
        return specialText.description;
    }
}

