/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls.resultset;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPQualifiedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDAttributeConstraint;
import org.jkiss.dbeaver.model.data.DBDAttributeConstraintBase;
import org.jkiss.dbeaver.model.data.DBDDataFilter;
import org.jkiss.dbeaver.model.exec.DBCLogicalOperator;
import org.jkiss.dbeaver.model.impl.struct.AbstractAttribute;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.xml.SAXListener;
import org.jkiss.utils.xml.SAXReader;
import org.jkiss.utils.xml.XMLBuilder;
import org.jkiss.utils.xml.XMLException;
import org.xml.sax.Attributes;

class DataFilterRegistry {
    private static final Log log = Log.getLog(DataFilterRegistry.class);
    private static final String CONFIG_FILE = "saved-data-filter.xml";
    private static final String OBJ_PATH_DELIMITER = "@@/@@";
    private static DataFilterRegistry instance;
    @NotNull
    private final Map<String, SavedDataFilter> savedFilters = new HashMap<String, SavedDataFilter>();
    @Nullable
    private volatile ConfigSaver saver = null;

    @NotNull
    public static synchronized DataFilterRegistry getInstance() {
        if (instance == null) {
            instance = new DataFilterRegistry();
        }
        return instance;
    }

    public DataFilterRegistry() {
        Path columnsConfig = DBWorkbench.getPlatform().getLocalConfigurationFile(CONFIG_FILE);
        if (Files.exists(columnsConfig, new LinkOption[0])) {
            this.loadConfiguration(columnsConfig);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public SavedDataFilter getSavedConfig(@NotNull DBSDataContainer object) {
        String objectId = DataFilterRegistry.makeObjectId((DBSObject)object);
        Map<String, SavedDataFilter> map = this.savedFilters;
        synchronized (map) {
            return this.savedFilters.get(objectId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void saveDataFilter(@NotNull DBSDataContainer object, @NotNull DBDDataFilter dataFilter) {
        String objectId = DataFilterRegistry.makeObjectId((DBSObject)object);
        Map<String, SavedDataFilter> map = this.savedFilters;
        synchronized (map) {
            if (dataFilter.isDirty()) {
                SavedDataFilter newStates = new SavedDataFilter(object.getDataSource(), dataFilter);
                this.savedFilters.put(objectId, newStates);
            } else {
                this.savedFilters.remove(objectId);
            }
            if (this.saver == null) {
                this.saver = new ConfigSaver();
                this.saver.schedule(3000L);
            }
        }
    }

    @NotNull
    public static String makeObjectId(@NotNull DBSObject object) {
        DBSObject[] path = DBUtils.getObjectPath((DBSObject)object, (boolean)true);
        StringBuilder objName = new StringBuilder();
        DBSObject[] dBSObjectArray = path;
        int n = path.length;
        int n2 = 0;
        while (n2 < n) {
            DBSObject p = dBSObjectArray[n2];
            if (objName.length() > 0) {
                objName.append(OBJ_PATH_DELIMITER);
            }
            objName.append(p.getName());
            ++n2;
        }
        return objName.toString();
    }

    private void loadConfiguration(@NotNull Path configFile) {
        this.savedFilters.clear();
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (InputStream in = Files.newInputStream(configFile, new OpenOption[0]);){
                SAXReader parser = new SAXReader(in);
                DataFilterParser dsp = new DataFilterParser();
                parser.parse((SAXListener)dsp);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            log.error((Object)"Error loading data filters config", (Throwable)e);
        }
    }

    private class ConfigSaver
    extends AbstractJob {
        ConfigSaver() {
            super("Data filters config save");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        protected IStatus run(@NotNull DBRProgressMonitor monitor) {
            Map<String, SavedDataFilter> map = DataFilterRegistry.this.savedFilters;
            synchronized (map) {
                this.flushConfig();
                DataFilterRegistry.this.saver = null;
            }
            return Status.OK_STATUS;
        }

        private Map<DBSAttributeBase, String> collectAttrsInfo(@NotNull XMLBuilder xml, @NotNull SavedDataFilter sdf) throws IOException {
            LinkedHashMap<DBSAttributeBase, String> attrsInfo = new LinkedHashMap<DBSAttributeBase, String>();
            for (DBDAttributeConstraintBase attrC : sdf.constraints.values()) {
                if (!(attrC instanceof DBDAttributeConstraint)) continue;
                this.flattenAttributes(attrsInfo, ((DBDAttributeConstraint)attrC).getAttribute());
            }
            if (attrsInfo.size() > 0) {
                Throwable throwable = null;
                Iterator<DBDAttributeConstraintBase> iterator = null;
                try (XMLBuilder.Element e = xml.startElement("flatten-attribute-bindings");){
                    for (Map.Entry entry : attrsInfo.entrySet()) {
                        Throwable throwable2 = null;
                        Object var10_13 = null;
                        try (XMLBuilder.Element ae = xml.startElement("attribute");){
                            DBSAttributeBase attribute = (DBSAttributeBase)entry.getKey();
                            xml.addAttribute("attrEntryId", (String)entry.getValue());
                            if (attribute instanceof DBDAttributeBinding) {
                                DBDAttributeBinding binding = (DBDAttributeBinding)attribute;
                                DBDAttributeBinding parent = binding.getParentObject();
                                if (parent != null) {
                                    xml.addAttribute("parentAttrEntryId", (String)attrsInfo.get(parent));
                                }
                                xml.addAttribute("isPseudoAttribute", binding.isPseudoAttribute());
                            }
                            xml.addAttribute("name", attribute.getName());
                            xml.addAttribute("typeName", attribute.getTypeName());
                            xml.addAttribute("typeId", attribute.getTypeID());
                            xml.addAttribute("dataKind", attribute.getDataKind().name());
                            xml.addAttribute("ordinalPosition", attribute.getOrdinalPosition());
                            xml.addAttribute("maxLength", attribute.getMaxLength());
                            if (attribute.getScale() != null) {
                                xml.addAttribute("scale", attribute.getScale().intValue());
                            }
                            if (attribute.getPrecision() != null) {
                                xml.addAttribute("precision", attribute.getPrecision().intValue());
                            }
                            xml.addAttribute("isRequired", attribute.isRequired());
                            xml.addAttribute("isAutoGenerated", attribute.isAutoGenerated());
                        }
                        catch (Throwable throwable3) {
                            if (throwable2 == null) {
                                throwable2 = throwable3;
                            } else if (throwable2 != throwable3) {
                                throwable2.addSuppressed(throwable3);
                            }
                            throw throwable2;
                        }
                    }
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                    } else if (throwable != throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    throw throwable;
                }
            }
            return attrsInfo;
        }

        private void flattenAttributes(@NotNull Map<DBSAttributeBase, String> attrs, @NotNull DBSAttributeBase attribute) {
            if (!attrs.containsKey(attribute)) {
                DBDAttributeBinding parent;
                if (attribute instanceof DBDAttributeBinding && (parent = ((DBDAttributeBinding)attribute).getParentObject()) != null) {
                    this.flattenAttributes(attrs, (DBSAttributeBase)parent);
                }
                attrs.put(attribute, "fa" + attrs.size());
            }
        }

        private void flushConfig() {
            Path configFile = DBWorkbench.getPlatform().getLocalConfigurationFile(DataFilterRegistry.CONFIG_FILE);
            try {
                Throwable throwable = null;
                Object var3_5 = null;
                try (OutputStream out = Files.newOutputStream(configFile, new OpenOption[0]);){
                    XMLBuilder xml = new XMLBuilder(out, GeneralUtils.UTF8_ENCODING);
                    xml.setButify(true);
                    Throwable throwable2 = null;
                    Object var7_11 = null;
                    try (XMLBuilder.Element e = xml.startElement("data-filters");){
                        for (Map.Entry<String, SavedDataFilter> entry : DataFilterRegistry.this.savedFilters.entrySet()) {
                            Throwable throwable3 = null;
                            Object var12_18 = null;
                            try (XMLBuilder.Element e2 = xml.startElement("filter");){
                                xml.addAttribute("objectId", entry.getKey());
                                SavedDataFilter sdf = entry.getValue();
                                xml.addAttribute("anyConstraint", sdf.anyConstraint);
                                if (!CommonUtils.isEmpty((String)sdf.order)) {
                                    xml.addAttribute("order", sdf.order);
                                }
                                if (!CommonUtils.isEmpty((String)sdf.where)) {
                                    xml.addAttribute("where", sdf.where);
                                }
                                Map<DBSAttributeBase, String> attrsInfo = this.collectAttrsInfo(xml, sdf);
                                for (Map.Entry<String, DBDAttributeConstraintBase> attrCE : sdf.constraints.entrySet()) {
                                    Throwable throwable4 = null;
                                    Object var19_27 = null;
                                    try (XMLBuilder.Element e3 = xml.startElement("constraint");){
                                        Object[] options;
                                        xml.addAttribute("name", attrCE.getKey());
                                        DBDAttributeConstraintBase attrC = attrCE.getValue();
                                        if (!attrC.isVisible()) {
                                            xml.addAttribute("visible", false);
                                        }
                                        xml.addAttribute("pos", attrC.getVisualPosition());
                                        if (attrC.getOrderPosition() > 0) {
                                            xml.addAttribute("order", attrC.getOrderPosition());
                                            xml.addAttribute("orderDesc", attrC.isOrderDescending());
                                        }
                                        if (!CommonUtils.isEmpty((String)attrC.getCriteria())) {
                                            xml.addAttribute("criteria", attrC.getCriteria());
                                        }
                                        if (attrC.getOperator() != null) {
                                            xml.addAttribute("operator", attrC.getOperator().name());
                                        }
                                        if (!CommonUtils.isEmpty((String)attrC.getEntityAlias())) {
                                            xml.addAttribute("entity", attrC.getEntityAlias());
                                        }
                                        if (attrC instanceof DBDAttributeConstraint) {
                                            xml.addAttribute("attrEntryId", attrsInfo.get(((DBDAttributeConstraint)attrC).getAttribute()));
                                        }
                                        if (attrC.getValue() != null) {
                                            xml.startElement("value");
                                            xml.addText((CharSequence)GeneralUtils.serializeObject((Object)attrC.getValue()));
                                            xml.endElement();
                                        }
                                        if (ArrayUtils.isEmpty((Object[])(options = attrC.getOptions()))) continue;
                                        int i = 0;
                                        while (i < options.length) {
                                            xml.startElement("option");
                                            xml.addAttribute("name", CommonUtils.toString((Object)options[i]));
                                            xml.addText((CharSequence)GeneralUtils.serializeObject((Object)options[i + 1]));
                                            xml.endElement();
                                            i += 2;
                                        }
                                    }
                                    catch (Throwable throwable5) {
                                        if (throwable4 == null) {
                                            throwable4 = throwable5;
                                        } else if (throwable4 != throwable5) {
                                            throwable4.addSuppressed(throwable5);
                                        }
                                        throw throwable4;
                                    }
                                }
                            }
                            catch (Throwable throwable6) {
                                if (throwable3 == null) {
                                    throwable3 = throwable6;
                                } else if (throwable3 != throwable6) {
                                    throwable3.addSuppressed(throwable6);
                                }
                                throw throwable3;
                            }
                        }
                    }
                    catch (Throwable throwable7) {
                        if (throwable2 == null) {
                            throwable2 = throwable7;
                        } else if (throwable2 != throwable7) {
                            throwable2.addSuppressed(throwable7);
                        }
                        throw throwable2;
                    }
                    xml.flush();
                }
                catch (Throwable throwable8) {
                    if (throwable == null) {
                        throwable = throwable8;
                    } else if (throwable != throwable8) {
                        throwable.addSuppressed(throwable8);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                log.error((Object)"Error saving columns configuration", (Throwable)e);
            }
        }
    }

    private class DataFilterParser
    extends SAXListener.BaseListener {
        @Nullable
        private SavedDataFilter curSavedDataFilter = null;
        @Nullable
        private Map<String, RestoredAttribute> attrsInfo = null;
        @Nullable
        private DBDAttributeConstraintBase curSavedConstraint = null;
        private boolean isInValue = false;
        @Nullable
        private String curOptionName = null;

        private DataFilterParser() {
        }

        public void saxStartElement(@NotNull SAXReader reader, @Nullable String namespaceURI, @NotNull String localName, @NotNull Attributes atts) throws XMLException {
            switch (localName) {
                case "flatten-attribute-bindings": {
                    this.attrsInfo = new LinkedHashMap<String, RestoredAttribute>();
                    break;
                }
                case "attribute": {
                    if (this.attrsInfo == null) break;
                    String attrEntryId = atts.getValue("attrEntryId");
                    String parentAttrEntryId = atts.getValue("parentAttrEntryId");
                    RestoredAttribute parent = CommonUtils.isEmpty((String)parentAttrEntryId) ? null : this.attrsInfo.get(parentAttrEntryId);
                    this.attrsInfo.put(attrEntryId, new RestoredAttribute(parent, atts));
                    break;
                }
                case "filter": {
                    this.curSavedDataFilter = new SavedDataFilter();
                    this.curSavedDataFilter.anyConstraint = CommonUtils.toBoolean((Object)atts.getValue("anyConstraint"));
                    this.curSavedDataFilter.where = atts.getValue("where");
                    this.curSavedDataFilter.order = atts.getValue("order");
                    String objectId = atts.getValue("objectId");
                    DataFilterRegistry.this.savedFilters.put(objectId, this.curSavedDataFilter);
                    this.attrsInfo = null;
                    break;
                }
                case "constraint": {
                    DBSAttributeBase attr;
                    if (this.curSavedDataFilter == null) break;
                    this.curSavedConstraint = null;
                    String attrEntryId = atts.getValue("attrEntryId");
                    if (CommonUtils.isNotEmpty((String)attrEntryId) && this.attrsInfo != null && (attr = (DBSAttributeBase)this.attrsInfo.get(attrEntryId)) != null) {
                        this.curSavedConstraint = new DBDAttributeConstraint(attr, attr.getOrdinalPosition());
                    }
                    if (this.curSavedConstraint == null) {
                        this.curSavedConstraint = new DBDAttributeConstraintBase();
                    }
                    String name = atts.getValue("name");
                    this.curSavedConstraint.setVisualPosition(CommonUtils.toInt((Object)atts.getValue("pos")));
                    if (atts.getValue("order") != null) {
                        this.curSavedConstraint.setOrderPosition(CommonUtils.toInt((Object)atts.getValue("order")));
                        this.curSavedConstraint.setOrderDescending(CommonUtils.toBoolean((Object)atts.getValue("orderDesc")));
                    }
                    this.curSavedConstraint.setCriteria(atts.getValue("criteria"));
                    this.curSavedConstraint.setVisible(CommonUtils.getBoolean((String)atts.getValue("visible"), (boolean)true));
                    String operName = atts.getValue("operator");
                    if (!CommonUtils.isEmpty((String)operName)) {
                        try {
                            this.curSavedConstraint.setOperator(DBCLogicalOperator.valueOf((String)operName));
                        }
                        catch (IllegalArgumentException e) {
                            log.error((Object)e);
                        }
                    }
                    this.curSavedConstraint.setEntityAlias(atts.getValue("entity"));
                    this.curSavedDataFilter.constraints.put(name, this.curSavedConstraint);
                    break;
                }
                case "value": {
                    if (this.curSavedConstraint == null) break;
                    this.isInValue = true;
                    break;
                }
                case "option": {
                    if (this.curSavedConstraint == null) break;
                    this.curOptionName = CommonUtils.toString((Object)atts.getValue("name"));
                }
            }
        }

        public void saxEndElement(@NotNull SAXReader reader, @Nullable String namespaceURI, @NotNull String localName) throws XMLException {
            switch (localName) {
                case "filter": {
                    this.curSavedDataFilter = null;
                    break;
                }
                case "constraint": {
                    this.curSavedConstraint = null;
                    break;
                }
                case "value": {
                    this.isInValue = false;
                    break;
                }
                case "option": {
                    this.curOptionName = null;
                }
            }
        }

        public void saxText(@Nullable SAXReader reader, @NotNull String data) throws XMLException {
            if (this.isInValue) {
                this.curSavedConstraint.setValue(GeneralUtils.deserializeObject((String)data));
            } else if (this.curOptionName != null) {
                this.curSavedConstraint.setOption(this.curOptionName, GeneralUtils.deserializeObject((String)data));
                this.curSavedConstraint.setOption(this.curOptionName, GeneralUtils.deserializeObject((String)data));
            }
        }
    }

    private static class RestoredAttribute
    extends AbstractAttribute
    implements DBSObject,
    DBSAttributeBase,
    DBPQualifiedObject {
        private final RestoredAttribute parent;
        private final DBPDataKind dataKind;
        private final DBPDataSource dataSource;
        private final boolean isPseudoAttribute;

        public RestoredAttribute(@Nullable RestoredAttribute parent, Attributes atts) {
            super(atts.getValue("name"), atts.getValue("typeName"), CommonUtils.toInt((Object)atts.getValue("typeId")), CommonUtils.toInt((Object)atts.getValue("ordinalPosition")), CommonUtils.toLong((Object)atts.getValue("maxLength")), Integer.valueOf(CommonUtils.toInt((Object)atts.getValue("scale"), (int)-1)), Integer.valueOf(CommonUtils.toInt((Object)atts.getValue("precision"), (int)-1)), CommonUtils.getBoolean((String)atts.getValue("isRequired"), (boolean)false), CommonUtils.getBoolean((String)atts.getValue("isAutoGenerated"), (boolean)false));
            this.parent = parent;
            this.dataKind = DBPDataKind.valueOf((String)atts.getValue("dataKind"));
            this.isPseudoAttribute = CommonUtils.getBoolean((String)atts.getValue("isPseudoAttribute"), (boolean)false);
            this.dataSource = null;
        }

        public RestoredAttribute(@Nullable RestoredAttribute boundParent, @NotNull RestoredAttribute original, @NotNull DBPDataSource dataSource) {
            super(original.getName(), original.getTypeName(), original.getTypeID(), original.getOrdinalPosition(), original.getMaxLength(), original.getScale(), original.getPrecision(), original.isRequired(), original.isAutoGenerated());
            this.parent = boundParent;
            this.dataKind = original.getDataKind();
            this.isPseudoAttribute = original.isPseudoAttribute();
            this.dataSource = dataSource;
        }

        @NotNull
        public DBPDataKind getDataKind() {
            return this.dataKind;
        }

        public boolean isPseudoAttribute() {
            return this.isPseudoAttribute;
        }

        public RestoredAttribute getParentObject() {
            return this.parent;
        }

        public DBPDataSource getDataSource() {
            return this.dataSource;
        }

        @NotNull
        public String getFullyQualifiedName(@Nullable DBPEvaluationContext context) {
            DBPDataSource dataSource = this.getDataSource();
            if (this.getParentObject() == null) {
                return DBUtils.getQuotedIdentifier((DBPDataSource)dataSource, (String)this.getName());
            }
            char structSeparator = dataSource.getSQLDialect().getStructSeparator();
            StringBuilder query = new StringBuilder();
            boolean hasPrevIdentifier = false;
            RestoredAttribute attribute = this;
            while (attribute != null) {
                if (!(attribute.isPseudoAttribute() || attribute.getParentObject() == null && attribute.getDataKind() == DBPDataKind.DOCUMENT)) {
                    if (hasPrevIdentifier) {
                        query.insert(0, structSeparator);
                    }
                    query.insert(0, DBUtils.getQuotedIdentifier((DBPDataSource)dataSource, (String)attribute.getName()));
                    hasPrevIdentifier = true;
                }
                attribute = attribute.getParentObject();
            }
            return query.toString();
        }
    }

    private static class RestoredAttributesInfo {
        final Map<RestoredAttribute, RestoredAttribute> boundAttrs;

        private RestoredAttributesInfo(@NotNull Map<RestoredAttribute, RestoredAttribute> boundAttrs) {
            this.boundAttrs = boundAttrs;
        }

        @NotNull
        public static RestoredAttributesInfo bindToDataSource(@NotNull SavedDataFilter savedFilter, @Nullable DBPDataSource dataSource) {
            return new RestoredAttributesInfo(dataSource == null ? Collections.emptyMap() : RestoredAttributesInfo.bindToDataSourceImpl(savedFilter, dataSource));
        }

        @NotNull
        private static Map<RestoredAttribute, RestoredAttribute> bindToDataSourceImpl(@NotNull SavedDataFilter savedFilter, @NotNull DBPDataSource dataSource) {
            HashMap<RestoredAttribute, RestoredAttribute> boundAttrs = new HashMap<RestoredAttribute, RestoredAttribute>();
            ArrayList<RestoredAttribute> restoredAttributes = new ArrayList<RestoredAttribute>();
            for (DBDAttributeConstraintBase savedConstraint : savedFilter.constraints.values()) {
                DBSAttributeBase savedAttr;
                if (!(savedConstraint instanceof DBDAttributeConstraint) || !((savedAttr = ((DBDAttributeConstraint)savedConstraint).getAttribute()) instanceof RestoredAttribute)) continue;
                RestoredAttribute attr = (RestoredAttribute)savedAttr;
                while (attr != null && !boundAttrs.containsKey((Object)attr)) {
                    restoredAttributes.add(attr);
                    attr = attr.getParentObject();
                }
                while (!restoredAttributes.isEmpty()) {
                    attr = (RestoredAttribute)((Object)restoredAttributes.remove(restoredAttributes.size() - 1));
                    RestoredAttribute boundParent = attr.getParentObject() == null ? null : (RestoredAttribute)((Object)boundAttrs.get((Object)attr.getParentObject()));
                    boundAttrs.put(attr, new RestoredAttribute(boundParent, attr, dataSource));
                }
            }
            return boundAttrs;
        }

        @NotNull
        public DBDAttributeConstraint restoreOffschemaConstraint(@NotNull String unquottedAttrName, @NotNull DBDAttributeConstraintBase savedConstraint) {
            DBDAttributeConstraint constraint;
            if (savedConstraint instanceof DBDAttributeConstraint) {
                DBDAttributeConstraint savedAttrConstraint = (DBDAttributeConstraint)savedConstraint;
                if (savedAttrConstraint.getAttribute() instanceof RestoredAttribute) {
                    RestoredAttribute boundAttr = this.boundAttrs.get(savedAttrConstraint.getAttribute());
                    if (boundAttr != null) {
                        constraint = new DBDAttributeConstraint((DBSAttributeBase)boundAttr, savedConstraint.getVisualPosition());
                        constraint.copyFrom(savedConstraint);
                    } else {
                        constraint = savedAttrConstraint;
                    }
                } else {
                    constraint = savedAttrConstraint;
                }
            } else {
                final DBPDataKind dataKind = RestoredAttributesInfo.getAttributeValueKind(savedConstraint.getValue());
                AbstractAttribute attribute = new AbstractAttribute(unquottedAttrName, dataKind.name(), 0, savedConstraint.getVisualPosition(), 0L, 0, 0, false, false){

                    @NotNull
                    public DBPDataKind getDataKind() {
                        return dataKind;
                    }
                };
                constraint = new DBDAttributeConstraint((DBSAttributeBase)attribute, savedConstraint.getVisualPosition());
                constraint.copyFrom(savedConstraint);
            }
            return constraint;
        }

        @NotNull
        private static DBPDataKind getAttributeValueKind(@NotNull Object value) {
            if (value instanceof String) {
                return DBPDataKind.STRING;
            }
            if (value instanceof Number) {
                return DBPDataKind.NUMERIC;
            }
            if (value instanceof Boolean) {
                return DBPDataKind.BOOLEAN;
            }
            if (value instanceof Date) {
                return DBPDataKind.DATETIME;
            }
            if (value instanceof JsonObject) {
                return DBPDataKind.STRUCT;
            }
            if (value instanceof JsonArray) {
                return DBPDataKind.ARRAY;
            }
            if (value != null && value.getClass().isArray() && Array.getLength(value) > 0) {
                return RestoredAttributesInfo.getAttributeValueKind(Array.get(value, 0));
            }
            return DBPDataKind.OBJECT;
        }
    }

    static class SavedDataFilter {
        private Map<String, DBDAttributeConstraintBase> constraints = new LinkedHashMap<String, DBDAttributeConstraintBase>();
        private boolean anyConstraint;
        private String order;
        private String where;

        SavedDataFilter() {
        }

        SavedDataFilter(@NotNull DBPDataSource dataSource, @NotNull DBDDataFilter dataFilter) {
            for (DBDAttributeConstraint c : dataFilter.getConstraints()) {
                if (c.getAttribute() == null) continue;
                this.constraints.put(DBUtils.getQuotedIdentifier((DBPDataSource)dataSource, (String)c.getAttribute().getName()), (DBDAttributeConstraintBase)new DBDAttributeConstraint(c));
            }
            this.anyConstraint = dataFilter.isAnyConstraint();
            this.order = dataFilter.getOrder();
            this.where = dataFilter.getWhere();
        }

        void restoreDataFilter(@NotNull DBRProgressMonitor monitor, @NotNull DBSDataContainer dataContainer, @NotNull DBDDataFilter dataFilter) throws DBException {
            dataFilter.setAnyConstraint(this.anyConstraint);
            dataFilter.setOrder(this.order);
            dataFilter.setWhere(this.where);
            ArrayList<DBDAttributeConstraint> offschemaConstraints = null;
            RestoredAttributesInfo restoredAttrsInfo = RestoredAttributesInfo.bindToDataSource(this, dataContainer.getDataSource());
            for (Map.Entry<String, DBDAttributeConstraintBase> savedC : this.constraints.entrySet()) {
                DBDAttributeConstraint attrC;
                String attrName = savedC.getKey();
                DBDAttributeConstraintBase savedConstraint = savedC.getValue();
                if (dataContainer.getDataSource() != null) {
                    attrName = DBUtils.getUnQuotedIdentifier((DBPDataSource)dataContainer.getDataSource(), (String)attrName);
                }
                if ((attrC = dataFilter.getConstraint(attrName)) == null && dataContainer instanceof DBSEntity) {
                    DBSEntityAttribute attribute = ((DBSEntity)dataContainer).getAttribute(monitor, attrName);
                    if (attribute != null) {
                        attrC = new DBDAttributeConstraint((DBSAttributeBase)attribute, attribute.getOrdinalPosition());
                    } else if (savedConstraint != null) {
                        attrC = restoredAttrsInfo.restoreOffschemaConstraint(attrName, savedConstraint);
                    }
                    if (attrC != null) {
                        dataFilter.addConstraints(Collections.singletonList(attrC));
                    }
                }
                if (attrC != null) {
                    attrC.copyFrom(savedConstraint);
                    continue;
                }
                if (savedConstraint == null) continue;
                if (offschemaConstraints == null) {
                    offschemaConstraints = new ArrayList<DBDAttributeConstraint>();
                }
                offschemaConstraints.add(restoredAttrsInfo.restoreOffschemaConstraint(attrName, savedConstraint));
            }
            if (offschemaConstraints != null && dataContainer.getDataSource() != null) {
                StringBuilder sb = new StringBuilder();
                SQLUtils.appendConditionString((DBDDataFilter)dataFilter, offschemaConstraints, (DBPDataSource)dataContainer.getDataSource(), null, (StringBuilder)sb, (boolean)true, (boolean)false);
                dataFilter.setWhere(sb.toString());
            }
        }
    }
}

