/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.altibase.model;

import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.altibase.model.AltibaseDataSource;
import org.jkiss.dbeaver.ext.altibase.model.AltibaseGlobalObject;
import org.jkiss.dbeaver.ext.generic.model.GenericStructContainer;
import org.jkiss.dbeaver.model.DBPRefreshableObject;
import org.jkiss.dbeaver.model.DBPScriptObject;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.utils.CommonUtils;

public class AltibaseJob
extends AltibaseGlobalObject
implements DBPScriptObject,
DBPRefreshableObject {
    private String ddl;
    private int jobId;
    private String jobName;
    private String execQuery;
    private Timestamp startTime;
    private Timestamp endTime;
    private int interval;
    private String intervalType;
    private boolean activated;
    private Timestamp lastExecTime;
    private int execCount;
    private String errorCode;
    private boolean isEnable;
    private String comment;

    public AltibaseJob(GenericStructContainer owner, @NotNull ResultSet resultSet) {
        super((AltibaseDataSource)owner.getDataSource(), true);
        this.jobId = JDBCUtils.safeGetInt((ResultSet)resultSet, (String)"JOB_ID");
        this.jobName = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"JOB_NAME");
        this.execQuery = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"EXEC_QUERY");
        this.startTime = JDBCUtils.safeGetTimestamp((ResultSet)resultSet, (String)"START_TIME");
        this.endTime = JDBCUtils.safeGetTimestamp((ResultSet)resultSet, (String)"END_TIME");
        this.interval = JDBCUtils.safeGetInt((ResultSet)resultSet, (String)"INTERVAL");
        this.intervalType = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"INTERVAL_TYPE");
        this.activated = JDBCUtils.safeGetBoolean((ResultSet)resultSet, (String)"STATE", (String)"1");
        this.lastExecTime = JDBCUtils.safeGetTimestamp((ResultSet)resultSet, (String)"LAST_EXEC_TIME");
        this.execCount = JDBCUtils.safeGetInt((ResultSet)resultSet, (String)"EXEC_COUNT");
        this.errorCode = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"ERROR_CODE");
        this.isEnable = JDBCUtils.safeGetBoolean((ResultSet)resultSet, (String)"IS_ENABLE", (String)"T");
        this.comment = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"COMMENT");
    }

    @Property(viewable=true, order=1)
    @NotNull
    public String getName() {
        return this.jobName;
    }

    @Property(viewable=true, order=2)
    public int getJobId() {
        return this.jobId;
    }

    @Property(viewable=true, order=3)
    @NotNull
    public String getExecQuery() {
        return this.execQuery;
    }

    @Property(viewable=true, order=4)
    @NotNull
    public String getinterval() {
        return this.interval + " " + this.intervalType;
    }

    @Property(viewable=true, order=5)
    public boolean getActivated() {
        return this.activated;
    }

    @Property(viewable=true, order=6)
    @NotNull
    public Timestamp getLastExecTime() {
        return this.lastExecTime;
    }

    @Property(viewable=true, order=7)
    @NotNull
    public String getErrorCode() {
        return this.errorCode;
    }

    @Property(viewable=true, order=8)
    public int getExecCount() {
        return this.execCount;
    }

    @Property(viewable=true, order=8)
    public boolean getIsEnable() {
        return this.isEnable;
    }

    @Property(viewable=true, order=10)
    @NotNull
    public Timestamp getStartTime() {
        return this.startTime;
    }

    @Property(viewable=true, order=11)
    @NotNull
    public Timestamp getEndTime() {
        return this.endTime;
    }

    @Property(viewable=true, order=12)
    @NotNull
    public String getComment() {
        return this.comment;
    }

    public String getObjectDefinitionText(DBRProgressMonitor monitor, Map<String, Object> options) throws DBException {
        if (CommonUtils.isEmpty((String)this.ddl)) {
            this.ddl = this.getDataSource().getMetaModel().getJobDDL(monitor, this, options) + ";";
        }
        return this.ddl;
    }

    public DBSObject refreshObject(DBRProgressMonitor monitor) throws DBException {
        AltibaseDataSource dataSouce = this.getDataSource();
        return dataSouce.getJobCache().refreshObject(monitor, (DBSObject)dataSouce, this);
    }
}

