/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.jdbc.driver.libsql;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class LibSqlUtils {
    public static String quote(String identifier) {
        return "'" + identifier + "'";
    }

    public static String unquote(String name) {
        if (name == null) {
            return name;
        }
        if ((name = name.trim()).length() > 2 && (name.startsWith("`") && name.endsWith("`") || name.startsWith("\"") && name.endsWith("\"") || name.startsWith("[") && name.endsWith("]"))) {
            name = name.substring(1, name.length() - 1);
        }
        return name;
    }

    public static String escape(String val) {
        if (val.indexOf(39) == 1) {
            return val;
        }
        int len = val.length();
        StringBuilder buf = new StringBuilder(len);
        int i = 0;
        while (i < len) {
            if (val.charAt(i) == '\'') {
                buf.append('\'');
            }
            buf.append(val.charAt(i));
            ++i;
        }
        return buf.toString();
    }

    public static ResultSet executeQuery(Connection connection, String query) throws SQLException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (Statement stat = connection.createStatement();){
            return stat.executeQuery(query);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

