/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.cubrid.ui.views;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.jkiss.dbeaver.ext.cubrid.ui.internal.CubridMessages;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.preferences.PreferenceStoreDelegate;
import org.jkiss.dbeaver.ui.preferences.TargetPrefPage;
import org.jkiss.dbeaver.utils.PrefUtils;

public class PrefPageCubrid
extends TargetPrefPage {
    public static final String PAGE_ID = "org.jkiss.dbeaver.preferences.cubrid.general";
    private Button trace;
    private Button info;
    private Button allInfo;

    public PrefPageCubrid() {
        this.setPreferenceStore((IPreferenceStore)new PreferenceStoreDelegate(DBWorkbench.getPlatform().getPreferenceStore()));
    }

    protected boolean hasDataSourceSpecificOptions(DBPDataSourceContainer dsContainer) {
        return false;
    }

    protected boolean supportsDataSourceSpecificOptions() {
        return true;
    }

    protected void loadPreferences(DBPPreferenceStore store) {
        this.trace.setSelection(store.getBoolean("statistic_trace"));
        this.info.setSelection(store.getString("statistic").equals("statistic_info"));
        this.allInfo.setSelection(store.getString("statistic").equals("statistic_all_info"));
    }

    protected void savePreferences(DBPPreferenceStore store) {
        PrefUtils.savePreferenceStore((DBPPreferenceStore)store);
    }

    protected void performDefaults() {
        super.performDefaults();
        this.clearPreferences(this.getTargetPreferenceStore());
    }

    protected void clearPreferences(DBPPreferenceStore store) {
        store.setValue("statistic_trace", false);
        store.setValue("statistic", "");
        this.trace.setSelection(false);
        this.info.setSelection(false);
        this.allInfo.setSelection(false);
    }

    protected String getPropertyPageID() {
        return PAGE_ID;
    }

    protected Control createPreferenceContent(Composite parent) {
        final DBPPreferenceStore preferenceStore = DBWorkbench.getPlatform().getPreferenceStore();
        Composite composite = UIUtils.createPlaceholder((Composite)parent, (int)1);
        GridLayout gl = new GridLayout(1, false);
        gl.marginHeight = 10;
        gl.marginWidth = 10;
        composite.setLayout((Layout)gl);
        composite.setLayoutData((Object)new GridData(1808));
        Group planGroup = UIUtils.createControlGroup((Composite)composite, (String)CubridMessages.statistic_group_editor_title, (int)1, (int)768, (int)0);
        this.trace = UIUtils.createCheckbox((Composite)planGroup, (String)CubridMessages.statistic_trace_info, (boolean)false);
        this.trace.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                preferenceStore.setValue("statistic_trace", ((Button)e.widget).getSelection());
            }
        });
        SelectionAdapter radioListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (e.widget.getData().equals(preferenceStore.getString("statistic"))) {
                    ((Button)e.widget).setSelection(false);
                    preferenceStore.setValue("statistic", "");
                } else {
                    preferenceStore.setValue("statistic", e.widget.getData().toString());
                }
            }
        };
        this.info = UIUtils.createRadioButton((Composite)planGroup, (String)CubridMessages.statistic_info, (Object)"statistic_info", (SelectionListener)radioListener);
        this.allInfo = UIUtils.createRadioButton((Composite)planGroup, (String)CubridMessages.statistic_all_info, (Object)"statistic_all_info", (SelectionListener)radioListener);
        return composite;
    }
}

