// Copyright (c) Microsoft Corporation.
// Licensed under the MIT License.
/**
 * Name of the Agent Policy
 */
export const agentPolicyName = "agentPolicy";
/**
 * Gets a pipeline policy that sets http.agent
 */
export function agentPolicy(agent) {
    return {
        name: agentPolicyName,
        sendRequest: async (req, next) => {
            // Users may define an agent on the request, honor it over the client level one
            if (!req.agent) {
                req.agent = agent;
            }
            return next(req);
        },
    };
}//# sourceMappingURL=https://main.vscode-cdn.net/sourcemaps/2901c5ac6db8a986a5666c3af51ff804d05af0d4/node_modules/@typespec/ts-http-runtime/dist/esm/policies/agentPolicy.js.map