/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.brotli;

import java.io.IOException;
import java.io.InputStream;
import net.sourceforge.plantuml.brotli.BitReader;
import net.sourceforge.plantuml.brotli.BrotliRuntimeException;
import net.sourceforge.plantuml.brotli.Context;
import net.sourceforge.plantuml.brotli.Dictionary;
import net.sourceforge.plantuml.brotli.Huffman;
import net.sourceforge.plantuml.brotli.State;
import net.sourceforge.plantuml.brotli.Transform;
import net.sourceforge.plantuml.brotli.Utils;

final class Decode {
    private static final int UNINITIALIZED = 0;
    private static final int BLOCK_START = 1;
    private static final int COMPRESSED_BLOCK_START = 2;
    private static final int MAIN_LOOP = 3;
    private static final int READ_METADATA = 4;
    private static final int COPY_UNCOMPRESSED = 5;
    private static final int INSERT_LOOP = 6;
    private static final int COPY_LOOP = 7;
    private static final int COPY_WRAP_BUFFER = 8;
    private static final int TRANSFORM = 9;
    private static final int FINISHED = 10;
    private static final int CLOSED = 11;
    private static final int WRITE = 12;
    private static final int DEFAULT_CODE_LENGTH = 8;
    private static final int CODE_LENGTH_REPEAT_CODE = 16;
    private static final int NUM_LITERAL_CODES = 256;
    private static final int NUM_INSERT_AND_COPY_CODES = 704;
    private static final int NUM_BLOCK_LENGTH_CODES = 26;
    private static final int LITERAL_CONTEXT_BITS = 6;
    private static final int DISTANCE_CONTEXT_BITS = 2;
    private static final int HUFFMAN_TABLE_BITS = 8;
    private static final int HUFFMAN_TABLE_MASK = 255;
    static final int HUFFMAN_TABLE_SIZE = 1080;
    private static final int CODE_LENGTH_CODES = 18;
    private static final int[] CODE_LENGTH_CODE_ORDER = new int[]{1, 2, 3, 4, 0, 5, 17, 6, 16, 7, 8, 9, 10, 11, 12, 13, 14, 15};
    private static final int NUM_DISTANCE_SHORT_CODES = 16;
    private static final int[] DISTANCE_SHORT_CODE_INDEX_OFFSET = new int[]{3, 2, 1, 0, 3, 3, 3, 3, 3, 3, 2, 2, 2, 2, 2, 2};
    private static final int[] DISTANCE_SHORT_CODE_VALUE_OFFSET = new int[]{0, 0, 0, 0, -1, 1, -2, 2, -3, 3, -1, 1, -2, 2, -3, 3};
    private static final int[] FIXED_TABLE = new int[]{131072, 131076, 131075, 196610, 131072, 131076, 131075, 262145, 131072, 131076, 131075, 196610, 131072, 131076, 131075, 262149};
    static final int[] DICTIONARY_OFFSETS_BY_LENGTH = new int[]{0, 0, 0, 0, 0, 4096, 9216, 21504, 35840, 44032, 53248, 63488, 74752, 87040, 93696, 100864, 104704, 106752, 108928, 113536, 115968, 118528, 119872, 121280, 122016};
    static final int[] DICTIONARY_SIZE_BITS_BY_LENGTH = new int[]{0, 0, 0, 0, 10, 10, 11, 11, 10, 10, 10, 10, 10, 9, 9, 8, 7, 7, 8, 7, 7, 6, 6, 5, 5};
    static final int MIN_WORD_LENGTH = 4;
    static final int MAX_WORD_LENGTH = 24;
    static final int MAX_TRANSFORMED_WORD_LENGTH = 37;
    static final int[] BLOCK_LENGTH_OFFSET = new int[]{1, 5, 9, 13, 17, 25, 33, 41, 49, 65, 81, 97, 113, 145, 177, 209, 241, 305, 369, 497, 753, 1265, 2289, 4337, 8433, 16625};
    static final int[] BLOCK_LENGTH_N_BITS = new int[]{2, 2, 2, 2, 3, 3, 3, 3, 4, 4, 4, 4, 5, 5, 5, 5, 6, 6, 7, 8, 9, 10, 11, 12, 13, 24};
    static final int[] INSERT_LENGTH_OFFSET = new int[]{0, 1, 2, 3, 4, 5, 6, 8, 10, 14, 18, 26, 34, 50, 66, 98, 130, 194, 322, 578, 1090, 2114, 6210, 22594};
    static final int[] INSERT_LENGTH_N_BITS = new int[]{0, 0, 0, 0, 0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 7, 8, 9, 10, 12, 14, 24};
    static final int[] COPY_LENGTH_OFFSET = new int[]{2, 3, 4, 5, 6, 7, 8, 9, 10, 12, 14, 18, 22, 30, 38, 54, 70, 102, 134, 198, 326, 582, 1094, 2118};
    static final int[] COPY_LENGTH_N_BITS = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 7, 8, 9, 10, 24};
    static final int[] INSERT_RANGE_LUT = new int[]{0, 0, 8, 8, 0, 16, 8, 16, 16};
    static final int[] COPY_RANGE_LUT = new int[]{0, 8, 0, 8, 16, 0, 16, 8, 16};

    Decode() {
    }

    private static int decodeWindowBits(State s2) {
        BitReader.fillBitWindow(s2);
        if (BitReader.readFewBits(s2, 1) == 0) {
            return 16;
        }
        int n = BitReader.readFewBits(s2, 3);
        if (n != 0) {
            return 17 + n;
        }
        n = BitReader.readFewBits(s2, 3);
        if (n != 0) {
            return 8 + n;
        }
        return 17;
    }

    static void initState(State s2, InputStream input) {
        if (s2.runningState != 0) {
            throw new IllegalStateException("State MUST be uninitialized");
        }
        s2.blockTrees = new int[6480];
        s2.input = input;
        BitReader.initBitReader(s2);
        int windowBits = Decode.decodeWindowBits(s2);
        if (windowBits == 9) {
            throw new BrotliRuntimeException("Invalid 'windowBits' code");
        }
        s2.maxRingBufferSize = 1 << windowBits;
        s2.maxBackwardDistance = s2.maxRingBufferSize - 16;
        s2.runningState = 1;
    }

    static void close(State s2) throws IOException {
        if (s2.runningState == 0) {
            throw new IllegalStateException("State MUST be initialized");
        }
        if (s2.runningState == 11) {
            return;
        }
        s2.runningState = 11;
        if (s2.input != null) {
            Utils.closeInput(s2.input);
            s2.input = null;
        }
    }

    private static int decodeVarLenUnsignedByte(State s2) {
        BitReader.fillBitWindow(s2);
        if (BitReader.readFewBits(s2, 1) != 0) {
            int n = BitReader.readFewBits(s2, 3);
            if (n == 0) {
                return 1;
            }
            return BitReader.readFewBits(s2, n) + (1 << n);
        }
        return 0;
    }

    private static void decodeMetaBlockLength(State s2) {
        BitReader.fillBitWindow(s2);
        s2.inputEnd = BitReader.readFewBits(s2, 1);
        s2.metaBlockLength = 0;
        s2.isUncompressed = 0;
        s2.isMetadata = 0;
        if (s2.inputEnd != 0 && BitReader.readFewBits(s2, 1) != 0) {
            return;
        }
        int sizeNibbles = BitReader.readFewBits(s2, 2) + 4;
        if (sizeNibbles == 7) {
            s2.isMetadata = 1;
            if (BitReader.readFewBits(s2, 1) != 0) {
                throw new BrotliRuntimeException("Corrupted reserved bit");
            }
            int sizeBytes = BitReader.readFewBits(s2, 2);
            if (sizeBytes == 0) {
                return;
            }
            for (int i = 0; i < sizeBytes; ++i) {
                BitReader.fillBitWindow(s2);
                int bits = BitReader.readFewBits(s2, 8);
                if (bits == 0 && i + 1 == sizeBytes && sizeBytes > 1) {
                    throw new BrotliRuntimeException("Exuberant nibble");
                }
                s2.metaBlockLength |= bits << i * 8;
            }
        } else {
            for (int i = 0; i < sizeNibbles; ++i) {
                BitReader.fillBitWindow(s2);
                int bits = BitReader.readFewBits(s2, 4);
                if (bits == 0 && i + 1 == sizeNibbles && sizeNibbles > 4) {
                    throw new BrotliRuntimeException("Exuberant nibble");
                }
                s2.metaBlockLength |= bits << i * 4;
            }
        }
        ++s2.metaBlockLength;
        if (s2.inputEnd == 0) {
            s2.isUncompressed = BitReader.readFewBits(s2, 1);
        }
    }

    private static int readSymbol(int[] table, int offset, State s2) {
        int val = BitReader.peekBits(s2);
        int bits = table[offset += val & 0xFF] >> 16;
        int sym = table[offset] & 0xFFFF;
        if (bits <= 8) {
            s2.bitOffset += bits;
            return sym;
        }
        offset += sym;
        int mask = (1 << bits) - 1;
        s2.bitOffset += (table[offset += (val & mask) >>> 8] >> 16) + 8;
        return table[offset] & 0xFFFF;
    }

    private static int readBlockLength(int[] table, int offset, State s2) {
        BitReader.fillBitWindow(s2);
        int code = Decode.readSymbol(table, offset, s2);
        int n = BLOCK_LENGTH_N_BITS[code];
        BitReader.fillBitWindow(s2);
        return BLOCK_LENGTH_OFFSET[code] + BitReader.readBits(s2, n);
    }

    private static int translateShortCodes(int code, int[] ringBuffer, int index) {
        if (code < 16) {
            index += DISTANCE_SHORT_CODE_INDEX_OFFSET[code];
            return ringBuffer[index &= 3] + DISTANCE_SHORT_CODE_VALUE_OFFSET[code];
        }
        return code - 16 + 1;
    }

    private static void moveToFront(int[] v, int index) {
        int value = v[index];
        while (index > 0) {
            v[index] = v[index - 1];
            --index;
        }
        v[0] = value;
    }

    private static void inverseMoveToFrontTransform(byte[] v, int vLen) {
        int i;
        int[] mtf = new int[256];
        for (i = 0; i < 256; ++i) {
            mtf[i] = i;
        }
        for (i = 0; i < vLen; ++i) {
            int index = v[i] & 0xFF;
            v[i] = (byte)mtf[index];
            if (index == 0) continue;
            Decode.moveToFront(mtf, index);
        }
    }

    private static void readHuffmanCodeLengths(int[] codeLengthCodeLengths, int numSymbols, int[] codeLengths, State s2) {
        int symbol = 0;
        int prevCodeLen = 8;
        int repeat = 0;
        int repeatCodeLen = 0;
        int space = 32768;
        int[] table = new int[32];
        Huffman.buildHuffmanTable(table, 0, 5, codeLengthCodeLengths, 18);
        while (symbol < numSymbols && space > 0) {
            BitReader.readMoreInput(s2);
            BitReader.fillBitWindow(s2);
            int p = BitReader.peekBits(s2) & 0x1F;
            s2.bitOffset += table[p] >> 16;
            int codeLen = table[p] & 0xFFFF;
            if (codeLen < 16) {
                repeat = 0;
                codeLengths[symbol++] = codeLen;
                if (codeLen == 0) continue;
                prevCodeLen = codeLen;
                space -= 32768 >> codeLen;
                continue;
            }
            int extraBits = codeLen - 14;
            int newLen = 0;
            if (codeLen == 16) {
                newLen = prevCodeLen;
            }
            if (repeatCodeLen != newLen) {
                repeat = 0;
                repeatCodeLen = newLen;
            }
            int oldRepeat = repeat;
            if (repeat > 0) {
                repeat -= 2;
                repeat <<= extraBits;
            }
            BitReader.fillBitWindow(s2);
            int repeatDelta = (repeat += BitReader.readFewBits(s2, extraBits) + 3) - oldRepeat;
            if (symbol + repeatDelta > numSymbols) {
                throw new BrotliRuntimeException("symbol + repeatDelta > numSymbols");
            }
            for (int i = 0; i < repeatDelta; ++i) {
                codeLengths[symbol++] = repeatCodeLen;
            }
            if (repeatCodeLen == 0) continue;
            space -= repeatDelta << 15 - repeatCodeLen;
        }
        if (space != 0) {
            throw new BrotliRuntimeException("Unused space");
        }
        Utils.fillIntsWithZeroes(codeLengths, symbol, numSymbols);
    }

    static int checkDupes(int[] symbols, int length) {
        for (int i = 0; i < length - 1; ++i) {
            for (int j = i + 1; j < length; ++j) {
                if (symbols[i] != symbols[j]) continue;
                return 0;
            }
        }
        return 1;
    }

    static void readHuffmanCode(int alphabetSize, int[] table, int offset, State s2) {
        int ok = 1;
        BitReader.readMoreInput(s2);
        int[] codeLengths = new int[alphabetSize];
        BitReader.fillBitWindow(s2);
        int simpleCodeOrSkip = BitReader.readFewBits(s2, 2);
        if (simpleCodeOrSkip == 1) {
            int maxBitsCounter = alphabetSize - 1;
            int maxBits = 0;
            int[] symbols = new int[4];
            int numSymbols = BitReader.readFewBits(s2, 2) + 1;
            while (maxBitsCounter != 0) {
                maxBitsCounter >>= 1;
                ++maxBits;
            }
            for (int i = 0; i < numSymbols; ++i) {
                BitReader.fillBitWindow(s2);
                symbols[i] = BitReader.readFewBits(s2, maxBits) % alphabetSize;
                codeLengths[symbols[i]] = 2;
            }
            codeLengths[symbols[0]] = 1;
            switch (numSymbols) {
                case 2: {
                    codeLengths[symbols[1]] = 1;
                    break;
                }
                case 4: {
                    if (BitReader.readFewBits(s2, 1) == 1) {
                        codeLengths[symbols[2]] = 3;
                        codeLengths[symbols[3]] = 3;
                        break;
                    }
                    codeLengths[symbols[0]] = 2;
                    break;
                }
            }
            ok = Decode.checkDupes(symbols, numSymbols);
        } else {
            int[] codeLengthCodeLengths = new int[18];
            int space = 32;
            int numCodes = 0;
            for (int i = simpleCodeOrSkip; i < 18 && space > 0; ++i) {
                int v;
                int codeLenIdx = CODE_LENGTH_CODE_ORDER[i];
                BitReader.fillBitWindow(s2);
                int p = BitReader.peekBits(s2) & 0xF;
                s2.bitOffset += FIXED_TABLE[p] >> 16;
                codeLengthCodeLengths[codeLenIdx] = v = FIXED_TABLE[p] & 0xFFFF;
                if (v == 0) continue;
                space -= 32 >> v;
                ++numCodes;
            }
            if (space != 0 && numCodes != 1) {
                ok = 0;
            }
            Decode.readHuffmanCodeLengths(codeLengthCodeLengths, alphabetSize, codeLengths, s2);
        }
        if (ok == 0) {
            throw new BrotliRuntimeException("Can't readHuffmanCode");
        }
        Huffman.buildHuffmanTable(table, offset, 8, codeLengths, alphabetSize);
    }

    private static int decodeContextMap(int contextMapSize, byte[] contextMap, State s2) {
        BitReader.readMoreInput(s2);
        int numTrees = Decode.decodeVarLenUnsignedByte(s2) + 1;
        if (numTrees == 1) {
            Utils.fillBytesWithZeroes(contextMap, 0, contextMapSize);
            return numTrees;
        }
        BitReader.fillBitWindow(s2);
        int useRleForZeros = BitReader.readFewBits(s2, 1);
        int maxRunLengthPrefix = 0;
        if (useRleForZeros != 0) {
            maxRunLengthPrefix = BitReader.readFewBits(s2, 4) + 1;
        }
        int[] table = new int[1080];
        Decode.readHuffmanCode(numTrees + maxRunLengthPrefix, table, 0, s2);
        int i = 0;
        while (i < contextMapSize) {
            BitReader.readMoreInput(s2);
            BitReader.fillBitWindow(s2);
            int code = Decode.readSymbol(table, 0, s2);
            if (code == 0) {
                contextMap[i] = 0;
                ++i;
                continue;
            }
            if (code <= maxRunLengthPrefix) {
                BitReader.fillBitWindow(s2);
                for (int reps = (1 << code) + BitReader.readFewBits(s2, code); reps != 0; --reps) {
                    if (i >= contextMapSize) {
                        throw new BrotliRuntimeException("Corrupted context map");
                    }
                    contextMap[i] = 0;
                    ++i;
                }
                continue;
            }
            contextMap[i] = (byte)(code - maxRunLengthPrefix);
            ++i;
        }
        BitReader.fillBitWindow(s2);
        if (BitReader.readFewBits(s2, 1) == 1) {
            Decode.inverseMoveToFrontTransform(contextMap, contextMapSize);
        }
        return numTrees;
    }

    private static int decodeBlockTypeAndLength(State s2, int treeType, int numBlockTypes) {
        int[] ringBuffers = s2.rings;
        int offset = 4 + treeType * 2;
        BitReader.fillBitWindow(s2);
        int blockType = Decode.readSymbol(s2.blockTrees, treeType * 1080, s2);
        int result = Decode.readBlockLength(s2.blockTrees, (treeType + 3) * 1080, s2);
        blockType = blockType == 1 ? ringBuffers[offset + 1] + 1 : (blockType == 0 ? ringBuffers[offset] : (blockType -= 2));
        if (blockType >= numBlockTypes) {
            blockType -= numBlockTypes;
        }
        ringBuffers[offset] = ringBuffers[offset + 1];
        ringBuffers[offset + 1] = blockType;
        return result;
    }

    private static void decodeLiteralBlockSwitch(State s2) {
        s2.literalBlockLength = Decode.decodeBlockTypeAndLength(s2, 0, s2.numLiteralBlockTypes);
        int literalBlockType = s2.rings[5];
        s2.contextMapSlice = literalBlockType << 6;
        s2.literalTreeIndex = s2.contextMap[s2.contextMapSlice] & 0xFF;
        s2.literalTree = s2.hGroup0[s2.literalTreeIndex];
        byte contextMode = s2.contextModes[literalBlockType];
        s2.contextLookupOffset1 = contextMode << 9;
        s2.contextLookupOffset2 = s2.contextLookupOffset1 + 256;
    }

    private static void decodeCommandBlockSwitch(State s2) {
        s2.commandBlockLength = Decode.decodeBlockTypeAndLength(s2, 1, s2.numCommandBlockTypes);
        s2.treeCommandOffset = s2.hGroup1[s2.rings[7]];
    }

    private static void decodeDistanceBlockSwitch(State s2) {
        s2.distanceBlockLength = Decode.decodeBlockTypeAndLength(s2, 2, s2.numDistanceBlockTypes);
        s2.distContextMapSlice = s2.rings[9] << 2;
    }

    private static void maybeReallocateRingBuffer(State s2) {
        int newSize = s2.maxRingBufferSize;
        if (newSize > s2.expectedTotalSize) {
            int minimalNewSize = s2.expectedTotalSize;
            while (newSize >> 1 > minimalNewSize) {
                newSize >>= 1;
            }
            if (s2.inputEnd == 0 && newSize < 16384 && s2.maxRingBufferSize >= 16384) {
                newSize = 16384;
            }
        }
        if (newSize <= s2.ringBufferSize) {
            return;
        }
        int ringBufferSizeWithSlack = newSize + 37;
        byte[] newBuffer = new byte[ringBufferSizeWithSlack];
        if (s2.ringBuffer.length != 0) {
            System.arraycopy(s2.ringBuffer, 0, newBuffer, 0, s2.ringBufferSize);
        }
        s2.ringBuffer = newBuffer;
        s2.ringBufferSize = newSize;
    }

    private static void readNextMetablockHeader(State s2) {
        if (s2.inputEnd != 0) {
            s2.nextRunningState = 10;
            s2.bytesToWrite = s2.pos;
            s2.bytesWritten = 0;
            s2.runningState = 12;
            return;
        }
        s2.hGroup0 = new int[0];
        s2.hGroup1 = new int[0];
        s2.hGroup2 = new int[0];
        BitReader.readMoreInput(s2);
        Decode.decodeMetaBlockLength(s2);
        if (s2.metaBlockLength == 0 && s2.isMetadata == 0) {
            return;
        }
        if (s2.isUncompressed != 0 || s2.isMetadata != 0) {
            BitReader.jumpToByteBoundary(s2);
            s2.runningState = s2.isMetadata != 0 ? 4 : 5;
        } else {
            s2.runningState = 2;
        }
        if (s2.isMetadata != 0) {
            return;
        }
        s2.expectedTotalSize += s2.metaBlockLength;
        if (s2.expectedTotalSize > 0x40000000) {
            s2.expectedTotalSize = 0x40000000;
        }
        if (s2.ringBufferSize < s2.maxRingBufferSize) {
            Decode.maybeReallocateRingBuffer(s2);
        }
    }

    private static int readMetablockPartition(State s2, int treeType, int numBlockTypes) {
        if (numBlockTypes <= 1) {
            return 0x10000000;
        }
        Decode.readHuffmanCode(numBlockTypes + 2, s2.blockTrees, treeType * 1080, s2);
        Decode.readHuffmanCode(26, s2.blockTrees, (treeType + 3) * 1080, s2);
        return Decode.readBlockLength(s2.blockTrees, (treeType + 3) * 1080, s2);
    }

    private static void readMetablockHuffmanCodesAndContextMaps(State s2) {
        s2.numLiteralBlockTypes = Decode.decodeVarLenUnsignedByte(s2) + 1;
        s2.literalBlockLength = Decode.readMetablockPartition(s2, 0, s2.numLiteralBlockTypes);
        s2.numCommandBlockTypes = Decode.decodeVarLenUnsignedByte(s2) + 1;
        s2.commandBlockLength = Decode.readMetablockPartition(s2, 1, s2.numCommandBlockTypes);
        s2.numDistanceBlockTypes = Decode.decodeVarLenUnsignedByte(s2) + 1;
        s2.distanceBlockLength = Decode.readMetablockPartition(s2, 2, s2.numDistanceBlockTypes);
        BitReader.readMoreInput(s2);
        BitReader.fillBitWindow(s2);
        s2.distancePostfixBits = BitReader.readFewBits(s2, 2);
        s2.numDirectDistanceCodes = 16 + (BitReader.readFewBits(s2, 4) << s2.distancePostfixBits);
        s2.distancePostfixMask = (1 << s2.distancePostfixBits) - 1;
        int numDistanceCodes = s2.numDirectDistanceCodes + (48 << s2.distancePostfixBits);
        s2.contextModes = new byte[s2.numLiteralBlockTypes];
        int i = 0;
        while (i < s2.numLiteralBlockTypes) {
            int limit = Math.min(i + 96, s2.numLiteralBlockTypes);
            while (i < limit) {
                BitReader.fillBitWindow(s2);
                s2.contextModes[i] = (byte)BitReader.readFewBits(s2, 2);
                ++i;
            }
            BitReader.readMoreInput(s2);
        }
        s2.contextMap = new byte[s2.numLiteralBlockTypes << 6];
        int numLiteralTrees = Decode.decodeContextMap(s2.numLiteralBlockTypes << 6, s2.contextMap, s2);
        s2.trivialLiteralContext = 1;
        for (int j = 0; j < s2.numLiteralBlockTypes << 6; ++j) {
            if (s2.contextMap[j] == j >> 6) continue;
            s2.trivialLiteralContext = 0;
            break;
        }
        s2.distContextMap = new byte[s2.numDistanceBlockTypes << 2];
        int numDistTrees = Decode.decodeContextMap(s2.numDistanceBlockTypes << 2, s2.distContextMap, s2);
        s2.hGroup0 = Decode.decodeHuffmanTreeGroup(256, numLiteralTrees, s2);
        s2.hGroup1 = Decode.decodeHuffmanTreeGroup(704, s2.numCommandBlockTypes, s2);
        s2.hGroup2 = Decode.decodeHuffmanTreeGroup(numDistanceCodes, numDistTrees, s2);
        s2.contextMapSlice = 0;
        s2.distContextMapSlice = 0;
        s2.contextLookupOffset1 = s2.contextModes[0] << 9;
        s2.contextLookupOffset2 = s2.contextLookupOffset1 + 256;
        s2.literalTreeIndex = 0;
        s2.literalTree = s2.hGroup0[0];
        s2.treeCommandOffset = s2.hGroup1[0];
        s2.rings[4] = 1;
        s2.rings[5] = 0;
        s2.rings[6] = 1;
        s2.rings[7] = 0;
        s2.rings[8] = 1;
        s2.rings[9] = 0;
    }

    private static void copyUncompressedData(State s2) {
        byte[] ringBuffer = s2.ringBuffer;
        if (s2.metaBlockLength <= 0) {
            BitReader.reload(s2);
            s2.runningState = 1;
            return;
        }
        int chunkLength = Math.min(s2.ringBufferSize - s2.pos, s2.metaBlockLength);
        BitReader.copyBytes(s2, ringBuffer, s2.pos, chunkLength);
        s2.metaBlockLength -= chunkLength;
        s2.pos += chunkLength;
        if (s2.pos == s2.ringBufferSize) {
            s2.nextRunningState = 5;
            s2.bytesToWrite = s2.ringBufferSize;
            s2.bytesWritten = 0;
            s2.runningState = 12;
            return;
        }
        BitReader.reload(s2);
        s2.runningState = 1;
    }

    private static int writeRingBuffer(State s2) {
        int toWrite = Math.min(s2.outputLength - s2.outputUsed, s2.bytesToWrite - s2.bytesWritten);
        if (toWrite != 0) {
            System.arraycopy(s2.ringBuffer, s2.bytesWritten, s2.output, s2.outputOffset + s2.outputUsed, toWrite);
            s2.outputUsed += toWrite;
            s2.bytesWritten += toWrite;
        }
        if (s2.outputUsed < s2.outputLength) {
            return 1;
        }
        return 0;
    }

    private static int[] decodeHuffmanTreeGroup(int alphabetSize, int n, State s2) {
        int[] group = new int[n + n * 1080];
        int next = n;
        for (int i = 0; i < n; ++i) {
            group[i] = next;
            Decode.readHuffmanCode(alphabetSize, group, next, s2);
            next += 1080;
        }
        return group;
    }

    /*
     * Unable to fully structure code
     */
    static void decompress(State s) {
        if (s.runningState == 0) {
            throw new IllegalStateException("Can't decompress until initialized");
        }
        if (s.runningState == 11) {
            throw new IllegalStateException("Can't decompress after close");
        }
        ringBufferMask = s.ringBufferSize - 1;
        ringBuffer = s.ringBuffer;
        block12: while (s.runningState != 10) {
            switch (s.runningState) {
                case 1: {
                    if (s.metaBlockLength < 0) {
                        throw new BrotliRuntimeException("Invalid metablock length");
                    }
                    Decode.readNextMetablockHeader(s);
                    ringBufferMask = s.ringBufferSize - 1;
                    ringBuffer = s.ringBuffer;
                    continue block12;
                }
                case 2: {
                    Decode.readMetablockHuffmanCodesAndContextMaps(s);
                    s.runningState = 3;
                }
                case 3: {
                    if (s.metaBlockLength <= 0) {
                        s.runningState = 1;
                        continue block12;
                    }
                    BitReader.readMoreInput(s);
                    if (s.commandBlockLength == 0) {
                        Decode.decodeCommandBlockSwitch(s);
                    }
                    --s.commandBlockLength;
                    BitReader.fillBitWindow(s);
                    cmdCode = Decode.readSymbol(s.hGroup1, s.treeCommandOffset, s);
                    rangeIdx = cmdCode >>> 6;
                    s.distanceCode = 0;
                    if (rangeIdx >= 2) {
                        rangeIdx -= 2;
                        s.distanceCode = -1;
                    }
                    insertCode = Decode.INSERT_RANGE_LUT[rangeIdx] + (cmdCode >>> 3 & 7);
                    BitReader.fillBitWindow(s);
                    insertBits = Decode.INSERT_LENGTH_N_BITS[insertCode];
                    insertExtra = BitReader.readBits(s, insertBits);
                    s.insertLength = Decode.INSERT_LENGTH_OFFSET[insertCode] + insertExtra;
                    copyCode = Decode.COPY_RANGE_LUT[rangeIdx] + (cmdCode & 7);
                    BitReader.fillBitWindow(s);
                    copyBits = Decode.COPY_LENGTH_N_BITS[copyCode];
                    copyExtra = BitReader.readBits(s, copyBits);
                    s.copyLength = Decode.COPY_LENGTH_OFFSET[copyCode] + copyExtra;
                    s.j = 0;
                    s.runningState = 6;
                }
                case 6: {
                    if (s.trivialLiteralContext == 0) ** GOTO lbl63
                    while (s.j < s.insertLength) {
                        BitReader.readMoreInput(s);
                        if (s.literalBlockLength == 0) {
                            Decode.decodeLiteralBlockSwitch(s);
                        }
                        --s.literalBlockLength;
                        BitReader.fillBitWindow(s);
                        ringBuffer[s.pos] = (byte)Decode.readSymbol(s.hGroup0, s.literalTree, s);
                        ++s.j;
                        if (s.pos++ != ringBufferMask) continue;
                        s.nextRunningState = 6;
                        s.bytesToWrite = s.ringBufferSize;
                        s.bytesWritten = 0;
                        s.runningState = 12;
                        ** GOTO lbl82
                    }
                    ** GOTO lbl82
lbl63:
                    // 1 sources

                    prevByte1 = ringBuffer[s.pos - 1 & ringBufferMask] & 255;
                    prevByte2 = ringBuffer[s.pos - 2 & ringBufferMask] & 255;
                    while (s.j < s.insertLength) {
                        BitReader.readMoreInput(s);
                        if (s.literalBlockLength == 0) {
                            Decode.decodeLiteralBlockSwitch(s);
                        }
                        literalTreeIndex = s.contextMap[s.contextMapSlice + (Context.LOOKUP[s.contextLookupOffset1 + prevByte1] | Context.LOOKUP[s.contextLookupOffset2 + prevByte2])] & 255;
                        --s.literalBlockLength;
                        prevByte2 = prevByte1;
                        BitReader.fillBitWindow(s);
                        prevByte1 = Decode.readSymbol(s.hGroup0, s.hGroup0[literalTreeIndex], s);
                        ringBuffer[s.pos] = (byte)prevByte1;
                        ++s.j;
                        if (s.pos++ != ringBufferMask) continue;
                        s.nextRunningState = 6;
                        s.bytesToWrite = s.ringBufferSize;
                        s.bytesWritten = 0;
                        s.runningState = 12;
                        break;
                    }
lbl82:
                    // 4 sources

                    if (s.runningState != 6) continue block12;
                    s.metaBlockLength -= s.insertLength;
                    if (s.metaBlockLength <= 0) {
                        s.runningState = 3;
                        continue block12;
                    }
                    if (s.distanceCode < 0) {
                        BitReader.readMoreInput(s);
                        if (s.distanceBlockLength == 0) {
                            Decode.decodeDistanceBlockSwitch(s);
                        }
                        --s.distanceBlockLength;
                        BitReader.fillBitWindow(s);
                        s.distanceCode = Decode.readSymbol(s.hGroup2, s.hGroup2[s.distContextMap[s.distContextMapSlice + (s.copyLength > 4 ? 3 : s.copyLength - 2)] & 255], s);
                        if (s.distanceCode >= s.numDirectDistanceCodes) {
                            s.distanceCode -= s.numDirectDistanceCodes;
                            postfix = s.distanceCode & s.distancePostfixMask;
                            s.distanceCode >>>= s.distancePostfixBits;
                            n = (s.distanceCode >>> 1) + 1;
                            offset = (2 + (s.distanceCode & 1) << n) - 4;
                            BitReader.fillBitWindow(s);
                            distanceExtra = BitReader.readBits(s, n);
                            s.distanceCode = s.numDirectDistanceCodes + postfix + (offset + distanceExtra << s.distancePostfixBits);
                        }
                    }
                    s.distance = Decode.translateShortCodes(s.distanceCode, s.rings, s.distRbIdx);
                    if (s.distance < 0) {
                        throw new BrotliRuntimeException("Negative distance");
                    }
                    s.maxDistance = s.maxDistance != s.maxBackwardDistance && s.pos < s.maxBackwardDistance ? s.pos : s.maxBackwardDistance;
                    s.copyDst = s.pos;
                    if (s.distance > s.maxDistance) {
                        s.runningState = 9;
                        continue block12;
                    }
                    if (s.distanceCode > 0) {
                        s.rings[s.distRbIdx & 3] = s.distance;
                        ++s.distRbIdx;
                    }
                    if (s.copyLength > s.metaBlockLength) {
                        throw new BrotliRuntimeException("Invalid backward reference");
                    }
                    s.j = 0;
                    s.runningState = 7;
                }
                case 7: {
                    src = s.pos - s.distance & ringBufferMask;
                    dst = s.pos;
                    copyLength = s.copyLength - s.j;
                    srcEnd = src + copyLength;
                    dstEnd = dst + copyLength;
                    if (srcEnd < ringBufferMask && dstEnd < ringBufferMask) {
                        if (copyLength < 12 || srcEnd > dst && dstEnd > src) {
                            for (k = 0; k < copyLength; ++k) {
                                ringBuffer[dst++] = ringBuffer[src++];
                            }
                        } else {
                            Utils.copyBytesWithin(ringBuffer, dst, src, srcEnd);
                        }
                        s.j += copyLength;
                        s.metaBlockLength -= copyLength;
                        s.pos += copyLength;
                    } else {
                        while (s.j < s.copyLength) {
                            ringBuffer[s.pos] = ringBuffer[s.pos - s.distance & ringBufferMask];
                            --s.metaBlockLength;
                            ++s.j;
                            if (s.pos++ != ringBufferMask) continue;
                            s.nextRunningState = 7;
                            s.bytesToWrite = s.ringBufferSize;
                            s.bytesWritten = 0;
                            s.runningState = 12;
                            break;
                        }
                    }
                    if (s.runningState != 7) continue block12;
                    s.runningState = 3;
                    continue block12;
                }
                case 9: {
                    if (s.copyLength < 4 || s.copyLength > 24) ** GOTO lbl170
                    offset = Decode.DICTIONARY_OFFSETS_BY_LENGTH[s.copyLength];
                    wordId = s.distance - s.maxDistance - 1;
                    shift = Decode.DICTIONARY_SIZE_BITS_BY_LENGTH[s.copyLength];
                    mask = (1 << shift) - 1;
                    wordIdx = wordId & mask;
                    transformIdx = wordId >>> shift;
                    offset += wordIdx * s.copyLength;
                    if (transformIdx < 121) {
                        len = Transform.transformDictionaryWord(ringBuffer, s.copyDst, Dictionary.getData(), offset, s.copyLength, transformIdx);
                        s.copyDst += len;
                        s.pos += len;
                        s.metaBlockLength -= len;
                        if (s.copyDst >= s.ringBufferSize) {
                            s.nextRunningState = 8;
                            s.bytesToWrite = s.ringBufferSize;
                            s.bytesWritten = 0;
                            s.runningState = 12;
                            continue block12;
                        }
                    } else {
                        throw new BrotliRuntimeException("Invalid backward reference");
lbl170:
                        // 1 sources

                        throw new BrotliRuntimeException("Invalid backward reference");
                    }
                    s.runningState = 3;
                    continue block12;
                }
                case 8: {
                    Utils.copyBytesWithin(ringBuffer, 0, s.ringBufferSize, s.copyDst);
                    s.runningState = 3;
                    continue block12;
                }
                case 4: {
                    while (s.metaBlockLength > 0) {
                        BitReader.readMoreInput(s);
                        BitReader.fillBitWindow(s);
                        BitReader.readFewBits(s, 8);
                        --s.metaBlockLength;
                    }
                    s.runningState = 1;
                    continue block12;
                }
                case 5: {
                    Decode.copyUncompressedData(s);
                    continue block12;
                }
                case 12: {
                    if (Decode.writeRingBuffer(s) == 0) {
                        return;
                    }
                    if (s.pos >= s.maxBackwardDistance) {
                        s.maxDistance = s.maxBackwardDistance;
                    }
                    s.pos &= ringBufferMask;
                    s.runningState = s.nextRunningState;
                    continue block12;
                }
            }
            throw new BrotliRuntimeException("Unexpected state " + s.runningState);
        }
        if (s.runningState == 10) {
            if (s.metaBlockLength < 0) {
                throw new BrotliRuntimeException("Invalid metablock length");
            }
            BitReader.jumpToByteBoundary(s);
            BitReader.checkHealth(s, 1);
        }
    }
}

