/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer.internals.events;

import java.util.Collections;
import java.util.Objects;
import java.util.SortedSet;
import org.apache.kafka.clients.consumer.internals.ConsumerRebalanceListenerMethodName;
import org.apache.kafka.clients.consumer.internals.events.BackgroundEvent;
import org.apache.kafka.clients.consumer.internals.events.CompletableBackgroundEvent;
import org.apache.kafka.common.TopicPartition;

public class ConsumerRebalanceListenerCallbackNeededEvent
extends CompletableBackgroundEvent<Void> {
    private final ConsumerRebalanceListenerMethodName methodName;
    private final SortedSet<TopicPartition> partitions;

    public ConsumerRebalanceListenerCallbackNeededEvent(ConsumerRebalanceListenerMethodName methodName, SortedSet<TopicPartition> partitions) {
        super(BackgroundEvent.Type.CONSUMER_REBALANCE_LISTENER_CALLBACK_NEEDED);
        this.methodName = Objects.requireNonNull(methodName);
        this.partitions = Collections.unmodifiableSortedSet(partitions);
    }

    public ConsumerRebalanceListenerMethodName methodName() {
        return this.methodName;
    }

    public SortedSet<TopicPartition> partitions() {
        return this.partitions;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ConsumerRebalanceListenerCallbackNeededEvent that = (ConsumerRebalanceListenerCallbackNeededEvent)o;
        return this.methodName == that.methodName && this.partitions.equals(that.partitions);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.methodName.hashCode();
        result = 31 * result + this.partitions.hashCode();
        return result;
    }

    @Override
    protected String toStringBase() {
        return super.toStringBase() + ", methodName=" + (Object)((Object)this.methodName) + ", partitions=" + this.partitions;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "{" + this.toStringBase() + '}';
    }
}

