/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.xml;

import java.util.Arrays;
import java.util.List;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.Property;
import org.xml.sax.helpers.DefaultHandler;

class AbstractMetadataHandler
extends DefaultHandler {
    private final Metadata metadata;
    private final Property property;
    private final String name;

    protected AbstractMetadataHandler(Metadata metadata, String name) {
        this.metadata = metadata;
        this.property = null;
        this.name = name;
    }

    protected AbstractMetadataHandler(Metadata metadata, Property property) {
        this.metadata = metadata;
        this.property = property;
        this.name = property.getName();
    }

    protected void addMetadata(String value) {
        if (value != null && value.length() > 0) {
            if (this.metadata.isMultiValued(this.name)) {
                List<String> previous = Arrays.asList(this.metadata.getValues(this.name));
                if (!previous.contains(value)) {
                    if (this.property != null) {
                        this.metadata.add(this.property, value);
                    } else {
                        this.metadata.add(this.name, value);
                    }
                }
            } else {
                String previous = this.metadata.get(this.name);
                if (previous != null && previous.length() > 0) {
                    if (!previous.equals(value)) {
                        if (this.property != null) {
                            if (this.property.isMultiValuePermitted()) {
                                this.metadata.add(this.property, value);
                            } else {
                                this.metadata.set(this.property, value);
                            }
                        } else {
                            this.metadata.add(this.name, value);
                        }
                    }
                } else if (this.property != null) {
                    this.metadata.set(this.property, value);
                } else {
                    this.metadata.set(this.name, value);
                }
            }
        }
    }
}

