/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.geospatial.ip2geo.processor;

import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.common.settings.ClusterSettings;
import org.opensearch.geospatial.ip2geo.common.DatasourceState;
import org.opensearch.geospatial.ip2geo.common.ParameterValidator;
import org.opensearch.geospatial.ip2geo.dao.DatasourceDao;
import org.opensearch.geospatial.ip2geo.dao.GeoIpDataDao;
import org.opensearch.geospatial.ip2geo.dao.Ip2GeoCachedDao;
import org.opensearch.ingest.AbstractProcessor;
import org.opensearch.ingest.ConfigurationUtils;
import org.opensearch.ingest.IngestDocument;
import org.opensearch.ingest.IngestService;
import org.opensearch.ingest.Processor;

public final class Ip2GeoProcessor
extends AbstractProcessor {
    @Generated
    private static final Logger log = LogManager.getLogger(Ip2GeoProcessor.class);
    private static final Map<String, Object> DATA_EXPIRED = Map.of("error", "ip2geo_data_expired");
    public static final String CONFIG_FIELD = "field";
    public static final String CONFIG_TARGET_FIELD = "target_field";
    public static final String CONFIG_DATASOURCE = "datasource";
    public static final String CONFIG_PROPERTIES = "properties";
    public static final String CONFIG_IGNORE_MISSING = "ignore_missing";
    private final String field;
    private final String targetField;
    private final String datasourceName;
    private final Set<String> properties;
    private final boolean ignoreMissing;
    private final ClusterSettings clusterSettings;
    private final DatasourceDao datasourceDao;
    private final GeoIpDataDao geoIpDataDao;
    private final Ip2GeoCachedDao ip2GeoCachedDao;
    public static final String TYPE = "ip2geo";

    public Ip2GeoProcessor(String tag, String description, String field, String targetField, String datasourceName, Set<String> properties, boolean ignoreMissing, ClusterSettings clusterSettings, DatasourceDao datasourceDao, GeoIpDataDao geoIpDataDao, Ip2GeoCachedDao ip2GeoCachedDao) {
        super(tag, description);
        this.field = field;
        this.targetField = targetField;
        this.datasourceName = datasourceName;
        this.properties = properties;
        this.ignoreMissing = ignoreMissing;
        this.clusterSettings = clusterSettings;
        this.datasourceDao = datasourceDao;
        this.geoIpDataDao = geoIpDataDao;
        this.ip2GeoCachedDao = ip2GeoCachedDao;
    }

    public void execute(IngestDocument ingestDocument, BiConsumer<IngestDocument, Exception> handler) {
        try {
            Object ip = ingestDocument.getFieldValue(this.field, Object.class, this.ignoreMissing);
            if (ip == null) {
                handler.accept(ingestDocument, null);
                return;
            }
            if (ip instanceof String) {
                this.executeInternal(ingestDocument, handler, (String)ip);
            } else if (ip instanceof List) {
                this.executeInternal(ingestDocument, handler, (List)ip);
            } else {
                handler.accept(null, new IllegalArgumentException(String.format(Locale.ROOT, "field [%s] should contain only string or array of strings", this.field)));
            }
        }
        catch (Exception e) {
            handler.accept(null, e);
        }
    }

    public IngestDocument execute(IngestDocument ingestDocument) {
        throw new IllegalStateException("Not implemented");
    }

    private void executeInternal(IngestDocument ingestDocument, BiConsumer<IngestDocument, Exception> handler, String ip) {
        this.validateDatasourceIsInAvailableState(this.datasourceName);
        String indexName = this.ip2GeoCachedDao.getIndexName(this.datasourceName);
        if (this.ip2GeoCachedDao.isExpired(this.datasourceName) || indexName == null) {
            this.handleExpiredData(ingestDocument, handler);
            return;
        }
        Map<String, Object> geoData = this.ip2GeoCachedDao.getGeoData(indexName, ip);
        if (!geoData.isEmpty()) {
            ingestDocument.setFieldValue(this.targetField, this.filteredGeoData(geoData));
        }
        handler.accept(ingestDocument, null);
    }

    private Map<String, Object> filteredGeoData(Map<String, Object> geoData) {
        if (this.properties == null) {
            return geoData;
        }
        return this.properties.stream().filter(p -> geoData.containsKey(p)).collect(Collectors.toMap(p -> p, p -> geoData.get(p)));
    }

    private void validateDatasourceIsInAvailableState(String datasourceName) {
        if (!this.ip2GeoCachedDao.has(datasourceName)) {
            throw new IllegalStateException("datasource does not exist");
        }
        if (!DatasourceState.AVAILABLE.equals((Object)this.ip2GeoCachedDao.getState(datasourceName))) {
            throw new IllegalStateException("datasource is not in an available state");
        }
    }

    private void handleExpiredData(IngestDocument ingestDocument, BiConsumer<IngestDocument, Exception> handler) {
        ingestDocument.setFieldValue(this.targetField, DATA_EXPIRED);
        handler.accept(ingestDocument, null);
    }

    private void executeInternal(IngestDocument ingestDocument, BiConsumer<IngestDocument, Exception> handler, List<?> ips) {
        for (Object ip2 : ips) {
            if (ip2 instanceof String) continue;
            throw new IllegalArgumentException("array in field [" + this.field + "] should only contain strings");
        }
        this.validateDatasourceIsInAvailableState(this.datasourceName);
        String indexName = this.ip2GeoCachedDao.getIndexName(this.datasourceName);
        if (this.ip2GeoCachedDao.isExpired(this.datasourceName) || indexName == null) {
            this.handleExpiredData(ingestDocument, handler);
            return;
        }
        List geoDataList = ips.stream().map(ip -> this.ip2GeoCachedDao.getGeoData(indexName, (String)ip)).filter(geoData -> !geoData.isEmpty()).map(this::filteredGeoData).collect(Collectors.toList());
        if (!geoDataList.isEmpty()) {
            ingestDocument.setFieldValue(this.targetField, geoDataList);
        }
        handler.accept(ingestDocument, null);
    }

    public String getType() {
        return TYPE;
    }

    @Generated
    public String getDatasourceName() {
        return this.datasourceName;
    }

    public static final class Factory
    implements Processor.Factory {
        private static final ParameterValidator VALIDATOR = new ParameterValidator();
        private final IngestService ingestService;
        private final DatasourceDao datasourceDao;
        private final GeoIpDataDao geoIpDataDao;
        private final Ip2GeoCachedDao ip2GeoCachedDao;

        public Factory(IngestService ingestService, DatasourceDao datasourceDao, GeoIpDataDao geoIpDataDao, Ip2GeoCachedDao ip2GeoCachedDao) {
            this.ingestService = ingestService;
            this.datasourceDao = datasourceDao;
            this.geoIpDataDao = geoIpDataDao;
            this.ip2GeoCachedDao = ip2GeoCachedDao;
        }

        public Ip2GeoProcessor create(Map<String, Processor.Factory> registry, String processorTag, String description, Map<String, Object> config) throws IOException {
            String ipField = ConfigurationUtils.readStringProperty((String)Ip2GeoProcessor.TYPE, (String)processorTag, config, (String)Ip2GeoProcessor.CONFIG_FIELD);
            String targetField = ConfigurationUtils.readStringProperty((String)Ip2GeoProcessor.TYPE, (String)processorTag, config, (String)Ip2GeoProcessor.CONFIG_TARGET_FIELD, (String)Ip2GeoProcessor.TYPE);
            String datasourceName = ConfigurationUtils.readStringProperty((String)Ip2GeoProcessor.TYPE, (String)processorTag, config, (String)Ip2GeoProcessor.CONFIG_DATASOURCE);
            List propertyNames = ConfigurationUtils.readOptionalList((String)Ip2GeoProcessor.TYPE, (String)processorTag, config, (String)Ip2GeoProcessor.CONFIG_PROPERTIES);
            boolean ignoreMissing = ConfigurationUtils.readBooleanProperty((String)Ip2GeoProcessor.TYPE, (String)processorTag, config, (String)Ip2GeoProcessor.CONFIG_IGNORE_MISSING, (boolean)false);
            List<String> error = VALIDATOR.validateDatasourceName(datasourceName);
            if (!error.isEmpty()) {
                throw ConfigurationUtils.newConfigurationException((String)Ip2GeoProcessor.TYPE, (String)processorTag, (String)Ip2GeoProcessor.CONFIG_DATASOURCE, (String)error.get(0));
            }
            return new Ip2GeoProcessor(processorTag, description, ipField, targetField, datasourceName, propertyNames == null ? null : new HashSet<String>(propertyNames), ignoreMissing, this.ingestService.getClusterService().getClusterSettings(), this.datasourceDao, this.geoIpDataDao, this.ip2GeoCachedDao);
        }
    }
}

