/*
 * Decompiled with CFR 0.152.
 */
package mediathek.tool.dns;

import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import mediathek.tool.dns.DnsSelector;
import mediathek.tool.dns.IPvPreferenceMode;
import okhttp3.Dns;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \n2\u00020\u0001:\u0001\nB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lmediathek/tool/dns/DnsSelector;", "Lokhttp3/Dns;", "preferenceMode", "Lmediathek/tool/dns/IPvPreferenceMode;", "(Lmediathek/tool/dns/IPvPreferenceMode;)V", "lookup", "", "Ljava/net/InetAddress;", "hostname", "", "Companion", "MediathekView"})
@SourceDebugExtension(value={"SMAP\nDnsSelector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DnsSelector.kt\nmediathek/tool/dns/DnsSelector\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,32:1\n1045#2:33\n1045#2:34\n766#2:35\n857#2,2:36\n766#2:38\n857#2,2:39\n*S KotlinDebug\n*F\n+ 1 DnsSelector.kt\nmediathek/tool/dns/DnsSelector\n*L\n17#1:33\n18#1:34\n19#1:35\n19#1:36,2\n20#1:38\n20#1:39,2\n*E\n"})
public final class DnsSelector
implements Dns {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final IPvPreferenceMode preferenceMode;
    private static final Logger logger = LogManager.getLogger(DnsSelector.class.getName());

    public DnsSelector(@NotNull IPvPreferenceMode preferenceMode) {
        Intrinsics.checkNotNullParameter((Object)preferenceMode, "preferenceMode");
        this.preferenceMode = preferenceMode;
    }

    @Override
    @NotNull
    public List<InetAddress> lookup(@NotNull String hostname) {
        Intrinsics.checkNotNullParameter(hostname, "hostname");
        List<InetAddress> addresses = Dns.SYSTEM.lookup(hostname);
        addresses = switch (WhenMappings.$EnumSwitchMapping$0[this.preferenceMode.ordinal()]) {
            case 1 -> {
                Iterable $this$sortedBy$iv = addresses;
                boolean $i$f$sortedBy = false;
                yield CollectionsKt.sortedWith($this$sortedBy$iv, new Comparator(){

                    public final int compare(T a, T b) {
                        InetAddress it = (InetAddress)a;
                        boolean bl = false;
                        Comparable comparable = Boolean.valueOf(Inet4Address.class.isInstance(it));
                        it = (InetAddress)b;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues(comparable2, Inet4Address.class.isInstance(it));
                    }
                });
            }
            case 2 -> {
                Iterable $this$sortedBy$iv = addresses;
                boolean $i$f$sortedBy = false;
                yield CollectionsKt.sortedWith($this$sortedBy$iv, new Comparator(){

                    public final int compare(T a, T b) {
                        InetAddress it = (InetAddress)a;
                        boolean bl = false;
                        Comparable comparable = Boolean.valueOf(Inet6Address.class.isInstance(it));
                        it = (InetAddress)b;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues(comparable2, Inet6Address.class.isInstance(it));
                    }
                });
            }
            case 3 -> {
                InetAddress it;
                Iterable $this$filterTo$iv$iv;
                Iterable $this$filter$iv = addresses;
                boolean $i$f$filter = false;
                Iterable var5_5 = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    it = (InetAddress)element$iv$iv;
                    boolean $i$a$-filter-DnsSelector$lookup$3 = false;
                    if (!Inet6Address.class.isInstance(it)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                yield (List)destination$iv$iv;
            }
            case 4 -> {
                InetAddress it;
                Iterable $this$filter$iv = addresses;
                boolean $i$f$filter = false;
                Iterable $this$filterTo$iv$iv = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    it = (InetAddress)element$iv$iv;
                    boolean $i$a$-filter-DnsSelector$lookup$4 = false;
                    if (!Inet4Address.class.isInstance(it)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                yield (List)destination$iv$iv;
            }
            case 5 -> addresses;
            default -> throw new NoWhenBranchMatchedException();
        };
        logger.trace("Dns (" + hostname + "): " + CollectionsKt.joinToString$default(addresses, ", ", null, null, 0, null, lookup.5.INSTANCE, 30, null));
        return addresses;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lmediathek/tool/dns/DnsSelector$Companion;", "", "()V", "logger", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "MediathekView"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[IPvPreferenceMode.values().length];
            try {
                nArray[IPvPreferenceMode.IPV6_FIRST.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IPvPreferenceMode.IPV4_FIRST.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IPvPreferenceMode.IPV6_ONLY.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IPvPreferenceMode.IPV4_ONLY.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IPvPreferenceMode.SYSTEM.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

