/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions.registry;

import com.install4j.api.context.Context;
import com.install4j.runtime.beans.actions.registry.PreferenceDeleteType;
import com.install4j.runtime.beans.actions.registry.PreferencesAction;
import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.installer.helper.PreferencesUtil;
import com.install4j.runtime.installer.helper.comm.ExecutionContext;
import com.install4j.runtime.installer.helper.comm.HelperCommunication;
import com.install4j.runtime.installer.helper.comm.actions.FetchObjectAction;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.prefs.BackingStoreException;
import java.util.prefs.InvalidPreferencesFormatException;
import java.util.prefs.Preferences;

public abstract class PreferencesDeleteAction
extends PreferencesAction {
    private PreferenceDeleteType preferenceDeleteType = PreferenceDeleteType.USER;

    public PreferenceDeleteType getPreferenceDeleteType() {
        return this.replaceWithTextOverride("preferenceDeleteType", this.preferenceDeleteType, PreferenceDeleteType.class);
    }

    public void setPreferenceDeleteType(PreferenceDeleteType preferenceDeleteType) {
        this.preferenceDeleteType = preferenceDeleteType;
    }

    protected boolean executePreferencesDeleter(PreferencesDeleter preferencesDeleter, Context context) {
        boolean success = false;
        if (this.getPreferenceDeleteType() == PreferenceDeleteType.SYSTEM || this.getPreferenceDeleteType() == PreferenceDeleteType.SYSTEM_AND_USER) {
            success |= this.handleRollbackActions(PreferencesDeleteAction.executePreferenceDeleter(preferencesDeleter, this.getPackageName(), false, context));
        }
        if (this.getPreferenceDeleteType() == PreferenceDeleteType.USER || this.getPreferenceDeleteType() == PreferenceDeleteType.SYSTEM_AND_USER) {
            success |= this.handleRollbackActions(PreferencesDeleteAction.executePreferenceDeleter(preferencesDeleter, this.getPackageName(), true, context));
        }
        return success;
    }

    private static List<PreferencesAction.PreferencesRollbackAction> executePreferenceDeleter(PreferencesDeleter preferencesDeleter, String packageName, boolean userSpecific, Context context) {
        if (HelperCommunication.getInstance().isElevatedHelper() && userSpecific) {
            return PreferencesDeleteAction.executePreferenceDeleterUnelevated(preferencesDeleter, packageName, true);
        }
        try {
            PreferencesAction.PackageNodeProvider packageNodeProvider = new PreferencesAction.PackageNodeProvider(packageName, userSpecific, false);
            Preferences packageNode = packageNodeProvider.getPackageNodeUnguarded();
            if (packageNode != null) {
                ArrayList<PreferencesAction.PreferencesRollbackAction> rollbackActions = new ArrayList<PreferencesAction.PreferencesRollbackAction>();
                boolean success = preferencesDeleter.deleteFromPreferences(packageNodeProvider, context, rollbackActions);
                packageNode.flush();
                return success ? rollbackActions : null;
            }
            Logger.getInstance().log(null, "Package " + packageName + " does not exist", false);
        }
        catch (Exception e) {
            Logger.getInstance().log(e);
        }
        return null;
    }

    private static List<PreferencesAction.PreferencesRollbackAction> executePreferenceDeleterUnelevated(final PreferencesDeleter preferencesDeleter, final String packageName, final boolean userSpecific) {
        return HelperCommunication.getInstance().fetchObject(ExecutionContext.UNELEVATED, new FetchObjectAction<List<PreferencesAction.PreferencesRollbackAction>>(){

            @Override
            protected List<PreferencesAction.PreferencesRollbackAction> fetchValue(Context context) throws Exception {
                return PreferencesDeleteAction.executePreferenceDeleter(preferencesDeleter, packageName, userSpecific, context);
            }
        });
    }

    protected static void deleteNode(PreferencesAction.PackageNodeProvider packageNodeProvider, List<PreferencesAction.PreferencesRollbackAction> rollbackActions) throws BackingStoreException {
        PerformedAction performedAction = new PerformedAction(packageNodeProvider);
        packageNodeProvider.getPackageNode().removeNode();
        rollbackActions.add(performedAction);
    }

    protected static boolean deleteKey(PreferencesAction.PackageNodeProvider packageNodeProvider, String key, List<PreferencesAction.PreferencesRollbackAction> rollbackActions) throws BackingStoreException {
        Preferences packageNode = packageNodeProvider.getPackageNode();
        String[] keys2 = packageNode.keys();
        if (keys2 == null || !Arrays.asList(keys2).contains(key)) {
            Logger.getInstance().log(null, "Key " + key + " does not exist", false);
            return false;
        }
        PerformedAction performedAction = new PerformedAction(packageNodeProvider, key);
        packageNode.remove(key);
        rollbackActions.add(performedAction);
        return true;
    }

    protected static interface PreferencesDeleter
    extends Serializable {
        public boolean deleteFromPreferences(PreferencesAction.PackageNodeProvider var1, Context var2, List<PreferencesAction.PreferencesRollbackAction> var3) throws BackingStoreException;
    }

    private static class PerformedAction
    extends PreferencesAction.PreferencesRollbackAction {
        private PreferencesAction.PackageNodeProvider packageNodeProvider;
        private String key;
        private String oldValue;
        private byte[] exportedTree;

        public PerformedAction(PreferencesAction.PackageNodeProvider packageNodeProvider, String key) {
            this.packageNodeProvider = packageNodeProvider;
            this.key = key;
            this.oldValue = packageNodeProvider.getPackageNode().get(key, null);
        }

        public PerformedAction(PreferencesAction.PackageNodeProvider packageNodeProvider) throws BackingStoreException {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            try {
                packageNodeProvider.getPackageNode().exportSubtree(out);
                this.exportedTree = out.toByteArray();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        @Override
        protected void rollbackDirectly(Context context) {
            Preferences packageNode = this.packageNodeProvider.getPackageNode();
            if (packageNode != null && this.oldValue != null) {
                Preferences newNode = PreferencesUtil.getPackageNode(packageNode.absolutePath(), packageNode.isUserNode());
                newNode.put(this.key, this.oldValue);
                try {
                    newNode.flush();
                }
                catch (BackingStoreException e) {
                    Logger.getInstance().log(e);
                }
            }
            if (this.exportedTree != null) {
                try {
                    Preferences.importPreferences(new ByteArrayInputStream(this.exportedTree));
                }
                catch (IOException | InvalidPreferencesFormatException e) {
                    Logger.getInstance().log(e);
                }
            }
        }
    }
}

