/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.api.macos;

import com.install4j.api.ProcessInfo;
import com.install4j.api.Util;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.RunningProcessChecker;
import com.install4j.runtime.installer.platform.macos.MacProcessHelper;
import java.util.Collection;

public class MacProcesses {
    public static Info[] getRunningProcesses() {
        if (!Util.isMacOS()) {
            return new Info[0];
        }
        Collection<ProcessInfo> processes = RunningProcessChecker.getAllRunningProcesses();
        Info[] infos = new Info[processes.size()];
        int i = 0;
        for (ProcessInfo processInfo : processes) {
            infos[i++] = (Info)processInfo;
        }
        return infos;
    }

    public static boolean terminateProcesses(int[] processIds, boolean force, int timeout2) {
        return MacProcessHelper.terminateProcesses(processIds, force, timeout2);
    }

    public static boolean areInstalledLaunchersRunning() {
        if (!InstallerUtil.isMacOS()) {
            return false;
        }
        return RunningProcessChecker.areInstalledLaunchersRunning();
    }

    public static class Info
    extends ProcessInfo {
        private final String displayedName;
        private final String bundleIdentifier;
        private final boolean backgroundOnly;

        public Info(int processId, String moduleName, String displayedName, String bundleIdentifier, boolean backgroundOnly) {
            super(processId, moduleName);
            this.displayedName = displayedName;
            this.bundleIdentifier = bundleIdentifier;
            this.backgroundOnly = backgroundOnly;
        }

        @Override
        public String getWindowTitle() {
            String name = this.bundleIdentifier == null ? this.getModuleName() : this.displayedName;
            int index = name.indexOf(".app/Contents/MacOS/");
            if (index > -1) {
                return name.substring(0, index);
            }
            return name;
        }

        public String getDisplayedName() {
            return this.displayedName;
        }

        public String getBundleIdentifier() {
            return this.bundleIdentifier;
        }

        public boolean isBackgroundOnly() {
            return this.backgroundOnly;
        }

        @Override
        public String toString() {
            return "Info{displayedName='" + this.displayedName + '\'' + ", bundleIdentifier=" + this.bundleIdentifier + ", backgroundOnly=" + this.backgroundOnly + ", " + super.toString();
        }
    }
}

