/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.server;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import org.languagetool.server.AuthException;

public class BasicAuthentication {
    private final String user;
    private final String password;

    public BasicAuthentication(String authHeader) {
        if (!authHeader.startsWith("Basic ")) {
            throw new AuthException("Expected Basic Authentication");
        }
        String authEncoded = authHeader.substring("Basic ".length());
        Charset cs = StandardCharsets.UTF_8;
        ByteBuffer authDecodedBytes = ByteBuffer.wrap(Base64.getDecoder().decode(authEncoded.getBytes(cs)));
        String authDecoded = cs.decode(authDecodedBytes).toString();
        String[] authParts = authDecoded.split(":", 2);
        if (authParts.length != 2 || authParts[0].trim().isEmpty() || authParts[1].trim().isEmpty()) {
            throw new AuthException("Expected Basic Authentication");
        }
        this.user = authParts[0];
        this.password = authParts[1];
    }

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        return this.password;
    }
}

