/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.fs;

import java.io.IOException;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.attribute.GroupPrincipal;
import java.nio.file.attribute.UserPrincipal;
import java.nio.file.attribute.UserPrincipalLookupService;
import java.nio.file.spi.FileSystemProvider;
import java.security.AccessController;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.regex.Pattern;
import sun.nio.fs.Globs;
import sun.nio.fs.UnixFileSystemProvider;
import sun.nio.fs.UnixMountEntry;
import sun.nio.fs.UnixNativeDispatcher;
import sun.nio.fs.UnixPath;
import sun.nio.fs.UnixUserPrincipals;
import sun.nio.fs.Util;
import sun.security.action.GetPropertyAction;

abstract class UnixFileSystem
extends FileSystem {
    private final UnixFileSystemProvider provider;
    private final byte[] defaultDirectory;
    private final boolean needToResolveAgainstDefaultDirectory;
    private final UnixPath rootDirectory;
    private static final String GLOB_SYNTAX = "glob";
    private static final String REGEX_SYNTAX = "regex";

    UnixFileSystem(UnixFileSystemProvider provider, String dir) {
        boolean chdirAllowed;
        this.provider = provider;
        this.defaultDirectory = Util.toBytes(UnixPath.normalizeAndCheck(dir));
        if (this.defaultDirectory[0] != 47) {
            throw new RuntimeException("default directory must be absolute");
        }
        String propValue = AccessController.doPrivileged(new GetPropertyAction("sun.nio.fs.chdirAllowed", "false"));
        boolean bl = chdirAllowed = propValue.length() == 0 ? true : Boolean.valueOf(propValue);
        if (chdirAllowed) {
            this.needToResolveAgainstDefaultDirectory = true;
        } else {
            boolean defaultIsCwd;
            byte[] cwd = UnixNativeDispatcher.getcwd();
            boolean bl2 = defaultIsCwd = cwd.length == this.defaultDirectory.length;
            if (defaultIsCwd) {
                for (int i = 0; i < cwd.length; ++i) {
                    if (cwd[i] == this.defaultDirectory[i]) continue;
                    defaultIsCwd = false;
                    break;
                }
            }
            this.needToResolveAgainstDefaultDirectory = !defaultIsCwd;
        }
        this.rootDirectory = new UnixPath(this, "/");
    }

    byte[] defaultDirectory() {
        return this.defaultDirectory;
    }

    boolean needToResolveAgainstDefaultDirectory() {
        return this.needToResolveAgainstDefaultDirectory;
    }

    UnixPath rootDirectory() {
        return this.rootDirectory;
    }

    boolean isSolaris() {
        return false;
    }

    static List<String> standardFileAttributeViews() {
        return Arrays.asList("basic", "posix", "unix", "owner");
    }

    @Override
    public final FileSystemProvider provider() {
        return this.provider;
    }

    @Override
    public final String getSeparator() {
        return "/";
    }

    @Override
    public final boolean isOpen() {
        return true;
    }

    @Override
    public final boolean isReadOnly() {
        return false;
    }

    @Override
    public final void close() throws IOException {
        throw new UnsupportedOperationException();
    }

    void copyNonPosixAttributes(int sfd, int tfd) {
    }

    @Override
    public final Iterable<Path> getRootDirectories() {
        final List<Path> allowedList = Collections.unmodifiableList(Arrays.asList(this.rootDirectory));
        return new Iterable<Path>(){

            @Override
            public Iterator<Path> iterator() {
                try {
                    SecurityManager sm = System.getSecurityManager();
                    if (sm != null) {
                        sm.checkRead(UnixFileSystem.this.rootDirectory.toString());
                    }
                    return allowedList.iterator();
                }
                catch (SecurityException x) {
                    List disallowed = Collections.emptyList();
                    return disallowed.iterator();
                }
            }
        };
    }

    abstract Iterable<UnixMountEntry> getMountEntries();

    abstract FileStore getFileStore(UnixMountEntry var1) throws IOException;

    @Override
    public final Iterable<FileStore> getFileStores() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            try {
                sm.checkPermission(new RuntimePermission("getFileStoreAttributes"));
            }
            catch (SecurityException se) {
                return Collections.emptyList();
            }
        }
        return new Iterable<FileStore>(){

            @Override
            public Iterator<FileStore> iterator() {
                return new FileStoreIterator();
            }
        };
    }

    @Override
    public final Path getPath(String first, String ... more) {
        String path;
        if (more.length == 0) {
            path = first;
        } else {
            StringBuilder sb = new StringBuilder();
            sb.append(first);
            for (String segment : more) {
                if (segment.length() <= 0) continue;
                if (sb.length() > 0) {
                    sb.append('/');
                }
                sb.append(segment);
            }
            path = sb.toString();
        }
        return new UnixPath(this, path);
    }

    @Override
    public PathMatcher getPathMatcher(String syntaxAndInput) {
        String expr;
        int pos = syntaxAndInput.indexOf(58);
        if (pos <= 0 || pos == syntaxAndInput.length()) {
            throw new IllegalArgumentException();
        }
        String syntax = syntaxAndInput.substring(0, pos);
        String input = syntaxAndInput.substring(pos + 1);
        if (syntax.equals(GLOB_SYNTAX)) {
            expr = Globs.toUnixRegexPattern(input);
        } else if (syntax.equals(REGEX_SYNTAX)) {
            expr = input;
        } else {
            throw new UnsupportedOperationException("Syntax '" + syntax + "' not recognized");
        }
        final Pattern pattern = this.compilePathMatchPattern(expr);
        return new PathMatcher(){

            @Override
            public boolean matches(Path path) {
                return pattern.matcher(path.toString()).matches();
            }
        };
    }

    @Override
    public final UserPrincipalLookupService getUserPrincipalLookupService() {
        return LookupService.instance;
    }

    Pattern compilePathMatchPattern(String expr) {
        return Pattern.compile(expr);
    }

    char[] normalizeNativePath(char[] path) {
        return path;
    }

    String normalizeJavaPath(String path) {
        return path;
    }

    private static class LookupService {
        static final UserPrincipalLookupService instance = new UserPrincipalLookupService(){

            @Override
            public UserPrincipal lookupPrincipalByName(String name) throws IOException {
                return UnixUserPrincipals.lookupUser(name);
            }

            @Override
            public GroupPrincipal lookupPrincipalByGroupName(String group) throws IOException {
                return UnixUserPrincipals.lookupGroup(group);
            }
        };

        private LookupService() {
        }
    }

    private class FileStoreIterator
    implements Iterator<FileStore> {
        private final Iterator<UnixMountEntry> entries;
        private FileStore next;

        FileStoreIterator() {
            this.entries = UnixFileSystem.this.getMountEntries().iterator();
        }

        private FileStore readNext() {
            assert (Thread.holdsLock(this));
            while (this.entries.hasNext()) {
                UnixMountEntry entry = this.entries.next();
                if (entry.isIgnored()) continue;
                SecurityManager sm = System.getSecurityManager();
                if (sm != null) {
                    try {
                        sm.checkRead(Util.toString(entry.dir()));
                    }
                    catch (SecurityException x) {
                        continue;
                    }
                }
                try {
                    return UnixFileSystem.this.getFileStore(entry);
                }
                catch (IOException iOException) {
                    continue;
                }
                break;
            }
            return null;
        }

        @Override
        public synchronized boolean hasNext() {
            if (this.next != null) {
                return true;
            }
            this.next = this.readNext();
            return this.next != null;
        }

        @Override
        public synchronized FileStore next() {
            if (this.next == null) {
                this.next = this.readNext();
            }
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            FileStore result = this.next;
            this.next = null;
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

