/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.util;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.DisplayMode;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.FilteredImageSource;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.stream.Stream;
import javax.swing.GrayFilter;
import javax.swing.ImageIcon;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.plaf.FontUIResource;
import org.openstreetmap.josm.data.preferences.StrokeProperty;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.widgets.AbstractFileChooser;
import org.openstreetmap.josm.gui.widgets.HtmlPanel;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.ColorHelper;
import org.openstreetmap.josm.tools.Destroyable;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageOverlay;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.LanguageInfo;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.bugreport.BugReport;

public final class GuiHelper {
    private static final String[] JAVA_INTERNAL_MESSAGE_KEYS = new String[]{"FileChooser.detailsViewActionLabelText", "FileChooser.detailsViewButtonAccessibleName", "FileChooser.detailsViewButtonToolTipText", "FileChooser.fileAttrHeaderText", "FileChooser.fileDateHeaderText", "FileChooser.fileNameHeaderText", "FileChooser.fileNameLabelText", "FileChooser.fileSizeHeaderText", "FileChooser.fileTypeHeaderText", "FileChooser.filesOfTypeLabelText", "FileChooser.homeFolderAccessibleName", "FileChooser.homeFolderToolTipText", "FileChooser.listViewActionLabelText", "FileChooser.listViewButtonAccessibleName", "FileChooser.listViewButtonToolTipText", "FileChooser.lookInLabelText", "FileChooser.newFolderAccessibleName", "FileChooser.newFolderActionLabelText", "FileChooser.newFolderToolTipText", "FileChooser.refreshActionLabelText", "FileChooser.saveInLabelText", "FileChooser.upFolderAccessibleName", "FileChooser.upFolderToolTipText", "FileChooser.viewMenuLabelText", "FileChooser.acceptAllFileFilterText", "FileChooser.cancelButtonText", "FileChooser.cancelButtonToolTipText", "FileChooser.deleteFileButtonText", "FileChooser.filesLabelText", "FileChooser.filterLabelText", "FileChooser.foldersLabelText", "FileChooser.newFolderButtonText", "FileChooser.newFolderDialogText", "FileChooser.openButtonText", "FileChooser.openButtonToolTipText", "FileChooser.openDialogTitleText", "FileChooser.pathLabelText", "FileChooser.renameFileButtonText", "FileChooser.renameFileDialogText", "FileChooser.renameFileErrorText", "FileChooser.renameFileErrorTitle", "FileChooser.saveButtonText", "FileChooser.saveButtonToolTipText", "FileChooser.saveDialogTitleText", "FileChooser.enterFileNameLabelText", "FileChooser.helpButtonText", "FileChooser.helpButtonToolTipText", "FileChooser.updateButtonText", "FileChooser.updateButtonToolTipText", "GTKColorChooserPanel.blueText", "GTKColorChooserPanel.colorNameText", "GTKColorChooserPanel.greenText", "GTKColorChooserPanel.hueText", "GTKColorChooserPanel.nameText", "GTKColorChooserPanel.redText", "GTKColorChooserPanel.saturationText", "GTKColorChooserPanel.valueText", "OptionPane.okButtonText", "OptionPane.yesButtonText", "OptionPane.noButtonText", "OptionPane.cancelButtonText"};

    private GuiHelper() {
    }

    public static void setEnabledRec(Container root, boolean enabled) {
        Component[] children;
        root.setEnabled(enabled);
        for (Component child : children = root.getComponents()) {
            if (child instanceof Container) {
                GuiHelper.setEnabledRec((Container)child, enabled);
                continue;
            }
            child.setEnabled(enabled);
        }
    }

    public static void executeByMainWorkerInEDT(Runnable task) {
        MainApplication.worker.submit(() -> GuiHelper.runInEDTAndWait(task));
    }

    public static void runInEDT(Runnable task) {
        if (SwingUtilities.isEventDispatchThread()) {
            task.run();
        } else {
            SwingUtilities.invokeLater(task);
        }
    }

    static void handleEDTException(Throwable t) {
        Logging.logWithStackTrace(Logging.LEVEL_ERROR, t, "Exception raised in EDT", new Object[0]);
        BugReport.addSuppressedException(t);
    }

    public static void runInEDTAndWait(Runnable task) {
        if (SwingUtilities.isEventDispatchThread()) {
            task.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(task);
            }
            catch (InterruptedException | InvocationTargetException e) {
                GuiHelper.handleEDTException(e);
            }
        }
    }

    public static void runInEDTAndWaitWithException(Runnable task) {
        if (SwingUtilities.isEventDispatchThread()) {
            task.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(task);
            }
            catch (InterruptedException | InvocationTargetException e) {
                throw BugReport.intercept(e).put("task", task);
            }
        }
    }

    public static <V> V runInEDTAndWaitAndReturn(Callable<V> callable) {
        if (SwingUtilities.isEventDispatchThread()) {
            try {
                return callable.call();
            }
            catch (Exception e) {
                GuiHelper.handleEDTException(e);
                return null;
            }
        }
        FutureTask<V> task = new FutureTask<V>(callable);
        SwingUtilities.invokeLater(task);
        try {
            return task.get();
        }
        catch (InterruptedException | ExecutionException e) {
            GuiHelper.handleEDTException(e);
            return null;
        }
    }

    public static void assertCallFromEdt() {
        if (!SwingUtilities.isEventDispatchThread() && !GraphicsEnvironment.isHeadless()) {
            throw new IllegalStateException("Needs to be called from the EDT thread, not from " + Thread.currentThread().getName());
        }
    }

    public static boolean warnUser(String title, String content, ImageIcon baseActionIcon, String continueToolTip) {
        ExtendedDialog dlg = new ExtendedDialog((Component)MainApplication.getMainFrame(), title, I18n.tr("Cancel", new Object[0]), I18n.tr("Continue", new Object[0]));
        dlg.setContent(content);
        dlg.setButtonIcons(new ImageProvider("cancel").setMaxSize(ImageProvider.ImageSizes.LARGEICON).get(), new ImageProvider("upload").setMaxSize(ImageProvider.ImageSizes.LARGEICON).addOverlay(new ImageOverlay(new ImageProvider("warning-small"), 0.5, 0.5, 1.0, 1.0)).get());
        dlg.setToolTipTexts(I18n.tr("Cancel", new Object[0]), continueToolTip);
        dlg.setIcon(2);
        dlg.setCancelButton(1);
        return dlg.showDialog().getValue() != 2;
    }

    public static void notifyUserHtmlError(Component parent, String title, String message, String html) {
        JPanel p = new JPanel(new GridBagLayout());
        p.add((Component)new JLabel(message), GBC.eol());
        p.add((Component)new JLabel(I18n.tr("Received error page:", new Object[0])), GBC.eol());
        JScrollPane sp = GuiHelper.embedInVerticalScrollPane(new HtmlPanel(html));
        sp.setPreferredSize(new Dimension(640, 240));
        p.add((Component)sp, GBC.eol().fill(1));
        ExtendedDialog ed = new ExtendedDialog(parent, title, I18n.tr("OK", new Object[0]));
        ed.setButtonIcons("ok");
        ed.setContent(p);
        ed.showDialog();
    }

    public static Image getDisabledImage(Image image) {
        return Toolkit.getDefaultToolkit().createImage(new FilteredImageSource(image.getSource(), new GrayFilter(true, 20)));
    }

    public static ImageIcon getDisabledIcon(ImageIcon icon) {
        return new ImageIcon(GuiHelper.getDisabledImage(icon.getImage()));
    }

    public static Component prepareResizeableOptionPane(Component pane, Dimension minDimension) {
        if (pane != null) {
            pane.addHierarchyListener(e -> {
                Dialog dialog;
                Window window = SwingUtilities.getWindowAncestor(pane);
                if (window instanceof Dialog && !(dialog = (Dialog)window).isResizable()) {
                    dialog.setResizable(true);
                    if (minDimension != null) {
                        dialog.setMinimumSize(minDimension);
                    }
                }
            });
        }
        return pane;
    }

    public static Timer scheduleTimer(int initialDelay, ActionListener actionListener, boolean repeats) {
        Timer timer = new Timer(initialDelay, actionListener);
        timer.setRepeats(repeats);
        timer.start();
        return timer;
    }

    public static Stroke getCustomizedStroke(String code) {
        return StrokeProperty.getFromString(code);
    }

    public static Font getMonospacedFont(JComponent component) {
        if ("km".equals(LanguageInfo.getJOSMLocaleCode())) {
            return component.getFont();
        }
        return new Font("Monospaced", component.getFont().getStyle(), component.getFont().getSize());
    }

    public static Font getTitleFont() {
        return new Font("SansSerif", 1, 23);
    }

    public static JScrollPane embedInVerticalScrollPane(Component panel) {
        return new JScrollPane(panel, 20, 31);
    }

    public static JScrollPane setDefaultIncrement(JScrollPane sp) {
        if (sp.getViewport().getView() instanceof Scrollable) {
            throw new IllegalArgumentException();
        }
        sp.getVerticalScrollBar().setUnitIncrement(10);
        sp.getHorizontalScrollBar().setUnitIncrement(10);
        return sp;
    }

    public static void setUIFont(String name) {
        CheckParameterUtil.ensureParameterNotNull(name, "name");
        Logging.info("Setting " + name + " as the default UI font");
        Enumeration keys = UIManager.getDefaults().keys();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            Object value = UIManager.get(key);
            if (!(value instanceof FontUIResource)) continue;
            FontUIResource fui = (FontUIResource)value;
            UIManager.put(key, new FontUIResource(name, fui.getStyle(), fui.getSize()));
        }
    }

    public static void setBackgroundReadable(JComponent c, Color background) {
        c.setBackground(background);
        c.setForeground(ColorHelper.getForegroundColor(background));
    }

    public static Dimension getScreenSize() {
        return GraphicsEnvironment.isHeadless() ? new Dimension(800, 600) : Toolkit.getDefaultToolkit().getScreenSize();
    }

    public static Dimension getMaximumScreenSize() {
        if (GraphicsEnvironment.isHeadless()) {
            return new Dimension(800, 600);
        }
        int height = 0;
        int width = 0;
        for (GraphicsDevice gd : GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices()) {
            DisplayMode dm = gd.getDisplayMode();
            height = Math.max(height, dm.getHeight());
            width = Math.max(width, dm.getWidth());
        }
        if (height == 0 || width == 0) {
            return new Dimension(800, 600);
        }
        return new Dimension(width, height);
    }

    public static Window getWindowAncestorFor(EventObject e) {
        Object source;
        if (e != null && (source = e.getSource()) instanceof Component) {
            Window ancestor = SwingUtilities.getWindowAncestor((Component)source);
            if (ancestor != null) {
                return ancestor;
            }
            Container parent = ((Component)source).getParent();
            if (parent instanceof JPopupMenu) {
                Component invoker = ((JPopupMenu)parent).getInvoker();
                return SwingUtilities.getWindowAncestor(invoker);
            }
        }
        return null;
    }

    public static void extendTooltipDelay(Component c) {
        GuiHelper.extendTooltipDelay(c, 60000);
    }

    public static void extendTooltipDelay(Component c, final int delay) {
        final int defaultDismissTimeout = ToolTipManager.sharedInstance().getDismissDelay();
        c.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent me) {
                ToolTipManager.sharedInstance().setDismissDelay(delay);
            }

            @Override
            public void mouseExited(MouseEvent me) {
                ToolTipManager.sharedInstance().setDismissDelay(defaultDismissTimeout);
            }
        });
    }

    public static Frame getFrameForComponent(Component parentComponent) {
        try {
            return JOptionPane.getFrameForComponent(parentComponent);
        }
        catch (HeadlessException e) {
            Logging.debug(e);
            return null;
        }
    }

    public static void translateJavaInternalMessages() {
        Locale l = Locale.getDefault();
        AbstractFileChooser.setDefaultLocale(l);
        JFileChooser.setDefaultLocale(l);
        JColorChooser.setDefaultLocale(l);
        for (String key : JAVA_INTERNAL_MESSAGE_KEYS) {
            String us = UIManager.getString((Object)key, Locale.US);
            String loc = UIManager.getString((Object)key, l);
            if (us == null || !us.equals(loc)) continue;
            UIManager.put(key, I18n.tr(us, new Object[0]));
        }
    }

    public static void setupLanguageFonts() {
        if ("km".equals(LanguageInfo.getJOSMLocaleCode())) {
            List<String> fonts = Arrays.asList(GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames());
            Stream.of("Khmer UI", "DaunPenh", "MoolBoran").filter(fonts::contains).findFirst().ifPresent(GuiHelper::setUIFont);
        }
    }

    public static void destroyComponents(Component component, boolean destroyItself) {
        if (component instanceof Container) {
            for (Component c : ((Container)component).getComponents()) {
                GuiHelper.destroyComponents(c, true);
            }
        }
        if (destroyItself && component instanceof Destroyable) {
            ((Destroyable)((Object)component)).destroy();
        }
    }
}

