/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.cmd;

import java.util.ArrayList;
import tim.prune.cmd.Command;
import tim.prune.cmd.InsertMediaCmd;
import tim.prune.cmd.MediaInsertion;
import tim.prune.data.MediaObject;
import tim.prune.data.TrackInfo;

public class RemoveCorrelatedMediaCmd
extends Command {
    public RemoveCorrelatedMediaCmd() {
        super(null);
    }

    @Override
    protected boolean executeCommand(TrackInfo trackInfo) {
        trackInfo.getPhotoList().removeCorrelatedMedia();
        trackInfo.getAudioList().removeCorrelatedMedia();
        return true;
    }

    @Override
    protected Command makeInverse(TrackInfo trackInfo) {
        MediaObject mediaObject;
        ArrayList<MediaInsertion> arrayList = new ArrayList<MediaInsertion>();
        int n = 0;
        while (n < trackInfo.getPhotoList().getCount()) {
            mediaObject = trackInfo.getPhotoList().get(n);
            if (mediaObject.getDataPoint() != null) {
                arrayList.add(new MediaInsertion(mediaObject, n));
            }
            ++n;
        }
        n = 0;
        while (n < trackInfo.getAudioList().getCount()) {
            mediaObject = trackInfo.getAudioList().get(n);
            if (mediaObject.getDataPoint() != null) {
                arrayList.add(new MediaInsertion(mediaObject, n));
            }
            ++n;
        }
        return new InsertMediaCmd(this, arrayList);
    }

    @Override
    public int getUpdateFlags() {
        return 16;
    }
}

