/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.cli;

import java.io.IOException;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import org.netbeans.api.autoupdate.InstallSupport;
import org.netbeans.api.autoupdate.OperationContainer;
import org.netbeans.api.autoupdate.OperationException;
import org.netbeans.api.autoupdate.OperationSupport;
import org.netbeans.api.autoupdate.UpdateElement;
import org.netbeans.api.autoupdate.UpdateManager;
import org.netbeans.api.autoupdate.UpdateUnit;
import org.netbeans.api.autoupdate.UpdateUnitProvider;
import org.netbeans.api.autoupdate.UpdateUnitProviderFactory;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.sendopts.CommandException;
import org.netbeans.modules.autoupdate.cli.Bundle;
import org.netbeans.modules.autoupdate.cli.CodeNameMatcher;
import org.netbeans.modules.autoupdate.cli.PrintTable;
import org.netbeans.modules.autoupdate.cli.Status;
import org.netbeans.modules.progress.spi.Controller;
import org.netbeans.modules.progress.spi.InternalHandle;
import org.netbeans.modules.progress.spi.ProgressEvent;
import org.netbeans.modules.progress.spi.ProgressUIWorker;
import org.netbeans.spi.sendopts.Env;
import org.netbeans.spi.sendopts.Option;
import org.netbeans.spi.sendopts.OptionGroups;
import org.netbeans.spi.sendopts.OptionProcessor;
import org.openide.util.NbPreferences;

public class ModuleOptions
extends OptionProcessor {
    private static final Logger LOG = Logger.getLogger(ModuleOptions.class.getName());
    private Option list;
    private Option install;
    private Option disable;
    private Option enable;
    private Option update;
    private Option refresh;
    private Option updateAll;
    private Option both;
    private Option extraUC;
    private Option directDisable;
    private final Collection<UpdateUnitProvider> ownUUP = new HashSet<UpdateUnitProvider>();
    private static final String PLUGIN_MANAGER_FIRST_CLASS_MODULES = "plugin.manager.first.class.modules";

    private Option init() {
        if (this.both != null) {
            return this.both;
        }
        String b = "org.netbeans.modules.autoupdate.cli.Bundle";
        this.list = Option.shortDescription((Option)Option.withoutArgument((char)'\uffff', (String)"list"), (String)b, (String)"MSG_ListModules");
        this.install = Option.shortDescription((Option)Option.additionalArguments((char)'\uffff', (String)"install"), (String)b, (String)"MSG_InstallModules");
        this.disable = Option.shortDescription((Option)Option.additionalArguments((char)'\uffff', (String)"disable"), (String)b, (String)"MSG_DisableModules");
        this.enable = Option.shortDescription((Option)Option.additionalArguments((char)'\uffff', (String)"enable"), (String)b, (String)"MSG_EnableModules");
        this.update = Option.shortDescription((Option)Option.additionalArguments((char)'\uffff', (String)"update"), (String)b, (String)"MSG_UpdateModules");
        this.refresh = Option.shortDescription((Option)Option.withoutArgument((char)'\uffff', (String)"refresh"), (String)b, (String)"MSG_Refresh");
        this.updateAll = Option.shortDescription((Option)Option.withoutArgument((char)'\uffff', (String)"update-all"), (String)b, (String)"MSG_UpdateAll");
        this.extraUC = Option.shortDescription((Option)Option.requiredArgument((char)'\uffff', (String)"extra-uc"), (String)b, (String)"MSG_ExtraUC");
        this.directDisable = Option.shortDescription((Option)Option.additionalArguments((char)'\uffff', (String)"direct-disable"), (String)b, (String)"MSG_DirectDisableModule");
        Option oper = OptionGroups.someOf((Option[])new Option[]{this.refresh, this.list, this.install, this.disable, this.enable, this.update, this.updateAll, this.extraUC, this.directDisable});
        Option modules = Option.withoutArgument((char)'\uffff', (String)"modules");
        this.both = OptionGroups.allOf((Option[])new Option[]{modules, oper});
        return this.both;
    }

    public Set<Option> getOptions() {
        return Collections.singleton(this.init());
    }

    private void refresh(Env env) throws CommandException {
        for (UpdateUnitProvider p : UpdateUnitProviderFactory.getDefault().getUpdateUnitProviders(true)) {
            try {
                env.getOutputStream().println(Bundle.MSG_RefreshingUpdateCenter(p.getDisplayName()));
                p.refresh(null, true);
            }
            catch (IOException ex) {
                throw (CommandException)new CommandException(31, ex.getMessage()).initCause((Throwable)ex);
            }
        }
    }

    private void listAllModules(PrintStream out) throws IOException {
        List modules = UpdateManager.getDefault().getUpdateUnits();
        PrintTable table = new PrintTable(Bundle.MSG_ListHeader_CodeName(), Bundle.MSG_ListHeader_Version(), Bundle.MSG_ListHeader_State());
        table.setLimits(50, -1, -1);
        for (UpdateUnit uu : modules) {
            table.addRow(Status.toArray(uu));
        }
        StringBuilder sb = new StringBuilder();
        table.write(sb);
        out.print(sb.toString());
        out.flush();
    }

    private static <T extends Throwable> T initCause(T t, Throwable cause) {
        t.initCause(cause);
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void process(Env env, Map<Option, String[]> optionValues) throws CommandException {
        try {
            try {
                if (optionValues.containsKey(this.extraUC)) {
                    this.extraUC(env, optionValues.get(this.extraUC));
                }
                if (optionValues.containsKey(this.refresh)) {
                    this.refresh(env);
                }
                if (optionValues.containsKey(this.list)) {
                    this.listAllModules(env.getOutputStream());
                }
                if (optionValues.containsKey(this.install)) {
                    this.install(env, optionValues.get(this.install));
                }
                if (optionValues.containsKey(this.disable)) {
                    this.changeModuleState(env, optionValues.get(this.disable), false, false);
                }
                if (optionValues.containsKey(this.enable)) {
                    this.changeModuleState(env, optionValues.get(this.enable), true, false);
                }
                if (optionValues.containsKey(this.directDisable)) {
                    this.changeModuleState(env, optionValues.get(this.directDisable), false, true);
                }
            }
            catch (IOException | InterruptedException | OperationException ex) {
                throw ModuleOptions.initCause(new CommandException(4), ex);
            }
            if (optionValues.containsKey(this.updateAll)) {
                this.updateAll(env);
            }
            if (optionValues.containsKey(this.update)) {
                this.updateModules(env, optionValues.get(this.update));
            }
        }
        finally {
            for (UpdateUnitProvider uuc : this.ownUUP) {
                UpdateUnitProviderFactory.getDefault().remove(uuc);
            }
        }
    }

    private void changeModuleState(Env env, String[] cnbs, boolean enable, boolean direct) throws IOException, CommandException, InterruptedException, OperationException {
        CodeNameMatcher cnm = CodeNameMatcher.create(env, cnbs);
        List units = UpdateManager.getDefault().getUpdateUnits();
        OperationContainer operate = enable ? OperationContainer.createForEnable() : (direct ? OperationContainer.createForDirectDisable() : OperationContainer.createForDisable());
        StringBuilder sb = new StringBuilder();
        boolean found = false;
        for (UpdateUnit updateUnit : units) {
            String codeName = updateUnit.getCodeName();
            if (!cnm.matches(codeName)) continue;
            UpdateElement elem = updateUnit.getInstalled();
            if (elem != null) {
                found = true;
                if (elem.isEnabled() == enable) continue;
                operate.add(updateUnit, elem);
                continue;
            }
            sb.append("\n").append(Bundle.MSG_FoundButNotInstalled(codeName));
        }
        if (!found) {
            sb.insert(0, Bundle.MSG_CannotFindAnyPattern(cnm));
            throw new CommandException(55, sb.toString());
        }
        OperationSupport support = (OperationSupport)operate.getSupport();
        if (support != null) {
            support.doOperation(null);
        }
    }

    private void updateModules(Env env, String ... pattern) throws CommandException {
        InstallSupport support;
        Set requiredElements;
        OperationContainer.OperationInfo info;
        UpdateElement ue;
        List updates;
        if (!this.initialized()) {
            this.refresh(env);
        }
        CodeNameMatcher cnm = CodeNameMatcher.create(env, pattern);
        List units = UpdateManager.getDefault().getUpdateUnits(new UpdateManager.TYPE[]{UpdateManager.TYPE.MODULE});
        Collection<String> firstClass = this.getFirstClassModules();
        boolean firstClassHasUpdates = false;
        OperationContainer operate = OperationContainer.createForUpdate();
        if (!firstClass.isEmpty() && pattern.length == 0) {
            for (UpdateUnit uu : units) {
                if (uu.getInstalled() == null || (updates = uu.getAvailableUpdates()).isEmpty() || !firstClass.contains(uu.getCodeName())) continue;
                ue = (UpdateElement)updates.get(0);
                env.getOutputStream().println(Bundle.MSG_Update(uu.getCodeName(), uu.getInstalled().getSpecificationVersion(), ue.getSpecificationVersion()));
                if (!operate.canBeAdded(uu, ue)) continue;
                LOG.log(Level.FINE, "  ... update {0} -> {1}", new Object[]{uu.getInstalled(), ue});
                firstClassHasUpdates = true;
                info = operate.add(ue);
                if (info == null) continue;
                requiredElements = info.getRequiredElements();
                LOG.log(Level.FINE, "      ... add required elements: {0}", requiredElements);
                operate.add((Collection)requiredElements);
            }
        }
        if (!firstClassHasUpdates) {
            for (UpdateUnit uu : units) {
                if (uu.getInstalled() == null || (updates = uu.getAvailableUpdates()).isEmpty() || pattern.length > 0 && !cnm.matches(uu.getCodeName())) continue;
                ue = (UpdateElement)updates.get(0);
                env.getOutputStream().println(Bundle.MSG_Update(uu.getCodeName(), uu.getInstalled().getSpecificationVersion(), ue.getSpecificationVersion()));
                if (!operate.canBeAdded(uu, ue)) continue;
                LOG.log(Level.FINE, "  ... update {0} -> {1}", new Object[]{uu.getInstalled(), ue});
                info = operate.add(ue);
                if (info == null) continue;
                requiredElements = info.getRequiredElements();
                LOG.log(Level.FINE, "      ... add required elements: {0}", requiredElements);
                operate.add((Collection)requiredElements);
            }
        }
        if ((support = (InstallSupport)operate.getSupport()) == null) {
            env.getOutputStream().println(cnm.isEmpty() ? Bundle.MSG_UpdateNotFound() : Bundle.MSG_UpdateNoMatchPattern(cnm));
            env.getOutputStream().println("updates=0");
            return;
        }
        env.getOutputStream().println("updates=" + operate.listAll().size());
        ProgressHandle downloadHandle = new CLIInternalHandle("downloading-updates", env).createProgressHandle();
        downloadHandle.setInitialDelay(0);
        try {
            InstallSupport.Validator res1 = support.doDownload(downloadHandle, null, false);
            InstallSupport.Installer res2 = support.doValidate(res1, null);
            ProgressHandle installHandle = new CLIInternalHandle("installing-updates", env).createProgressHandle();
            installHandle.setInitialDelay(0);
            OperationSupport.Restarter res3 = support.doInstall(res2, installHandle);
            if (res3 != null) {
                support.doRestart(res3, null);
            }
        }
        catch (OperationException ex) {
            try {
                support.doCancel();
                throw (CommandException)new CommandException(33, ex.getMessage()).initCause((Throwable)ex);
            }
            catch (OperationException ex1) {
                throw (CommandException)new CommandException(33, ex1.getMessage()).initCause((Throwable)ex1);
            }
        }
    }

    private void install(Env env, String ... pattern) throws CommandException {
        if (!this.initialized()) {
            this.refresh(env);
        }
        CodeNameMatcher cnm = CodeNameMatcher.create(env, pattern);
        List units = UpdateManager.getDefault().getUpdateUnits();
        OperationContainer operate = OperationContainer.createForInstall();
        boolean found = false;
        StringBuilder sb = new StringBuilder();
        for (UpdateUnit uu : units) {
            if (!cnm.matches(uu.getCodeName())) continue;
            found = true;
            if (uu.getInstalled() != null) {
                sb.append(Bundle.MSG_AlreadyPresent(uu.getCodeName())).append("\n");
                continue;
            }
            if (uu.getAvailableUpdates().isEmpty()) continue;
            UpdateElement ue = (UpdateElement)uu.getAvailableUpdates().get(0);
            env.getOutputStream().println(Bundle.MSG_Installing(uu.getCodeName(), ue.getSpecificationVersion()));
            operate.add(ue);
        }
        InstallSupport support = (InstallSupport)operate.getSupport();
        if (support == null) {
            if (!found) {
                sb.insert(0, Bundle.MSG_CannotFindAnyPattern(cnm));
                throw new CommandException(55, sb.toString());
            }
            env.getOutputStream().print(sb.toString());
            return;
        }
        try {
            env.getOutputStream().println("modules=" + operate.listAll().size());
            ProgressHandle downloadHandle = new CLIInternalHandle("downloading-modules", env).createProgressHandle();
            downloadHandle.setInitialDelay(0);
            InstallSupport.Validator res1 = support.doDownload(downloadHandle, null, false);
            InstallSupport.Installer res2 = support.doValidate(res1, null);
            ProgressHandle installHandle = new CLIInternalHandle("installing-modules", env).createProgressHandle();
            installHandle.setInitialDelay(0);
            OperationSupport.Restarter res3 = support.doInstall(res2, installHandle);
            if (res3 != null) {
                support.doRestart(res3, null);
            }
        }
        catch (OperationException ex) {
            if (OperationException.ERROR_TYPE.INSTALL.equals((Object)ex.getErrorType())) {
                env.getErrorStream().println(ex.getLocalizedMessage());
                throw (CommandException)new CommandException(34, ex.getMessage()).initCause((Throwable)ex);
            }
            try {
                support.doCancel();
                throw (CommandException)new CommandException(32, ex.getMessage()).initCause((Throwable)ex);
            }
            catch (OperationException ex1) {
                throw (CommandException)new CommandException(32, ex1.getMessage()).initCause((Throwable)ex1);
            }
        }
    }

    private void updateAll(Env env) throws CommandException {
        this.updateModules(env, new String[0]);
    }

    private void extraUC(Env env, String ... urls) throws CommandException {
        ArrayList<URL> url2UC = new ArrayList<URL>(urls.length);
        for (String spec : urls) {
            try {
                url2UC.add(new URL(spec));
            }
            catch (MalformedURLException ex) {
                throw ModuleOptions.initCause(new CommandException(4), ex);
            }
        }
        for (URL url : url2UC) {
            this.ownUUP.add(UpdateUnitProviderFactory.getDefault().create(Long.toString(System.currentTimeMillis()), url.toExternalForm(), url));
        }
        this.refresh(env);
    }

    private boolean initialized() {
        Preferences pref = NbPreferences.root().node("/org/netbeans/modules/autoupdate");
        long last = pref.getLong("lastCheckTime", -1L);
        return last != -1L;
    }

    private Collection<String> getFirstClassModules() {
        Preferences p = NbPreferences.root().node("/org/netbeans/modules/autoupdate");
        String names = p.get(PLUGIN_MANAGER_FIRST_CLASS_MODULES, "");
        HashSet<String> res = new HashSet<String>();
        StringTokenizer en = new StringTokenizer(names, ",");
        while (en.hasMoreTokens()) {
            res.add(en.nextToken().trim());
        }
        return res;
    }

    private class CLIProgressUIWorker
    implements ProgressUIWorker {
        private final Env env;

        public CLIProgressUIWorker(Env env) {
            this.env = env;
        }

        public void processProgressEvent(ProgressEvent event) {
            this.printEvent(event);
        }

        public void processSelectedProgressEvent(ProgressEvent event) {
            this.printEvent(event);
        }

        private void printEvent(ProgressEvent event) {
            String msg = event.getMessage();
            if (msg != null && msg.length() > 0) {
                this.env.getOutputStream().println(msg);
            }
        }
    }

    private class CLIInternalHandle
    extends InternalHandle {
        public CLIInternalHandle(String displayName, Env env) {
            super(displayName, null, false);
            this.setController(new Controller((ProgressUIWorker)new CLIProgressUIWorker(env)));
        }
    }
}

