/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.webresources;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.apache.catalina.WebResource;
import org.apache.catalina.WebResourceRoot;
import org.apache.catalina.util.ResourceSet;
import org.apache.catalina.webresources.AbstractResourceSet;
import org.apache.catalina.webresources.EmptyResource;
import org.apache.catalina.webresources.JarContents;
import org.apache.catalina.webresources.JarResourceRoot;

public abstract class AbstractArchiveResourceSet
extends AbstractResourceSet {
    private URL baseUrl;
    private String baseUrlString;
    private JarFile archive = null;
    protected Map<String, JarEntry> archiveEntries = null;
    protected final Object archiveLock = new Object();
    private long archiveUseCount = 0L;
    private JarContents jarContents;
    private boolean retainBloomFilterForArchives = false;

    protected final void setBaseUrl(URL uRL) {
        this.baseUrl = uRL;
        this.baseUrlString = uRL == null ? null : uRL.toString();
    }

    @Override
    public final URL getBaseUrl() {
        return this.baseUrl;
    }

    protected final String getBaseUrlString() {
        return this.baseUrlString;
    }

    @Override
    public final String[] list(String object) {
        this.checkPath((String)object);
        String string = this.getWebAppMount();
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.isPathMounted((String)object, string)) {
            Object object2 = this.getInternalPath() + ((String)object).substring(string.length());
            if (!((String)object2).isEmpty() && ((String)object2).charAt(0) == '/') {
                object2 = ((String)object2).substring(1);
            }
            for (String string2 : this.getArchiveEntries(false).keySet()) {
                if (string2.length() <= ((String)object2).length() || !string2.startsWith((String)object2) || (string2 = string2.charAt(string2.length() - 1) == '/' ? string2.substring(((String)object2).length(), string2.length() - 1) : string2.substring(((String)object2).length())).isEmpty()) continue;
                if (string2.charAt(0) == '/') {
                    string2 = string2.substring(1);
                }
                if (string2.isEmpty() || string2.lastIndexOf(47) != -1) continue;
                arrayList.add(string2);
            }
        } else {
            if (!((String)object).endsWith("/")) {
                object = (String)object + "/";
            }
            if (string.startsWith((String)object)) {
                int n = string.indexOf(47, ((String)object).length());
                if (n == -1) {
                    return new String[]{string.substring(((String)object).length())};
                }
                return new String[]{string.substring(((String)object).length(), n)};
            }
        }
        return arrayList.toArray(new String[0]);
    }

    @Override
    public final Set<String> listWebAppPaths(String object) {
        this.checkPath((String)object);
        String string = this.getWebAppMount();
        ResourceSet<String> resourceSet = new ResourceSet<String>();
        if (this.isPathMounted((String)object, string)) {
            Object object2 = this.getInternalPath() + ((String)object).substring(string.length());
            if (!((String)object2).isEmpty()) {
                if (((String)object2).charAt(((String)object2).length() - 1) != '/') {
                    object2 = ((String)object2).substring(1) + "/";
                }
                if (((String)object2).charAt(0) == '/') {
                    object2 = ((String)object2).substring(1);
                }
            }
            for (String string2 : this.getArchiveEntries(false).keySet()) {
                if (string2.length() <= ((String)object2).length() || !string2.startsWith((String)object2)) continue;
                int n = string2.indexOf(47, ((String)object2).length());
                if (n != -1 && n != string2.length() - 1) {
                    string2 = string2.substring(0, n + 1);
                }
                resourceSet.add(string + "/" + string2.substring(this.getInternalPath().length()));
            }
        } else {
            if (!((String)object).endsWith("/")) {
                object = (String)object + "/";
            }
            if (string.startsWith((String)object)) {
                int n = string.indexOf(47, ((String)object).length());
                if (n == -1) {
                    resourceSet.add(string + "/");
                } else {
                    resourceSet.add(string.substring(0, n + 1));
                }
            }
        }
        resourceSet.setLocked(true);
        return resourceSet;
    }

    protected abstract Map<String, JarEntry> getArchiveEntries(boolean var1);

    protected abstract JarEntry getArchiveEntry(String var1);

    @Override
    public final boolean mkdir(String string) {
        this.checkPath(string);
        return false;
    }

    @Override
    public final boolean write(String string, InputStream inputStream, boolean bl) {
        this.checkPath(string);
        if (inputStream == null) {
            throw new NullPointerException(sm.getString("dirResourceSet.writeNpe"));
        }
        return false;
    }

    @Override
    public final WebResource getResource(String object) {
        this.checkPath((String)object);
        String string = this.getWebAppMount();
        WebResourceRoot webResourceRoot = this.getRoot();
        if (this.jarContents != null && !this.jarContents.mightContainResource((String)(this.getInternalPath().isEmpty() ? object : this.getInternalPath() + (String)object), string)) {
            return new EmptyResource(webResourceRoot, (String)object);
        }
        if (this.isPathMounted((String)object, string)) {
            Object object2 = this.getInternalPath() + ((String)object).substring(string.length());
            if (!((String)object2).isEmpty() && ((String)object2).charAt(0) == '/') {
                object2 = ((String)object2).substring(1);
            }
            if (((String)object2).isEmpty()) {
                if (!((String)object).endsWith("/")) {
                    object = (String)object + "/";
                }
                return new JarResourceRoot(webResourceRoot, new File(this.getBase()), this.baseUrlString, (String)object);
            }
            JarEntry jarEntry = null;
            if (this.isMultiRelease()) {
                jarEntry = this.getArchiveEntry((String)object2);
            } else {
                Map<String, JarEntry> map = this.getArchiveEntries(true);
                if (((String)object2).charAt(((String)object2).length() - 1) != '/' && (jarEntry = map == null ? this.getArchiveEntry((String)object2 + "/") : map.get((String)object2 + "/")) != null) {
                    object = (String)object + "/";
                }
                if (jarEntry == null) {
                    jarEntry = map == null ? this.getArchiveEntry((String)object2) : map.get(object2);
                }
            }
            if (jarEntry == null) {
                return new EmptyResource(webResourceRoot, (String)object);
            }
            return this.createArchiveResource(jarEntry, (String)object, this.getManifest());
        }
        return new EmptyResource(webResourceRoot, (String)object);
    }

    protected abstract boolean isMultiRelease();

    protected abstract WebResource createArchiveResource(JarEntry var1, String var2, Manifest var3);

    @Override
    public final boolean isReadOnly() {
        return true;
    }

    @Override
    public void setReadOnly(boolean bl) {
        if (bl) {
            return;
        }
        throw new IllegalArgumentException(sm.getString("abstractArchiveResourceSet.setReadOnlyFalse"));
    }

    @Override
    public void setAllowLinking(boolean bl) {
    }

    @Override
    public boolean getAllowLinking() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JarFile openJarFile() throws IOException {
        Object object = this.archiveLock;
        synchronized (object) {
            if (this.archive == null) {
                this.archive = new JarFile(new File(this.getBase()), true, 1, Runtime.version());
                WebResourceRoot webResourceRoot = this.getRoot();
                if (webResourceRoot.getArchiveIndexStrategyEnum().getUsesBloom() || webResourceRoot.getContext() != null && webResourceRoot.getContext().getUseBloomFilterForArchives()) {
                    this.jarContents = new JarContents(this.archive);
                    this.retainBloomFilterForArchives = webResourceRoot.getArchiveIndexStrategyEnum().getRetain();
                }
            }
            ++this.archiveUseCount;
            return this.archive;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeJarFile() {
        Object object = this.archiveLock;
        synchronized (object) {
            --this.archiveUseCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void gc() {
        Object object = this.archiveLock;
        synchronized (object) {
            if (this.archive != null && this.archiveUseCount == 0L) {
                try {
                    this.archive.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.archive = null;
                this.archiveEntries = null;
                if (!this.retainBloomFilterForArchives) {
                    this.jarContents = null;
                }
            }
        }
    }
}

