/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.ui.components.configuration.configurators;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyDescriptor;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import net.sf.sdedit.icons.Icons;
import net.sf.sdedit.ui.components.configuration.Adjustable;
import net.sf.sdedit.ui.components.configuration.Bean;
import net.sf.sdedit.ui.components.configuration.Configurator;
import net.sf.sdedit.ui.components.configuration.DataObject;

public class KeyStrokeConfigurator<C extends DataObject>
extends Configurator<KeyStroke, C>
implements KeyListener,
FocusListener {
    private static final long serialVersionUID = -5757931457664748425L;
    private JTextField textField;
    private JLabel label;
    private JButton button;
    private Color bg;
    public static final KeyStroke NULL_KEYSTROKE = KeyStroke.getKeyStroke('#');

    public KeyStrokeConfigurator(Bean<C> bean, PropertyDescriptor property) {
        super(bean, property);
        this.label = new JLabel(property.getWriteMethod().getAnnotation(Adjustable.class).info());
        this.label.setPreferredSize(new Dimension(75, 1));
        this.label.setHorizontalTextPosition(4);
        this.label.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 3));
        this.setLayout(new BorderLayout());
        this.add((Component)this.label, "West");
        this.textField = new JTextField();
        this.add((Component)this.textField, "Center");
        this.textField.addKeyListener(this);
        this.button = new JButton(Icons.getIcon("eraser"));
        this.button.setOpaque(false);
        this.button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ActionEvent event = new ActionEvent(this, 1, NULL_KEYSTROKE.toString());
                KeyStrokeConfigurator.this.actionPerformed(event);
            }
        });
        this.button.setMargin(new Insets(1, 1, 1, 1));
        this.button.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
        this.add((Component)this.button, "East");
        this.textField.setEditable(false);
        this.textField.addFocusListener(this);
        this.bg = this.textField.getBackground();
    }

    @Override
    protected void _actionPerformed(ActionEvent evt) {
        KeyStroke keyStroke = KeyStroke.getKeyStroke(evt.getActionCommand());
        this.applyValue(keyStroke);
    }

    @Override
    protected void _setEnabled(boolean enabled) {
        this.textField.setEnabled(enabled);
        this.label.setEnabled(enabled);
        this.button.setEnabled(enabled);
    }

    @Override
    protected void refresh(KeyStroke value) {
        if (value == this.getNullValue()) {
            this.textField.setText("");
        } else {
            this.textField.setText(value.toString());
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
        ActionEvent event = new ActionEvent(this, 1, KeyStroke.getKeyStroke(e.getKeyCode(), e.getModifiers(), false).toString());
        this.actionPerformed(event);
    }

    @Override
    public synchronized void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void focusGained(FocusEvent e) {
        this.textField.setBackground(Color.WHITE);
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.textField.setBackground(this.bg);
    }

    @Override
    public void focus() {
        this.textField.requestFocusInWindow();
    }
}

