SELECT
  NULLIF(1, 1)
    AS ROUTINE_CATALOG,
  STRIP(SYSCAT.ROUTINES.ROUTINESCHEMA)
    AS ROUTINE_SCHEMA,
  STRIP(SYSCAT.ROUTINES.ROUTINENAME)
    AS ROUTINE_NAME,
  STRIP(SYSCAT.ROUTINES.SPECIFICNAME)
    AS SPECIFIC_NAME,
  CASE WHEN STRIP(SYSCAT.ROUTINES.ORIGIN) = 'E' THEN 'EXTERNAL' ELSE 'SQL' END
    AS ROUTINE_BODY,
  SYSCAT.ROUTINES.TEXT
    AS ROUTINE_DEFINITION
FROM
  SYSCAT.ROUTINES
ORDER BY
  SYSCAT.ROUTINES.ROUTINESCHEMA,
  SYSCAT.ROUTINES.ROUTINENAME
WITH UR  
