SELECT
  NULL AS CONSTRAINT_CATALOG,
  CONSTRAINTS.OWNER AS CONSTRAINT_SCHEMA,
  CONSTRAINTS.CONSTRAINT_NAME,
  CONSTRAINTS.TABLE_NAME,
  DBMS_METADATA.GET_DDL('CONSTRAINT', CONSTRAINTS.CONSTRAINT_NAME, CONSTRAINTS.OWNER) AS CONSTRAINT_DEFINITION,
  NULL AS REMARKS
FROM
  ${catalogscope}_CONSTRAINTS CONSTRAINTS
  INNER JOIN ${catalogscope}_USERS USERS
    ON CONSTRAINTS.OWNER = USERS.USERNAME
      AND USERS.ORACLE_MAINTAINED = 'N'
      AND NOT REGEXP_LIKE(USERS.USERNAME, '^APEX_[0-9]{6}$')
      AND NOT REGEXP_LIKE(USERS.USERNAME, '^FLOWS_[0-9]{5}$')
WHERE
  REGEXP_LIKE(CONSTRAINTS.OWNER, '${schema-inclusion-rule}')
  AND REGEXP_LIKE(CONSTRAINTS.OWNER || '.' || CONSTRAINTS.TABLE_NAME, '${table-inclusion-rule}')
  AND CONSTRAINTS.TABLE_NAME NOT LIKE 'BIN$%'
  AND NOT REGEXP_LIKE(CONSTRAINTS.TABLE_NAME, '^(SYS_IOT|MDOS|MDRS|MDRT|MDOT|MDXT)_.*$')
  AND CONSTRAINT_TYPE IN ('C', 'U', 'P')
