SELECT
  NULL AS TABLE_CATALOG,
  TABLES.OWNER AS TABLE_SCHEMA,
  TABLES.TABLE_NAME,
  TABLES.TABLESPACE_NAME,
  TABLES.CLUSTER_NAME,
  TABLES.STATUS,
  TABLES.IOT_TYPE,
  TABLES.IOT_NAME
FROM
  ${catalogscope}_TABLES TABLES
  INNER JOIN ${catalogscope}_TAB_COMMENTS TAB_COMMENTS
    ON TABLES.OWNER = TAB_COMMENTS.OWNER
      AND TABLES.TABLE_NAME = TAB_COMMENTS.TABLE_NAME
  INNER JOIN ${catalogscope}_USERS USERS
    ON TABLES.OWNER = USERS.USERNAME
      AND USERS.ORACLE_MAINTAINED = 'N'
      AND NOT REGEXP_LIKE(USERS.USERNAME, '^APEX_[0-9]{6}$')
      AND NOT REGEXP_LIKE(USERS.USERNAME, '^FLOWS_[0-9]{5}$')
WHERE
  REGEXP_LIKE(TABLES.OWNER, '${schema-inclusion-rule}')
  AND REGEXP_LIKE(TABLES.OWNER || '.' || TABLES.TABLE_NAME, '${table-inclusion-rule}')
  AND TABLES.TABLE_NAME NOT LIKE 'BIN$%'
  AND NOT REGEXP_LIKE(TABLES.TABLE_NAME, '^(SYS_IOT|MDOS|MDRS|MDRT|MDOT|MDXT)_.*$')
ORDER BY
  TABLE_SCHEMA,
  TABLE_NAME
