/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.lint;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import schemacrawler.schema.AttributedObject;
import schemacrawler.schema.NamedObject;
import schemacrawler.tools.lint.Lint;

public final class LintCollector {
    private static final String LINT_KEY = "schemacrawler.lint";
    private final List<Lint<? extends Serializable>> lints = new ArrayList<Lint<? extends Serializable>>();

    public <N extends NamedObject & AttributedObject> void addLint(N namedObject, Lint<?> lint) {
        if (namedObject != null && lint != null && namedObject.getFullName().equals(lint.getObjectName())) {
            this.lints.add(lint);
            Collection columnLints = (Collection)((AttributedObject)namedObject).getAttribute(LINT_KEY, new ArrayList());
            columnLints.add(lint);
            ((AttributedObject)namedObject).setAttribute(LINT_KEY, (Object)columnLints);
        }
    }

    public Collection<Lint<? extends Serializable>> getLints() {
        this.lints.sort(Comparator.naturalOrder());
        return new ArrayList<Lint<? extends Serializable>>(this.lints);
    }

    public int size() {
        return this.lints.size();
    }
}

