/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.lint;

import java.io.Serializable;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.filter.TableTypesFilter;
import schemacrawler.inclusionrule.IncludeAll;
import schemacrawler.inclusionrule.InclusionRule;
import schemacrawler.schema.Catalog;
import schemacrawler.schema.Column;
import schemacrawler.schema.CrawlInfo;
import schemacrawler.schema.Table;
import schemacrawler.tools.lint.AbstractLinter;
import schemacrawler.tools.lint.LintCollector;
import schemacrawler.tools.lint.LintObjectType;
import schemacrawler.tools.lint.config.LinterConfig;
import us.fatehi.utility.property.PropertyName;
import us.fatehi.utility.string.StringFormat;

public abstract class BaseLinter
extends AbstractLinter {
    private static final Logger LOGGER = Logger.getLogger(BaseLinter.class.getName());
    private Catalog catalog;
    private InclusionRule tableInclusionRule;
    private InclusionRule columnInclusionRule;
    private TableTypesFilter tableTypesFilter;

    protected BaseLinter(PropertyName linterName, LintCollector lintCollector) {
        super(linterName, lintCollector);
        this.setTableTypesFilter(null);
        this.tableInclusionRule = new IncludeAll();
        this.columnInclusionRule = new IncludeAll();
    }

    protected final void addCatalogLint(String message) {
        this.addLint(LintObjectType.catalog, this.catalog, message, null);
    }

    protected final <V extends Serializable> void addCatalogLint(String message, V value) {
        this.addLint(LintObjectType.catalog, this.catalog, message, value);
    }

    protected final void addTableLint(Table table, String message) {
        this.addLint(LintObjectType.table, table, message, null);
    }

    protected final <V extends Serializable> void addTableLint(Table table, String message, V value) {
        this.addLint(LintObjectType.table, table, message, value);
    }

    protected void end(Connection connection) {
    }

    protected final List<Column> getColumns(Table table) {
        if (table == null) {
            return Collections.emptyList();
        }
        ArrayList<Column> columns = new ArrayList<Column>(table.getColumns());
        Iterator iterator = columns.iterator();
        while (iterator.hasNext()) {
            Column column = (Column)iterator.next();
            if (this.includeColumn(column)) continue;
            iterator.remove();
        }
        return columns;
    }

    protected final CrawlInfo getCrawlInfo() {
        return this.catalog.getCrawlInfo();
    }

    protected final TableTypesFilter getTableTypesFilter() {
        return this.tableTypesFilter;
    }

    protected final boolean includeColumn(Column column) {
        return column != null && this.columnInclusionRule.test((Object)column.getFullName());
    }

    protected final boolean includeTable(Table table) {
        return table != null && this.tableInclusionRule.test((Object)table.getFullName());
    }

    protected abstract void lint(Table var1, Connection var2);

    protected final void setTableTypesFilter(TableTypesFilter tableTypesFilter) {
        this.tableTypesFilter = tableTypesFilter == null ? new TableTypesFilter() : tableTypesFilter;
    }

    protected void start(Connection connection) {
    }

    @Override
    public final void configure(LinterConfig linterConfig) {
        super.configure(linterConfig);
        if (linterConfig != null) {
            this.tableInclusionRule = linterConfig.getTableInclusionRule();
            this.columnInclusionRule = linterConfig.getColumnInclusionRule();
        }
    }

    @Override
    public final void lint(Catalog catalog, Connection connection) {
        this.catalog = Objects.requireNonNull(catalog, "No catalog provided");
        this.start(connection);
        for (Table table : catalog.getTables()) {
            if (this.tableInclusionRule.test((Object)table.getFullName()) && this.tableTypesFilter.test(table)) {
                this.lint(table, connection);
                continue;
            }
            LOGGER.log(Level.FINE, (Supplier<String>)new StringFormat("Excluding table <%s> for lint <%s>", new Object[]{table, this.getLinterId()}));
        }
        this.end(connection);
        this.catalog = null;
    }
}

