/*
 * Decompiled with CFR 0.152.
 */
package com.instaclustr.cassandra.driver.auth;

import com.datastax.oss.driver.api.core.auth.AuthenticationException;
import com.datastax.oss.driver.api.core.config.DriverExecutionProfile;
import com.datastax.oss.driver.api.core.config.DriverOption;
import com.datastax.oss.driver.api.core.context.DriverContext;
import com.datastax.oss.driver.api.core.metadata.EndPoint;
import com.instaclustr.cassandra.driver.auth.KerberosAuthProviderBase;
import com.instaclustr.cassandra.driver.auth.ServerNameResolver;
import java.util.HashMap;
import java.util.Map;

public class KerberosAuthProvider
extends KerberosAuthProviderBase {
    private final DriverExecutionProfile config;

    public KerberosAuthProvider(DriverContext context) {
        super(context.getSessionName());
        this.config = context.getConfig().getDefaultProfile();
    }

    @Override
    protected KerberosAuthProviderBase.KerberosAuthOptions getOptions(EndPoint endPoint) {
        KerberosAuthProviderBase.KerberosAuthOptions.Builder optionsBuilder = KerberosAuthProviderBase.KerberosAuthOptions.builder();
        if (this.config.isDefined((DriverOption)KerberosAuthProviderBase.KerberosOption.AUTH_PROVIDER_AUTHORIZATION_ID)) {
            optionsBuilder.withAuthorizationId(this.config.getString((DriverOption)KerberosAuthProviderBase.KerberosOption.AUTH_PROVIDER_AUTHORIZATION_ID));
        }
        if (this.config.isDefined((DriverOption)KerberosAuthProviderBase.KerberosOption.AUTH_PROVIDER_SASL_PROPERTIES)) {
            HashMap saslProperties = new HashMap();
            for (Map.Entry entry : this.config.getStringMap((DriverOption)KerberosAuthProviderBase.KerberosOption.AUTH_PROVIDER_SASL_PROPERTIES).entrySet()) {
                saslProperties.put(entry.getKey(), entry.getValue());
            }
            optionsBuilder.withSaslProperties(saslProperties);
        }
        if (this.config.isDefined((DriverOption)KerberosAuthProviderBase.KerberosOption.AUTH_PROVIDER_SASL_PROTOCOL)) {
            optionsBuilder.withSaslProtocol(this.config.getString((DriverOption)KerberosAuthProviderBase.KerberosOption.AUTH_PROVIDER_SASL_PROTOCOL));
        }
        if (this.config.isDefined((DriverOption)KerberosAuthProviderBase.KerberosOption.AUTH_PROVIDER_SERVER_NAME_RESOLVER)) {
            String serverNameResolverClassName = this.config.getString((DriverOption)KerberosAuthProviderBase.KerberosOption.AUTH_PROVIDER_SERVER_NAME_RESOLVER);
            try {
                Class<ServerNameResolver> serverNameResolverClass = Class.forName(serverNameResolverClassName);
                if (!serverNameResolverClass.isAssignableFrom(ServerNameResolver.class)) {
                    throw new IllegalStateException(String.format("Class %s is not assignable from %s", serverNameResolverClassName, ServerNameResolver.class.getName()));
                }
                ServerNameResolver serverNameResolver = (ServerNameResolver)serverNameResolverClass.newInstance();
                optionsBuilder.withServerNameResolver(serverNameResolver);
            }
            catch (Exception ex) {
                throw new AuthenticationException(endPoint, "Unable to perform Kerberos authentication.", (Throwable)ex);
            }
        }
        return optionsBuilder.build();
    }
}

