/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.commandline.command;

import java.io.PrintStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import picocli.CommandLine;
import us.fatehi.utility.property.PropertyName;

abstract class BaseAvailableRegistryPlugins
implements Iterable<String> {
    private static final Pattern metaCommand = Pattern.compile("<.*>");
    protected final Collection<PropertyName> plugins;

    protected BaseAvailableRegistryPlugins(Collection<PropertyName> plugins) {
        this.plugins = Objects.requireNonNull(plugins, "No plugins provided");
    }

    public final boolean isEmpty() {
        return this.plugins.isEmpty();
    }

    @Override
    public final Iterator<String> iterator() {
        return this.stream().collect(Collectors.toList()).iterator();
    }

    public void print(PrintStream out) {
        if (!this.isEmpty() && out != null) {
            out.println();
            out.printf("Available %s:%n", this.getName());
            out.println(this.commands());
        }
    }

    public int size() {
        return this.plugins.size();
    }

    public final Stream<String> stream() {
        return this.plugins.stream().filter(Objects::nonNull).filter(plugin -> !metaCommand.matcher(plugin.getName()).matches()).map(PropertyName::getName);
    }

    protected abstract String getName();

    private final CommandLine.Help.TextTable commands() {
        CommandLine.Help.ColorScheme.Builder colorSchemaBuilder = new CommandLine.Help.ColorScheme.Builder();
        colorSchemaBuilder.ansi(CommandLine.Help.Ansi.OFF);
        CommandLine.Help.TextTable textTable = CommandLine.Help.TextTable.forColumns((CommandLine.Help.ColorScheme)colorSchemaBuilder.build(), (CommandLine.Help.Column[])new CommandLine.Help.Column[]{new CommandLine.Help.Column(15, 1, CommandLine.Help.Column.Overflow.SPAN), new CommandLine.Help.Column(65, 1, CommandLine.Help.Column.Overflow.WRAP)});
        for (PropertyName plugin : this.plugins) {
            textTable.addRowValues(new String[]{plugin.getName(), plugin.getDescription()});
        }
        return textTable;
    }
}

