/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.command.script;

import schemacrawler.tools.command.script.ScriptCommand;
import schemacrawler.tools.command.script.options.ScriptLanguageOptionsBuilder;
import schemacrawler.tools.command.script.options.ScriptOptions;
import schemacrawler.tools.executable.BaseCommandProvider;
import schemacrawler.tools.executable.commandline.PluginCommand;
import schemacrawler.tools.options.Config;
import schemacrawler.tools.options.OutputOptions;
import us.fatehi.utility.property.PropertyName;

public class ScriptCommandProvider
extends BaseCommandProvider {
    public static final String DESCRIPTION_HEADER = "Process a script file, such as JavaScript, against the database schema";

    public ScriptCommandProvider() {
        super(new PropertyName("script", DESCRIPTION_HEADER));
    }

    public PluginCommand getCommandLineCommand() {
        PluginCommand pluginCommand = PluginCommand.newPluginCommand((String)"script", (String)"** Process a script file, such as JavaScript, against the database schema");
        pluginCommand.addOption("script", String.class, new String[]{"Path to the script file or to the CLASSPATH resource"}).addOption("script-language", String.class, new String[]{"Scripting language"});
        return pluginCommand;
    }

    public ScriptCommand newSchemaCrawlerCommand(String command, Config config) {
        ScriptOptions scriptOptions = ScriptLanguageOptionsBuilder.builder().fromConfig(config).toOptions();
        ScriptCommand scCommand = new ScriptCommand();
        scCommand.setCommandOptions(scriptOptions);
        return scCommand;
    }

    public boolean supportsOutputFormat(String command, OutputOptions outputOptions) {
        return true;
    }
}

