/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.jdbc;

import com.amazon.redshift.core.Field;
import com.amazon.redshift.core.ParameterList;
import com.amazon.redshift.core.Query;
import com.amazon.redshift.core.ResultCursor;
import com.amazon.redshift.core.ResultHandlerBase;
import com.amazon.redshift.core.Tuple;
import com.amazon.redshift.core.v3.BatchedQuery;
import com.amazon.redshift.core.v3.RedshiftRowsBlockingQueue;
import com.amazon.redshift.jdbc.RedshiftResultSet;
import com.amazon.redshift.jdbc.RedshiftStatementImpl;
import com.amazon.redshift.jdbc.StatementCancelState;
import com.amazon.redshift.util.GT;
import com.amazon.redshift.util.RedshiftException;
import com.amazon.redshift.util.RedshiftState;
import java.sql.BatchUpdateException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class BatchResultHandler
extends ResultHandlerBase {
    private final RedshiftStatementImpl rsStatement;
    private int resultIndex = 0;
    private final Query[] queries;
    private final long[] longUpdateCounts;
    private final ParameterList[] parameterLists;
    private final boolean expectGeneratedKeys;
    private RedshiftResultSet generatedKeys;
    private int committedRows;
    private final List<List<Tuple>> allGeneratedRows;
    private List<Tuple> latestGeneratedRows;
    private RedshiftResultSet latestGeneratedKeysRs;

    BatchResultHandler(RedshiftStatementImpl rsStatement, Query[] queries, ParameterList[] parameterLists, boolean expectGeneratedKeys) {
        this.rsStatement = rsStatement;
        this.queries = queries;
        this.parameterLists = parameterLists;
        this.longUpdateCounts = new long[queries.length];
        this.expectGeneratedKeys = expectGeneratedKeys;
        this.allGeneratedRows = !expectGeneratedKeys ? null : new ArrayList();
    }

    @Override
    public void setStatementStateIdleFromInQuery() {
        this.rsStatement.updateStatementCancleState(StatementCancelState.IN_QUERY, StatementCancelState.IDLE);
    }

    @Override
    public void setStatementStateInQueryFromIdle() {
        this.rsStatement.updateStatementCancleState(StatementCancelState.IDLE, StatementCancelState.IN_QUERY);
    }

    @Override
    public void handleResultRows(Query fromQuery, Field[] fields, List<Tuple> tuples, ResultCursor cursor, RedshiftRowsBlockingQueue<Tuple> queueTuples, int[] rowCount, Thread ringBufferThread) {
        ++this.resultIndex;
        if (!this.expectGeneratedKeys) {
            return;
        }
        if (this.generatedKeys == null) {
            try {
                this.latestGeneratedKeysRs = (RedshiftResultSet)this.rsStatement.createResultSet(fromQuery, fields, new ArrayList<Tuple>(), cursor, queueTuples, rowCount, ringBufferThread);
            }
            catch (SQLException e) {
                this.handleError(e);
            }
        }
        this.latestGeneratedRows = tuples;
    }

    @Override
    public void handleCommandStatus(String status, long updateCount, long insertOID) {
        if (this.latestGeneratedRows != null) {
            --this.resultIndex;
            if (updateCount > 0L && (this.getException() == null || this.isAutoCommit())) {
                this.allGeneratedRows.add(this.latestGeneratedRows);
                if (this.generatedKeys == null) {
                    this.generatedKeys = this.latestGeneratedKeysRs;
                }
            }
            this.latestGeneratedRows = null;
        }
        if (this.resultIndex >= this.queries.length) {
            this.handleError(new RedshiftException(GT.tr("Too many update results were returned.", new Object[0]), RedshiftState.TOO_MANY_RESULTS));
            return;
        }
        this.latestGeneratedKeysRs = null;
        this.longUpdateCounts[this.resultIndex++] = updateCount;
    }

    private boolean isAutoCommit() {
        try {
            return this.rsStatement.getConnection().getAutoCommit();
        }
        catch (SQLException e) {
            assert (false) : "pgStatement.getConnection().getAutoCommit() should not throw";
            return false;
        }
    }

    @Override
    public void secureProgress() {
        if (this.isAutoCommit()) {
            this.committedRows = this.resultIndex;
            this.updateGeneratedKeys();
        }
    }

    private void updateGeneratedKeys() {
        if (this.allGeneratedRows == null || this.allGeneratedRows.isEmpty()) {
            return;
        }
        for (List<Tuple> rows : this.allGeneratedRows) {
            this.generatedKeys.addRows(rows);
        }
        this.allGeneratedRows.clear();
    }

    @Override
    public void handleWarning(SQLWarning warning) {
        this.rsStatement.addWarning(warning);
    }

    @Override
    public void handleError(SQLException newError) {
        if (this.getException() == null) {
            Arrays.fill(this.longUpdateCounts, this.committedRows, this.longUpdateCounts.length, -3L);
            if (this.allGeneratedRows != null) {
                this.allGeneratedRows.clear();
            }
            String queryString = "<unknown>";
            if (this.resultIndex < this.queries.length) {
                queryString = this.queries[this.resultIndex].toString(this.parameterLists[this.resultIndex]);
            }
            BatchUpdateException batchException = new BatchUpdateException(GT.tr("Batch entry {0} {1} was aborted: {2}  Call getNextException to see other errors in the batch.", this.resultIndex, queryString, newError.getMessage()), newError.getSQLState(), 0, this.uncompressLongUpdateCount(), (Throwable)newError);
            super.handleError(batchException);
        }
        ++this.resultIndex;
        super.handleError(newError);
    }

    @Override
    public void handleCompletion() throws SQLException {
        this.updateGeneratedKeys();
        SQLException batchException = this.getException();
        if (batchException != null) {
            if (this.isAutoCommit()) {
                BatchUpdateException newException = new BatchUpdateException(batchException.getMessage(), batchException.getSQLState(), 0, this.uncompressLongUpdateCount(), batchException.getCause());
                SQLException next = batchException.getNextException();
                if (next != null) {
                    newException.setNextException(next);
                }
                batchException = newException;
            }
            throw batchException;
        }
    }

    public ResultSet getGeneratedKeys() {
        return this.generatedKeys;
    }

    private int[] uncompressUpdateCount() {
        long[] original = this.uncompressLongUpdateCount();
        int[] copy = new int[original.length];
        for (int i = 0; i < original.length; ++i) {
            copy[i] = original[i] > Integer.MAX_VALUE ? -2 : (int)original[i];
        }
        return copy;
    }

    public int[] getUpdateCount() {
        return this.uncompressUpdateCount();
    }

    private long[] uncompressLongUpdateCount() {
        int batchSize;
        if (!(this.queries[0] instanceof BatchedQuery)) {
            return this.longUpdateCounts;
        }
        int totalRows = 0;
        boolean hasRewrites = false;
        for (Query query : this.queries) {
            batchSize = query.getBatchSize();
            totalRows += batchSize;
            hasRewrites |= batchSize > 1;
        }
        if (!hasRewrites) {
            return this.longUpdateCounts;
        }
        long[] newUpdateCounts = new long[totalRows];
        int offset = 0;
        for (int i = 0; i < this.queries.length; ++i) {
            Query query;
            query = this.queries[i];
            batchSize = query.getBatchSize();
            long superBatchResult = this.longUpdateCounts[i];
            if (batchSize == 1) {
                newUpdateCounts[offset++] = superBatchResult;
                continue;
            }
            if (superBatchResult > 0L) {
                superBatchResult = -2L;
            }
            Arrays.fill(newUpdateCounts, offset, offset + batchSize, superBatchResult);
            offset += batchSize;
        }
        return newUpdateCounts;
    }

    public long[] getLargeUpdateCount() {
        return this.uncompressLongUpdateCount();
    }
}

