/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.command.chatgpt.functions;

import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import schemacrawler.schema.DatabaseObject;
import schemacrawler.schema.Table;
import schemacrawler.schema.TableRelationshipType;
import schemacrawler.schema.View;
import schemacrawler.schemacrawler.IdentifierQuotingStrategy;
import schemacrawler.schemacrawler.Identifiers;
import schemacrawler.schemacrawler.IdentifiersBuilder;
import schemacrawler.tools.command.chatgpt.FunctionReturn;
import schemacrawler.tools.command.chatgpt.functions.TableReferencesFunctionParameters;

public class TableReferencesFunctionReturn
implements FunctionReturn {
    private static final String NEW_LINE = String.format("%n", new Object[0]);
    private static final Identifiers identifiers = IdentifiersBuilder.builder().withIdentifierQuotingStrategy(IdentifierQuotingStrategy.quote_all).toOptions();
    private final Table table;
    private final TableReferencesFunctionParameters.TableReferenceType tableReferenceType;

    protected TableReferencesFunctionReturn(Table table, TableReferencesFunctionParameters.TableReferenceType scope) {
        this.table = Objects.requireNonNull(table, "Table not provided");
        this.tableReferenceType = Objects.requireNonNull(scope, "Table description scope not provided");
    }

    @Override
    public String get() {
        switch (this.tableReferenceType) {
            case PARENT: {
                return this.renderTableRelationships(TableReferencesFunctionParameters.TableReferenceType.PARENT);
            }
            case CHILD: {
                return this.renderTableRelationships(TableReferencesFunctionParameters.TableReferenceType.CHILD);
            }
        }
        return this.renderTableRelationships(TableReferencesFunctionParameters.TableReferenceType.PARENT) + NEW_LINE + this.renderTableRelationships(TableReferencesFunctionParameters.TableReferenceType.CHILD);
    }

    private String noData(TableReferencesFunctionParameters.TableReferenceType tableReferenceType) {
        StringBuilder buffer = new StringBuilder();
        if (this.table instanceof View) {
            buffer.append("View ");
        } else {
            buffer.append("Table ");
        }
        buffer.append(identifiers.quoteFullName((DatabaseObject)this.table)).append(" has no ").append(tableReferenceType.name().toLowerCase()).append(" relationships.").append(NEW_LINE);
        return buffer.toString();
    }

    private String renderTableRelationships(TableReferencesFunctionParameters.TableReferenceType tableReferenceType) {
        Collection<Object> referencedTables;
        Objects.requireNonNull(tableReferenceType, "No table relationship type specified");
        switch (tableReferenceType) {
            case PARENT: {
                referencedTables = this.table.getRelatedTables(TableRelationshipType.parent);
                break;
            }
            case CHILD: {
                referencedTables = this.table.getRelatedTables(TableRelationshipType.child);
                break;
            }
            default: {
                referencedTables = Collections.emptyList();
            }
        }
        if (referencedTables.isEmpty()) {
            return this.noData(tableReferenceType);
        }
        StringBuilder buffer = new StringBuilder();
        this.tableName(buffer, tableReferenceType);
        for (Table table : referencedTables) {
            buffer.append(String.format("- %s", identifiers.quoteFullName((DatabaseObject)table))).append(NEW_LINE);
        }
        return buffer.toString();
    }

    private void tableName(StringBuilder buffer, TableReferencesFunctionParameters.TableReferenceType tableReferenceType) {
        Objects.requireNonNull(buffer);
        if (this.table instanceof View) {
            buffer.append("View ");
        } else {
            buffer.append("Table ");
        }
        buffer.append(identifiers.quoteFullName((DatabaseObject)this.table)).append(" has the following ").append(tableReferenceType.name().toLowerCase()).append(" tables:").append(NEW_LINE);
    }
}

