/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.command.chatgpt.functions;

import java.util.Optional;
import java.util.function.Function;
import schemacrawler.schema.Catalog;
import schemacrawler.schema.Table;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;
import schemacrawler.schemacrawler.SchemaCrawlerOptionsBuilder;
import schemacrawler.tools.command.chatgpt.FunctionReturn;
import schemacrawler.tools.command.chatgpt.functions.AbstractFunctionDefinition;
import schemacrawler.tools.command.chatgpt.functions.NoResultsReturn;
import schemacrawler.tools.command.chatgpt.functions.TableReferencesFunctionParameters;
import schemacrawler.tools.command.chatgpt.functions.TableReferencesFunctionReturn;
import schemacrawler.utility.MetaDataUtility;

public final class TableReferencesFunctionDefinition
extends AbstractFunctionDefinition<TableReferencesFunctionParameters> {
    public TableReferencesFunctionDefinition() {
        super("Gets the relationships of a database table, either child tables or parent tables. Child tables are also known as dependent tables or foreign key tables. Parent tables are also known as referenced tables, or primary key tables.", TableReferencesFunctionParameters.class);
    }

    @Override
    public Function<TableReferencesFunctionParameters, FunctionReturn> getExecutor() {
        return args -> {
            MetaDataUtility.reduceCatalog((Catalog)this.catalog, (SchemaCrawlerOptions)SchemaCrawlerOptionsBuilder.newSchemaCrawlerOptions());
            Optional<Table> firstMatchedTable = this.catalog.getTables().stream().filter(table -> table.getName().matches("(?i)" + args.getTableName())).findFirst();
            if (firstMatchedTable.isPresent()) {
                Table table2 = firstMatchedTable.get();
                return new TableReferencesFunctionReturn(table2, args.getTableReferenceType());
            }
            return new NoResultsReturn();
        };
    }
}

